/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TaskMonitorTmplImpl
extends AbstractTemplateImpl
implements TaskMonitorTmpl.Intf {
    private final TaskMonitor taskMonitor;
    private final String format;
    private final String filter;

    protected static TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(TaskMonitorTmpl.ImplData p_implData) {
        if (!p_implData.getTaskMonitor__IsNotDefault()) {
            p_implData.setTaskMonitor(TaskMonitor.get());
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        return p_implData;
    }

    public TaskMonitorTmplImpl(TemplateManager p_templateManager, TaskMonitorTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TaskMonitorTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.taskMonitor = p_implData.getTaskMonitor();
        this.format = p_implData.getFormat();
        this.filter = p_implData.getFilter();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        List<MonitoredTask> tasks = this.taskMonitor.getTasks();
        Iterator<MonitoredTask> iter = tasks.iterator();
        while (iter.hasNext()) {
            MonitoredTask t = iter.next();
            if (this.filter.equals("general")) {
                if (!(t instanceof MonitoredRPCHandler)) continue;
                iter.remove();
                continue;
            }
            if (this.filter.equals("handler")) {
                if (t instanceof MonitoredRPCHandler) continue;
                iter.remove();
                continue;
            }
            if (this.filter.equals("rpc")) {
                if (t instanceof MonitoredRPCHandler && ((MonitoredRPCHandler)t).isRPCRunning()) continue;
                iter.remove();
                continue;
            }
            if (!this.filter.equals("operation") || t instanceof MonitoredRPCHandler && ((MonitoredRPCHandler)t).isOperationRunning()) continue;
            iter.remove();
        }
        long now = System.currentTimeMillis();
        Collections.reverse(tasks);
        boolean first = true;
        if (this.format.equals("json")) {
            jamonWriter.write("\n[");
            for (MonitoredTask task : tasks) {
                if (first) {
                    first = false;
                } else {
                    jamonWriter.write(",");
                }
                Escaping.HTML.write(StandardEmitter.valueOf((String)task.toJSON()), jamonWriter);
            }
            jamonWriter.write("]\n");
        } else {
            jamonWriter.write("\n<h2>Tasks</h2>\n  <div id=\"tasks_menu\">\n    <a href=\"?filter=all\">Show All Monitored Tasks</a>\n    <a href=\"?filter=general\">Show non-RPC Tasks</a>\n    <a href=\"?filter=handler\">Show All RPC Handler Tasks</a>\n    <a href=\"?filter=rpc\">Show Active RPC Calls</a>\n    <a href=\"?filter=operation\">Show Client Operations</a>\n    <a href=\"?format=json&filter=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.filter), jamonWriter);
            jamonWriter.write("\">View as JSON</a>\n  </div>\n  ");
            if (tasks.isEmpty()) {
                jamonWriter.write("\n    No tasks currently running on this node.\n  ");
            } else {
                jamonWriter.write("\n    <table>\n    <tr>\n      <th>Start Time</th>\n      <th>Description</th>\n      <th>State</th>\n      <th>Status</th>\n    </tr>\n    ");
                for (MonitoredTask task : tasks) {
                    jamonWriter.write("\n    <tr class=\"task-monitor-");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)((Object)task.getState())), jamonWriter);
                    jamonWriter.write("\">\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(task.getStartTime())), jamonWriter);
                    jamonWriter.write("</td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)task.getDescription()), jamonWriter);
                    jamonWriter.write("</td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)((Object)task.getState())), jamonWriter);
                    jamonWriter.write("\n          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.formatTimeDiff((long)now, (long)task.getStateTime())), jamonWriter);
                    jamonWriter.write(" ago)\n      </td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)task.getStatus()), jamonWriter);
                    jamonWriter.write("\n          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.formatTimeDiff((long)now, (long)task.getStatusTime())), jamonWriter);
                    jamonWriter.write(" \n          ago)</td>\n    </tr>\n    ");
                }
                jamonWriter.write("\n    </table>\n\n  ");
            }
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
    }
}

