/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HLogLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class SnapshotLogSplitter
implements Closeable {
    static final Log LOG = LogFactory.getLog(SnapshotLogSplitter.class);
    private final Map<byte[], LogWriter> regionLogWriters = new TreeMap<byte[], LogWriter>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], byte[]> regionsMap;
    private final Configuration conf;
    private final byte[] snapshotTableName;
    private final byte[] tableName;
    private final Path tableDir;
    private final FileSystem fs;

    public SnapshotLogSplitter(Configuration conf, FileSystem fs, Path tableDir, byte[] snapshotTableName, Map<byte[], byte[]> regionsMap) {
        this.regionsMap = regionsMap;
        this.snapshotTableName = snapshotTableName;
        this.tableName = Bytes.toBytes(tableDir.getName());
        this.tableDir = tableDir;
        this.conf = conf;
        this.fs = fs;
    }

    @Override
    public void close() throws IOException {
        for (LogWriter writer : this.regionLogWriters.values()) {
            writer.close();
        }
    }

    public void splitLog(String serverName, String logfile) throws IOException {
        LOG.debug((Object)("Restore log=" + logfile + " server=" + serverName + " for snapshotTable=" + Bytes.toString(this.snapshotTableName) + " to table=" + Bytes.toString(this.tableName)));
        this.splitLog(new HLogLink(this.conf, serverName, logfile).getAvailablePath(this.fs));
    }

    public void splitRecoveredEdit(Path editPath) throws IOException {
        LOG.debug((Object)("Restore recover.edits=" + editPath + " for snapshotTable=" + Bytes.toString(this.snapshotTableName) + " to table=" + Bytes.toString(this.tableName)));
        this.splitLog(editPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitLog(Path logPath) throws IOException {
        HLog.Reader log = HLog.getReader(this.fs, logPath, this.conf);
        try {
            HLog.Entry entry;
            LogWriter writer = null;
            byte[] regionName = null;
            byte[] newRegionName = null;
            while ((entry = log.next()) != null) {
                HLogKey key = entry.getKey();
                if (!Bytes.equals(key.getTablename(), this.snapshotTableName)) continue;
                if (!Bytes.equals(regionName, key.getEncodedRegionName())) {
                    regionName = (byte[])key.getEncodedRegionName().clone();
                    newRegionName = this.regionsMap.get(regionName);
                    if (newRegionName == null) {
                        newRegionName = regionName;
                    }
                    writer = this.getOrCreateWriter(newRegionName, key.getLogSeqNum());
                    LOG.debug((Object)("+ regionName=" + Bytes.toString(regionName)));
                }
                key = new HLogKey(newRegionName, this.tableName, key.getLogSeqNum(), key.getWriteTime(), key.getClusterId());
                writer.append(new HLog.Entry(key, entry.getEdit()));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Something wrong during the log split", (Throwable)e);
        }
        finally {
            log.close();
        }
    }

    private LogWriter getOrCreateWriter(byte[] regionName, long seqId) throws IOException {
        LogWriter writer = this.regionLogWriters.get(regionName);
        if (writer == null) {
            Path regionDir = HRegion.getRegionDir(this.tableDir, Bytes.toString(regionName));
            Path dir = HLog.getRegionDirRecoveredEditsDir(regionDir);
            this.fs.mkdirs(dir);
            writer = new LogWriter(this.conf, this.fs, dir, seqId);
            this.regionLogWriters.put(regionName, writer);
        }
        return writer;
    }

    private final class LogWriter
    implements Closeable {
        private HLog.Writer writer;
        private Path logFile;
        private long seqId;

        public LogWriter(Configuration conf, FileSystem fs, Path logDir, long seqId) throws IOException {
            this.logFile = new Path(logDir, this.logFileName(seqId, true));
            this.writer = HLog.createWriter(fs, this.logFile, conf);
            this.seqId = seqId;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            Path finalFile = new Path(this.logFile.getParent(), this.logFileName(this.seqId, false));
            LOG.debug((Object)("LogWriter tmpLogFile=" + this.logFile + " -> logFile=" + finalFile));
            SnapshotLogSplitter.this.fs.rename(this.logFile, finalFile);
        }

        public void append(HLog.Entry entry) throws IOException {
            this.writer.append(entry);
            if (this.seqId < entry.getKey().getLogSeqNum()) {
                this.seqId = entry.getKey().getLogSeqNum();
            }
        }

        private String logFileName(long seqId, boolean temp) {
            String fileName = String.format("%019d", seqId);
            if (temp) {
                fileName = fileName + ".temp";
            }
            return fileName;
        }
    }
}

