/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Decoder;
import org.apache.hadoop.hbase.codec.Encoder;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALEditCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

public class WALEdit
implements Writable,
HeapSize {
    private static final String PREFIX_CLUSTER_KEY = ".";
    private final int VERSION_2 = -1;
    private final ArrayList<KeyValue> kvs = new ArrayList(1);
    private final NavigableMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
    private WALEditCodec codec = new WALEditCodec();

    public void setCompressionContext(CompressionContext compression) {
        this.codec.setCompression(compression);
    }

    public void setCodec(WALEditCodec codec) {
        this.codec = codec;
    }

    public void add(KeyValue kv) {
        this.kvs.add(kv);
    }

    public boolean isEmpty() {
        return this.kvs.isEmpty();
    }

    public int size() {
        return this.kvs.size();
    }

    public List<KeyValue> getKeyValues() {
        return this.kvs;
    }

    public Integer getFromScope(byte[] key) {
        return (Integer)this.scopes.get(key);
    }

    @Deprecated
    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    @Deprecated
    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes.clear();
        this.scopes.putAll(scopes);
    }

    public void putIntoScope(byte[] key, Integer value) {
        this.scopes.put(key, value);
    }

    public boolean hasKeyInScope(byte[] key) {
        return this.scopes.containsKey(key);
    }

    public boolean hasClusterId(UUID clusterId) {
        return this.hasKeyInScope(Bytes.toBytes(PREFIX_CLUSTER_KEY + clusterId.toString()));
    }

    public void addClusterId(UUID clusterId) {
        this.scopes.put(Bytes.toBytes(PREFIX_CLUSTER_KEY + clusterId.toString()), 1);
    }

    public void addClusterIds(List<UUID> clusterIds) {
        for (UUID clusterId : clusterIds) {
            this.addClusterId(clusterId);
        }
    }

    public List<UUID> getClusterIds() {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        for (byte[] keyBytes : this.scopes.keySet()) {
            String key = Bytes.toString(keyBytes);
            if (!key.startsWith(PREFIX_CLUSTER_KEY)) continue;
            clusterIds.add(UUID.fromString(key.substring(PREFIX_CLUSTER_KEY.length())));
        }
        return clusterIds;
    }

    public void readFields(DataInput in) throws IOException {
        int numEntries;
        int versionOrLength;
        this.kvs.clear();
        this.scopes.clear();
        Decoder decoder = this.codec.getDecoder((DataInputStream)in);
        int length = versionOrLength = in.readInt();
        if (versionOrLength == -1) {
            length = in.readInt();
        }
        this.kvs.ensureCapacity(length);
        for (int i = 0; i < length && decoder.advance(); ++i) {
            this.kvs.add(decoder.current());
        }
        if (versionOrLength == -1 && (numEntries = in.readInt()) > 0) {
            for (int i = 0; i < numEntries; ++i) {
                byte[] key = Bytes.readByteArray(in);
                int scope = in.readInt();
                this.scopes.put(key, scope);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        Encoder kvEncoder = this.codec.getEncoder((DataOutputStream)out);
        out.writeInt(-1);
        out.writeInt(this.kvs.size());
        for (KeyValue kv : this.kvs) {
            kvEncoder.write(kv);
        }
        kvEncoder.flush();
        out.writeInt(this.scopes.size());
        for (byte[] key : this.scopes.keySet()) {
            Bytes.writeByteArray(out, key);
            out.writeInt((Integer)this.scopes.get(key));
        }
    }

    @Override
    public long heapSize() {
        long ret = ClassSize.ARRAYLIST;
        for (KeyValue kv : this.kvs) {
            ret += kv.heapSize();
        }
        ret += (long)ClassSize.TREEMAP;
        return ret += (long)ClassSize.align(this.scopes.size() * ClassSize.MAP_ENTRY);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.kvs.size() + " = <");
        for (KeyValue kv : this.kvs) {
            sb.append(kv.toString());
            sb.append("; ");
        }
        sb.append(" scopes: " + this.scopes.toString());
        sb.append(">]");
        return sb.toString();
    }
}

