/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanWildcardColumnTracker
implements ColumnTracker {
    private byte[] columnBuffer = null;
    private int columnOffset = 0;
    private int columnLength = 0;
    private int currentCount = 0;
    private int maxVersions;
    private int minVersions;
    private long latestTSOfCurrentColumn;
    private byte latestTypeOfCurrentColumn;
    private long oldestStamp;

    public ScanWildcardColumnTracker(int minVersion, int maxVersion, long oldestUnexpiredTS) {
        this.maxVersions = maxVersion;
        this.minVersions = minVersion;
        this.oldestStamp = oldestUnexpiredTS;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length, byte type) throws IOException {
        return ScanQueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkVersions(byte[] bytes, int offset, int length, long timestamp, byte type, boolean ignoreCount) throws IOException {
        if (this.columnBuffer == null) {
            this.resetBuffer(bytes, offset, length);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(type, timestamp);
        }
        int cmp = Bytes.compareTo(bytes, offset, length, this.columnBuffer, this.columnOffset, this.columnLength);
        if (cmp == 0) {
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            if (this.sameAsPreviousTSAndType(timestamp, type)) {
                return ScanQueryMatcher.MatchCode.SKIP;
            }
            return this.checkVersion(type, timestamp);
        }
        this.resetTSAndType();
        if (cmp > 0) {
            this.resetBuffer(bytes, offset, length);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(type, timestamp);
        }
        throw new IOException("ScanWildcardColumnTracker.checkColumn ran into a column actually smaller than the previous column: " + Bytes.toStringBinary(bytes, offset, length));
    }

    private void resetBuffer(byte[] bytes, int offset, int length) {
        this.columnBuffer = bytes;
        this.columnOffset = offset;
        this.columnLength = length;
        this.currentCount = 0;
    }

    private ScanQueryMatcher.MatchCode checkVersion(byte type, long timestamp) {
        if (!KeyValue.isDelete(type)) {
            ++this.currentCount;
        }
        if (this.currentCount > this.maxVersions) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        if (this.currentCount <= this.minVersions || !this.isExpired(timestamp)) {
            this.setTSAndType(timestamp, type);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public void reset() {
        this.columnBuffer = null;
        this.resetTSAndType();
    }

    private void resetTSAndType() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
        this.latestTypeOfCurrentColumn = 0;
    }

    private void setTSAndType(long timestamp, byte type) {
        this.latestTSOfCurrentColumn = timestamp;
        this.latestTypeOfCurrentColumn = type;
    }

    private boolean sameAsPreviousTSAndType(long timestamp, byte type) {
        return timestamp == this.latestTSOfCurrentColumn && type == this.latestTypeOfCurrentColumn;
    }

    private boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public boolean done() {
        return false;
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(byte[] bytes, int offset, int qualLength) {
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public boolean isDone(long timestamp) {
        return this.minVersions <= 0 && this.isExpired(timestamp);
    }
}

