/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.util.Bytes;

public class RegionServerAccounting {
    private final AtomicLong atomicGlobalMemstoreSize = new AtomicLong(0L);
    private final ConcurrentMap<byte[], AtomicLong> replayEditsPerRegion = new ConcurrentSkipListMap<byte[], AtomicLong>(Bytes.BYTES_COMPARATOR);

    public long getGlobalMemstoreSize() {
        return this.atomicGlobalMemstoreSize.get();
    }

    public long addAndGetGlobalMemstoreSize(long memStoreSize) {
        return this.atomicGlobalMemstoreSize.addAndGet(memStoreSize);
    }

    public long addAndGetRegionReplayEditsSize(byte[] regionName, long memStoreSize) {
        AtomicLong replayEdistsSize = (AtomicLong)this.replayEditsPerRegion.get(regionName);
        if (replayEdistsSize == null) {
            replayEdistsSize = new AtomicLong(0L);
            this.replayEditsPerRegion.put(regionName, replayEdistsSize);
        }
        return replayEdistsSize.addAndGet(memStoreSize);
    }

    public long rollbackRegionReplayEditsSize(byte[] regionName) {
        AtomicLong replayEditsSize = (AtomicLong)this.replayEditsPerRegion.get(regionName);
        long editsSizeLong = 0L;
        if (replayEditsSize != null) {
            editsSizeLong = -replayEditsSize.get();
            this.clearRegionReplayEditsSize(regionName);
        }
        return this.addAndGetGlobalMemstoreSize(editsSizeLong);
    }

    public void clearRegionReplayEditsSize(byte[] regionName) {
        this.replayEditsPerRegion.remove(regionName);
    }
}

