/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.zookeeper.KeeperException;

public class Import {
    private static final Log LOG = LogFactory.getLog(Import.class);
    static final String NAME = "import";
    static final String CF_RENAME_PROP = "HBASE_IMPORTER_RENAME_CFS";
    static final String BULK_OUTPUT_CONF_KEY = "import.bulk.output";
    static final String FILTER_CLASS_CONF_KEY = "import.filter.class";
    static final String FILTER_ARGS_CONF_KEY = "import.filter.args";
    private static Filter filter;

    private static Filter instantiateFilter(Configuration conf) {
        Class filterClass = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
        if (filterClass == null) {
            LOG.debug((Object)"No configured filter class, accepting all keyvalues.");
            return null;
        }
        LOG.debug((Object)("Attempting to create filter:" + filterClass));
        try {
            Method m = filterClass.getMethod("createFilterFromArguments", ArrayList.class);
            return (Filter)m.invoke(null, Import.getFilterArgs(conf));
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static ArrayList<byte[]> getFilterArgs(Configuration conf) {
        String[] sargs;
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (String arg : sargs = conf.getStrings(FILTER_ARGS_CONF_KEY)) {
            args.add(Bytes.toBytes("'" + arg + "'"));
        }
        return args;
    }

    private static KeyValue filterKv(KeyValue kv) {
        if (filter != null) {
            Filter.ReturnCode code = filter.filterKeyValue(kv);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Filter returned:" + (Object)((Object)code) + " for the key value:" + kv));
            }
            if (!code.equals((Object)Filter.ReturnCode.INCLUDE) && !code.equals((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL)) {
                return null;
            }
        }
        return kv;
    }

    private static KeyValue convertKv(KeyValue kv, Map<byte[], byte[]> cfRenameMap) {
        byte[] newCfName;
        if (cfRenameMap != null && (newCfName = cfRenameMap.get(kv.getFamily())) != null) {
            kv = new KeyValue(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), newCfName, 0, newCfName.length, kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getType()), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        }
        return kv;
    }

    private static Map<byte[], byte[]> createCfRenameMap(Configuration conf) {
        TreeMap<byte[], byte[]> cfRenameMap = null;
        String allMappingsPropVal = conf.get(CF_RENAME_PROP);
        if (allMappingsPropVal != null) {
            String[] allMappings;
            for (String mapping : allMappings = allMappingsPropVal.split(",")) {
                String[] srcAndDest;
                if (cfRenameMap == null) {
                    cfRenameMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
                }
                if ((srcAndDest = mapping.split(":")).length != 2) continue;
                cfRenameMap.put(srcAndDest[0].getBytes(), srcAndDest[1].getBytes());
            }
        }
        return cfRenameMap;
    }

    public static void configureCfRenaming(Configuration conf, Map<String, String> renameMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : renameMap.entrySet()) {
            String sourceCf = entry.getKey();
            String destCf = entry.getValue();
            if (sourceCf.contains(":") || sourceCf.contains(",") || destCf.contains(":") || destCf.contains(",")) {
                throw new IllegalArgumentException("Illegal character in CF names: " + sourceCf + ", " + destCf);
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sourceCf + ":" + destCf);
        }
        conf.set(CF_RENAME_PROP, sb.toString());
    }

    public static void addFilterAndArguments(Configuration conf, Class<? extends Filter> clazz, List<String> args) {
        conf.set(FILTER_CLASS_CONF_KEY, clazz.getName());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            builder.append(arg);
            if (i == args.size() - 1) continue;
            builder.append(",");
        }
        conf.set(FILTER_ARGS_CONF_KEY, builder.toString());
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path inputDir = new Path(args[1]);
        Job job = new Job(conf, "import_" + tableName);
        job.setJarByClass(Importer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(SequenceFileInputFormat.class);
        String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
        try {
            Class filter = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
            if (filter != null) {
                TableMapReduceUtil.addDependencyJars(conf, filter);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (hfileOutPath != null) {
            job.setMapperClass(KeyValueImporter.class);
            HTable table = new HTable(conf, tableName);
            job.setReducerClass(KeyValueSortReducer.class);
            Path outputDir = new Path(hfileOutPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
            HFileOutputFormat.configureIncrementalLoad(job, table);
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), Preconditions.class);
        } else {
            job.setMapperClass(Importer.class);
            TableMapReduceUtil.initTableReducerJob(tableName, null, job);
            job.setNumReduceTasks(0);
        }
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Import [options] <tablename> <inputdir>");
        System.err.println("By default Import will load data directly into HBase. To instead generate");
        System.err.println("HFiles of data to prepare for a bulk data load, pass the option:");
        System.err.println("  -Dimport.bulk.output=/path/for/output");
        System.err.println(" To apply a generic org.apache.hadoop.hbase.filter.Filter to the input, use");
        System.err.println("  -Dimport.filter.class=<name of filter class>");
        System.err.println("  -Dimport.filter.args=<comma separated list of args for filter");
        System.err.println(" NOTE: The filter will be applied BEFORE doing key renames via the HBASE_IMPORTER_RENAME_CFS property. Futher, filters will only use the Filter#filterRowKey(byte[] buffer, int offset, int length) method to identify  whether the current row needs to be ignored completely for processing and Filter#filterKeyValue(KeyValue) method to determine if the KeyValue should be added; Filter.ReturnCode#INCLUDE and #INCLUDE_AND_NEXT_COL will be considered as including the KeyValue.");
        System.err.println("For performance consider the following options:\n  -Dmapred.map.tasks.speculative.execution=false\n  -Dmapred.reduce.tasks.speculative.execution=false");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Import.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        System.exit((job = Import.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class Importer
    extends TableMapper<ImmutableBytesWritable, Mutation> {
        private Map<byte[], byte[]> cfRenameMap;
        private UUID clusterId;

        Importer() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                this.writeResult(row, value, context);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void writeResult(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException, InterruptedException {
            Mutation put2 = null;
            Mutation delete = null;
            if (filter == null || !filter.filterRowKey(key.get(), key.getOffset(), key.getLength())) {
                for (KeyValue kv : result.raw()) {
                    if ((kv = Import.filterKv(kv)) == null) continue;
                    if ((kv = Import.convertKv(kv, this.cfRenameMap)).isDelete()) {
                        if (delete == null) {
                            delete = new Delete(key.get());
                        }
                        ((Delete)delete).addDeleteMarker(kv);
                        continue;
                    }
                    if (put2 == null) {
                        put2 = new Put(key.get());
                    }
                    ((Put)put2).add(kv);
                }
                if (put2 != null) {
                    put2.setClusterId(this.clusterId);
                    context.write((Object)key, (Object)put2);
                }
                if (delete != null) {
                    delete.setClusterId(this.clusterId);
                    context.write((Object)key, (Object)delete);
                }
            }
        }

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.cfRenameMap = Import.createCfRenameMap(conf);
            filter = Import.instantiateFilter(conf);
            try {
                HConnection connection = HConnectionManager.getConnection(conf);
                ZooKeeperWatcher zkw = connection.getZooKeeperWatcher();
                ReplicationZookeeper zkHelper = new ReplicationZookeeper(connection, conf, zkw);
                this.clusterId = zkHelper.getUUIDForCluster(zkw);
            }
            catch (ZooKeeperConnectionException e) {
                LOG.error((Object)"Problem connecting to ZooKeper during task setup", (Throwable)e);
            }
            catch (KeeperException e) {
                LOG.error((Object)"Problem reading ZooKeeper data during task setup", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Problem setting up task", (Throwable)e);
            }
        }
    }

    static class KeyValueImporter
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        private Map<byte[], byte[]> cfRenameMap;

        KeyValueImporter() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                if (filter == null || !filter.filterRowKey(row.get(), row.getOffset(), row.getLength())) {
                    for (KeyValue kv : value.raw()) {
                        if ((kv = Import.filterKv(kv)) == null) continue;
                        context.write((Object)row, (Object)Import.convertKv(kv, this.cfRenameMap));
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) {
            this.cfRenameMap = Import.createCfRenameMap(context.getConfiguration());
            filter = Import.instantiateFilter(context.getConfiguration());
        }
    }
}

