/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.ConnectionHeader;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.ResponseFlag;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class HBaseClient {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseClient");
    protected final PoolMap<ConnectionId, Connection> connections;
    protected final Class<? extends Writable> valueClass;
    protected int counter;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final Configuration conf;
    protected final int maxIdleTime;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected int pingInterval;
    protected int socketTimeout;
    protected final InetSocketAddress bindAddress;
    protected FailedServers failedServers;
    protected final SocketFactory socketFactory;
    protected String clusterId;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    private static final String SOCKET_TIMEOUT = "ipc.socket.timeout";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    static final int PING_CALL_ID = -1;
    public static final String FAILED_SERVER_EXPIRY_KEY = "hbase.ipc.client.failed.servers.expiry";
    public static final int FAILED_SERVER_EXPIRY_DEFAULT = 2000;

    public static void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    public static void setSocketTimeout(Configuration conf, int socketTimeout) {
        conf.setInt(SOCKET_TIMEOUT, socketTimeout);
    }

    static int getSocketTimeout(Configuration conf) {
        return conf.getInt(SOCKET_TIMEOUT, 20000);
    }

    protected Connection createConnection(ConnectionId remoteId) throws IOException {
        return new Connection(remoteId);
    }

    public HBaseClient(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.maxIdleTime = conf.getInt("hbase.ipc.client.connection.maxidletime", 10000);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = conf.getInt("hbase.client.pause", 1000);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", false);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.pingInterval = HBaseClient.getPingInterval(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The ping interval is" + this.pingInterval + "ms."));
        }
        this.conf = conf;
        this.socketFactory = factory;
        this.clusterId = conf.get("hbase.cluster.id", "default");
        this.connections = new PoolMap(HBaseClient.getPoolType(conf), HBaseClient.getPoolSize(conf));
        String hostName = this.conf.get("hbase.regionserver.rpc.client.socket.bind.address");
        this.bindAddress = hostName != null ? new InetSocketAddress(hostName, 0) : null;
        this.failedServers = new FailedServers(conf);
    }

    public HBaseClient(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory((Configuration)conf));
    }

    protected static PoolMap.PoolType getPoolType(Configuration config) {
        return PoolMap.PoolType.valueOf(config.get("hbase.client.ipc.pool.type"), PoolMap.PoolType.RoundRobin, PoolMap.PoolType.ThreadLocal);
    }

    protected static int getPoolSize(Configuration config) {
        return config.getInt("hbase.client.ipc.pool.size", 1);
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Writable call(Writable param, InetSocketAddress address) throws IOException, InterruptedException {
        return this.call(param, address, null, 0);
    }

    public Writable call(Writable param, InetSocketAddress addr, User ticket, int rpcTimeout) throws IOException, InterruptedException {
        return this.call(param, addr, null, ticket, rpcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, InetSocketAddress addr, Class<? extends VersionedProtocol> protocol, User ticket, int rpcTimeout) throws InterruptedException, IOException {
        Call call = new Call(param);
        Connection connection = this.getConnection(addr, protocol, ticket, rpcTimeout, call);
        connection.sendParam(call);
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                if (connection.shouldCloseConnection.get()) {
                    throw new IOException("Unexpected closed connection");
                }
                try {
                    call.wait(1000L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return call.value;
        }
    }

    protected IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    @Deprecated
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException, InterruptedException {
        return this.call(params, addresses, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses, Class<? extends VersionedProtocol> protocol, User ticket) throws IOException, InterruptedException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    Connection connection = this.getConnection(addresses[i], protocol, ticket, 0, call);
                    connection.sendParam(call);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + e.getMessage()), (Throwable)e);
                    --results.size;
                }
            }
            while (results.count != results.size) {
                try {
                    results.wait();
                }
                catch (InterruptedException ignored) {}
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(InetSocketAddress addr, Class<? extends VersionedProtocol> protocol, User ticket, int rpcTimeout, Call call) throws IOException, InterruptedException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        ConnectionId remoteId = new ConnectionId(addr, protocol, ticket, rpcTimeout);
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = this.createConnection(remoteId);
                this.connections.put(remoteId, connection);
            }
        }
        connection.addCall(call);
        connection.setupIOstreams();
        return connection;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    protected static class ConnectionId {
        final InetSocketAddress address;
        final User ticket;
        final int rpcTimeout;
        Class<? extends VersionedProtocol> protocol;
        private static final int PRIME = 16777619;

        ConnectionId(InetSocketAddress address, Class<? extends VersionedProtocol> protocol, User ticket, int rpcTimeout) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<? extends VersionedProtocol> getProtocol() {
            return this.protocol;
        }

        User getTicket() {
            return this.ticket;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.protocol == id.protocol && (this.ticket != null && this.ticket.equals(id.ticket) || this.ticket == id.ticket) && this.rpcTimeout == id.rpcTimeout;
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode() + 16777619 * (16777619 * System.identityHashCode(this.protocol) ^ (this.ticket == null ? 0 : this.ticket.hashCode())) ^ this.rpcTimeout;
        }
    }

    protected static class ParallelResults {
        protected final Writable[] values;
        protected int size;
        protected int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        synchronized void callComplete(ParallelCall call) {
            this.values[call.index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    protected class ParallelCall
    extends Call {
        private final ParallelResults results;
        protected final int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        @Override
        protected void callComplete() {
            this.results.callComplete(this);
        }
    }

    public static class CallTimeoutException
    extends IOException {
        public CallTimeoutException(String msg) {
            super(msg);
        }
    }

    protected class Connection
    extends Thread {
        private ConnectionHeader header;
        protected ConnectionId remoteId;
        protected Socket socket = null;
        protected DataInputStream in;
        protected DataOutputStream out;
        protected final ConcurrentSkipListMap<Integer, Call> calls = new ConcurrentSkipListMap();
        protected final AtomicLong lastActivity = new AtomicLong();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        protected IOException closeException;

        Connection(ConnectionId remoteId) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.remoteId = remoteId;
            User ticket = remoteId.getTicket();
            Class<? extends VersionedProtocol> protocol = remoteId.getProtocol();
            this.header = new ConnectionHeader(protocol == null ? null : protocol.getName(), ticket);
            this.setName("IPC Client (" + HBaseClient.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getName()));
            this.setDaemon(true);
        }

        protected void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                if (this.closeException == null) {
                    call.setException(new IOException("Call " + call.id + " not added as the connection " + this.remoteId + " is closing"));
                } else {
                    call.setException(this.closeException);
                }
                Call call2 = call;
                synchronized (call2) {
                    call.notifyAll();
                }
            } else {
                this.calls.put(call.id, call);
                this.notify();
            }
        }

        protected synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = HBaseClient.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(HBaseClient.this.tcpNoDelay);
                    this.socket.setKeepAlive(HBaseClient.this.tcpKeepAlive);
                    if (HBaseClient.this.bindAddress != null) {
                        this.socket.bind(HBaseClient.this.bindAddress);
                    }
                    NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)HBaseClient.getSocketTimeout(HBaseClient.this.conf));
                    if (this.remoteId.rpcTimeout > 0) {
                        HBaseClient.this.pingInterval = this.remoteId.rpcTimeout;
                    }
                    this.socket.setSoTimeout(HBaseClient.this.pingInterval);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, HBaseClient.this.maxRetries, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, HBaseClient.this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        protected synchronized void setupIOstreams() throws IOException, InterruptedException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            if (HBaseClient.this.failedServers.isFailedServer(this.remoteId.getAddress())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not trying to connect to " + this.remoteId.getAddress() + " this server is in the failed servers list"));
                }
                FailedServerException e = new FailedServerException("This server is in the failed servers list: " + this.remoteId.getAddress());
                this.markClosed(e);
                this.close();
                throw e;
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connecting to " + this.remoteId));
                }
                this.setupConnection();
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream((InputStream)NetUtils.getInputStream((Socket)this.socket))));
                this.out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)this.socket, (long)HBaseClient.this.pingInterval)));
                this.writeHeader();
                this.touch();
                this.start();
            }
            catch (Throwable t) {
                HBaseClient.this.failedServers.addToFailedServers(this.remoteId.address);
                IOException e = t instanceof IOException ? (IOException)t : new IOException("Could not set up IO Streams", t);
                this.markClosed(e);
                this.close();
                throw e;
            }
        }

        protected void closeConnection() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close a socket", (Throwable)e);
                }
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(HBaseClient.this.failureSleep);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + HBaseClient.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        private void writeHeader() throws IOException {
            this.out.write(HBaseServer.HEADER.array());
            this.out.write(3);
            DataOutputBuffer buf = new DataOutputBuffer();
            this.header.write((DataOutput)buf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        protected synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get() && (timeout = (long)HBaseClient.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)HBaseClient.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, having connections " + HBaseClient.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.receiveResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)"Unexpected exception receiving call responses", t);
                this.markClosed(new IOException("Unexpected exception receiving call responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, remaining connections " + HBaseClient.this.connections.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendParam(Call call) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            DataOutputBuffer d = new DataOutputBuffer();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " sending #" + call.id));
                }
                d.writeInt(-559038737);
                d.writeInt(call.id);
                call.param.write((DataOutput)d);
                byte[] data = d.getData();
                int dataLength = d.getLength();
                Bytes.putInt(data, 0, dataLength - 4);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.write(data, 0, dataLength);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                Connection connection = this;
                synchronized (connection) {
                    if (!this.shouldCloseConnection.get()) {
                        this.markClosed(e);
                        this.interrupt();
                    }
                }
            }
            finally {
                IOUtils.closeStream((Closeable)d);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receiveResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int id = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + id));
                }
                Call call = this.calls.get(id);
                byte flag = this.in.readByte();
                boolean isError = ResponseFlag.isError(flag);
                if (ResponseFlag.isLength(flag)) {
                    this.in.readInt();
                }
                int state = this.in.readInt();
                if (isError) {
                    if (call != null) {
                        call.setException((IOException)((Object)new RemoteException(WritableUtils.readString((DataInput)this.in), WritableUtils.readString((DataInput)this.in))));
                    }
                } else {
                    Writable value = (Writable)ReflectionUtils.newInstance(HBaseClient.this.valueClass, (Configuration)HBaseClient.this.conf);
                    value.readFields((DataInput)this.in);
                    if (call != null) {
                        call.setValue(value);
                    }
                }
                this.calls.remove(id);
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException && this.remoteId.rpcTimeout > 0) {
                    this.closeException = e;
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                if (this.remoteId.rpcTimeout > 0) {
                    this.cleanupCalls(this.remoteId.rpcTimeout);
                }
            }
        }

        protected synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            PoolMap<ConnectionId, Connection> poolMap = HBaseClient.this.connections;
            synchronized (poolMap) {
                HBaseClient.this.connections.remove(this.remoteId, this);
            }
            IOUtils.closeStream((Closeable)this.out);
            IOUtils.closeStream((Closeable)this.in);
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.remoteId.address + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        protected void cleanupCalls() {
            this.cleanupCalls(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanupCalls(long rpcTimeout) {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                long waitTime = System.currentTimeMillis() - c.getStartTime();
                if (waitTime < rpcTimeout) break;
                if (this.closeException == null) {
                    this.closeException = new CallTimeoutException("Call id=" + c.id + ", waitTime=" + waitTime + ", rpcTimetout=" + rpcTimeout);
                }
                c.setException(this.closeException);
                Call call = c;
                synchronized (call) {
                    c.notifyAll();
                }
                itor.remove();
            }
            try {
                if (!this.calls.isEmpty()) {
                    Call firstCall = this.calls.get(this.calls.firstKey());
                    long maxWaitTime = System.currentTimeMillis() - firstCall.getStartTime();
                    if (maxWaitTime < rpcTimeout) {
                        rpcTimeout -= maxWaitTime;
                    }
                }
                if (!this.shouldCloseConnection.get()) {
                    this.closeException = null;
                    if (this.socket != null) {
                        this.socket.setSoTimeout((int)rpcTimeout);
                    }
                }
            }
            catch (SocketException e) {
                LOG.debug((Object)"Couldn't lower timeout, which may result in longer than expected calls");
            }
        }

        protected class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !HBaseClient.this.running.get() || Connection.this.remoteId.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected class Call {
        final int id;
        final Writable param;
        Writable value;
        IOException error;
        boolean done;
        long startTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            this.startTime = System.currentTimeMillis();
            HBaseClient hBaseClient2 = HBaseClient.this;
            synchronized (hBaseClient2) {
                this.id = HBaseClient.this.counter++;
            }
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setValue(Writable value) {
            this.value = value;
            this.callComplete();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    public static class FailedServerException
    extends IOException {
        public FailedServerException(String s) {
            super(s);
        }
    }

    static class FailedServers {
        private final LinkedList<Pair<Long, String>> failedServers = new LinkedList();
        private final int recheckServersTimeout;

        FailedServers(Configuration conf) {
            this.recheckServersTimeout = conf.getInt(HBaseClient.FAILED_SERVER_EXPIRY_KEY, 2000);
        }

        public synchronized void addToFailedServers(InetSocketAddress address) {
            long expiry = EnvironmentEdgeManager.currentTimeMillis() + (long)this.recheckServersTimeout;
            this.failedServers.addFirst(new Pair<Long, String>(expiry, address.toString()));
        }

        public synchronized boolean isFailedServer(InetSocketAddress address) {
            if (this.failedServers.isEmpty()) {
                return false;
            }
            String lookup = address.toString();
            long now = EnvironmentEdgeManager.currentTimeMillis();
            Iterator it = this.failedServers.iterator();
            while (it.hasNext()) {
                Pair cur = (Pair)it.next();
                if ((Long)cur.getFirst() < now) {
                    it.remove();
                    continue;
                }
                if (!lookup.equals(cur.getSecond())) continue;
                return true;
            }
            return false;
        }
    }
}

