/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.io.NullOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;

public class FixedFileTrailer {
    private static final Log LOG = LogFactory.getLog(FixedFileTrailer.class);
    private static final int MAX_COMPARATOR_NAME_LENGTH = 128;
    private long fileInfoOffset;
    private long loadOnOpenDataOffset;
    private int dataIndexCount;
    private long uncompressedDataIndexSize;
    private int metaIndexCount;
    private long totalUncompressedBytes;
    private long entryCount;
    private Compression.Algorithm compressionCodec = Compression.Algorithm.NONE;
    private int numDataIndexLevels;
    private long firstDataBlockOffset;
    private long lastDataBlockOffset;
    private String comparatorClassName = RawComparator.class.getName();
    private final int majorVersion;
    private final int minorVersion;
    private static final int[] TRAILER_SIZE = FixedFileTrailer.computeTrailerSizeByVersion();
    private static final int MAX_TRAILER_SIZE = FixedFileTrailer.getMaxTrailerSize();

    FixedFileTrailer(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        HFile.checkFormatVersion(majorVersion);
    }

    private static int[] computeTrailerSizeByVersion() {
        int[] versionToSize = new int[3];
        for (int version = 1; version <= 2; ++version) {
            FixedFileTrailer fft = new FixedFileTrailer(version, 0);
            DataOutputStream dos = new DataOutputStream((OutputStream)new NullOutputStream());
            try {
                fft.serialize(dos);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            versionToSize[version] = dos.size();
        }
        return versionToSize;
    }

    private static int getMaxTrailerSize() {
        int maxSize = 0;
        for (int version = 1; version <= 2; ++version) {
            maxSize = Math.max(FixedFileTrailer.getTrailerSize(version), maxSize);
        }
        return maxSize;
    }

    static int getTrailerSize(int version) {
        return TRAILER_SIZE[version];
    }

    public int getTrailerSize() {
        return FixedFileTrailer.getTrailerSize(this.majorVersion);
    }

    void serialize(DataOutputStream outputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream baosDos = new DataOutputStream(baos);
        BlockType.TRAILER.write(baosDos);
        baosDos.writeLong(this.fileInfoOffset);
        baosDos.writeLong(this.loadOnOpenDataOffset);
        baosDos.writeInt(this.dataIndexCount);
        if (this.majorVersion == 1) {
            baosDos.writeLong(0L);
        } else {
            baosDos.writeLong(this.uncompressedDataIndexSize);
        }
        baosDos.writeInt(this.metaIndexCount);
        baosDos.writeLong(this.totalUncompressedBytes);
        if (this.majorVersion == 1) {
            baosDos.writeInt((int)Math.min(Integer.MAX_VALUE, this.entryCount));
        } else {
            baosDos.writeLong(this.entryCount);
        }
        baosDos.writeInt(this.compressionCodec.ordinal());
        if (this.majorVersion > 1) {
            baosDos.writeInt(this.numDataIndexLevels);
            baosDos.writeLong(this.firstDataBlockOffset);
            baosDos.writeLong(this.lastDataBlockOffset);
            Bytes.writeStringFixedSize(baosDos, this.comparatorClassName, 128);
        }
        baosDos.writeInt(FixedFileTrailer.materializeVersion(this.majorVersion, this.minorVersion));
        outputStream.write(baos.toByteArray());
    }

    void deserialize(DataInputStream inputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        BlockType.TRAILER.readAndCheck(inputStream);
        this.fileInfoOffset = inputStream.readLong();
        this.loadOnOpenDataOffset = inputStream.readLong();
        this.dataIndexCount = inputStream.readInt();
        if (this.majorVersion == 1) {
            inputStream.readLong();
        } else {
            this.uncompressedDataIndexSize = inputStream.readLong();
        }
        this.metaIndexCount = inputStream.readInt();
        this.totalUncompressedBytes = inputStream.readLong();
        this.entryCount = this.majorVersion == 1 ? (long)inputStream.readInt() : inputStream.readLong();
        this.compressionCodec = Compression.Algorithm.values()[inputStream.readInt()];
        if (this.majorVersion > 1) {
            this.numDataIndexLevels = inputStream.readInt();
            this.firstDataBlockOffset = inputStream.readLong();
            this.lastDataBlockOffset = inputStream.readLong();
            this.comparatorClassName = Bytes.readStringFixedSize(inputStream, 128);
        }
        int version = inputStream.readInt();
        this.expectMajorVersion(FixedFileTrailer.extractMajorVersion(version));
        this.expectMinorVersion(FixedFileTrailer.extractMinorVersion(version));
    }

    private void append(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, "fileinfoOffset=" + this.fileInfoOffset);
        this.append(sb, "loadOnOpenDataOffset=" + this.loadOnOpenDataOffset);
        this.append(sb, "dataIndexCount=" + this.dataIndexCount);
        this.append(sb, "metaIndexCount=" + this.metaIndexCount);
        this.append(sb, "totalUncomressedBytes=" + this.totalUncompressedBytes);
        this.append(sb, "entryCount=" + this.entryCount);
        this.append(sb, "compressionCodec=" + (Object)((Object)this.compressionCodec));
        if (this.majorVersion == 2) {
            this.append(sb, "uncompressedDataIndexSize=" + this.uncompressedDataIndexSize);
            this.append(sb, "numDataIndexLevels=" + this.numDataIndexLevels);
            this.append(sb, "firstDataBlockOffset=" + this.firstDataBlockOffset);
            this.append(sb, "lastDataBlockOffset=" + this.lastDataBlockOffset);
            this.append(sb, "comparatorClassName=" + this.comparatorClassName);
        }
        this.append(sb, "majorVersion=" + this.majorVersion);
        this.append(sb, "minorVersion=" + this.minorVersion);
        return sb.toString();
    }

    public static FixedFileTrailer readFromStream(FSDataInputStream istream, long fileSize) throws IOException {
        int bufferSize = MAX_TRAILER_SIZE;
        long seekPoint = fileSize - (long)bufferSize;
        if (seekPoint < 0L) {
            seekPoint = 0L;
            bufferSize = (int)fileSize;
        }
        istream.seek(seekPoint);
        ByteBuffer buf = ByteBuffer.allocate(bufferSize);
        istream.readFully(buf.array(), buf.arrayOffset(), buf.arrayOffset() + buf.limit());
        buf.position(buf.limit() - 4);
        int version = buf.getInt();
        int majorVersion = FixedFileTrailer.extractMajorVersion(version);
        int minorVersion = FixedFileTrailer.extractMinorVersion(version);
        HFile.checkFormatVersion(majorVersion);
        int trailerSize = FixedFileTrailer.getTrailerSize(majorVersion);
        FixedFileTrailer fft = new FixedFileTrailer(majorVersion, minorVersion);
        fft.deserialize(new DataInputStream(new ByteArrayInputStream(buf.array(), buf.arrayOffset() + bufferSize - trailerSize, trailerSize)));
        return fft;
    }

    public void expectMajorVersion(int expected) {
        if (this.majorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectMinorVersion(int expected) {
        if (this.minorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile minor version: " + this.minorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectAtLeastMajorVersion(int lowerBound) {
        if (this.majorVersion < lowerBound) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + lowerBound + " or higher).");
        }
    }

    public long getFileInfoOffset() {
        return this.fileInfoOffset;
    }

    public void setFileInfoOffset(long fileInfoOffset) {
        this.fileInfoOffset = fileInfoOffset;
    }

    public long getLoadOnOpenDataOffset() {
        return this.loadOnOpenDataOffset;
    }

    public void setLoadOnOpenOffset(long loadOnOpenDataOffset) {
        this.loadOnOpenDataOffset = loadOnOpenDataOffset;
    }

    public int getDataIndexCount() {
        return this.dataIndexCount;
    }

    public void setDataIndexCount(int dataIndexCount) {
        this.dataIndexCount = dataIndexCount;
    }

    public int getMetaIndexCount() {
        return this.metaIndexCount;
    }

    public void setMetaIndexCount(int metaIndexCount) {
        this.metaIndexCount = metaIndexCount;
    }

    public long getTotalUncompressedBytes() {
        return this.totalUncompressedBytes;
    }

    public void setTotalUncompressedBytes(long totalUncompressedBytes) {
        this.totalUncompressedBytes = totalUncompressedBytes;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long newEntryCount) {
        if (this.majorVersion == 1) {
            int intEntryCount = (int)Math.min(Integer.MAX_VALUE, newEntryCount);
            if ((long)intEntryCount != newEntryCount) {
                LOG.info((Object)("Warning: entry count is " + newEntryCount + " but writing " + intEntryCount + " into the version " + this.majorVersion + " trailer"));
            }
            this.entryCount = intEntryCount;
            return;
        }
        this.entryCount = newEntryCount;
    }

    public Compression.Algorithm getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(Compression.Algorithm compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public int getNumDataIndexLevels() {
        this.expectAtLeastMajorVersion(2);
        return this.numDataIndexLevels;
    }

    public void setNumDataIndexLevels(int numDataIndexLevels) {
        this.expectAtLeastMajorVersion(2);
        this.numDataIndexLevels = numDataIndexLevels;
    }

    public long getLastDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.lastDataBlockOffset;
    }

    public void setLastDataBlockOffset(long lastDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.lastDataBlockOffset = lastDataBlockOffset;
    }

    public long getFirstDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.firstDataBlockOffset;
    }

    public void setFirstDataBlockOffset(long firstDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.firstDataBlockOffset = firstDataBlockOffset;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    int getMinorVersion() {
        return this.minorVersion;
    }

    public void setComparatorClass(Class<? extends RawComparator> klass) {
        this.expectAtLeastMajorVersion(2);
        this.comparatorClassName = klass.getName();
    }

    private static Class<? extends RawComparator<byte[]>> getComparatorClass(String comparatorClassName) throws IOException {
        try {
            return Class.forName(comparatorClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    public static RawComparator<byte[]> createComparator(String comparatorClassName) throws IOException {
        try {
            return FixedFileTrailer.getComparatorClass(comparatorClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    RawComparator<byte[]> createComparator() throws IOException {
        this.expectAtLeastMajorVersion(2);
        return FixedFileTrailer.createComparator(this.comparatorClassName);
    }

    public long getUncompressedDataIndexSize() {
        if (this.majorVersion == 1) {
            return 0L;
        }
        return this.uncompressedDataIndexSize;
    }

    public void setUncompressedDataIndexSize(long uncompressedDataIndexSize) {
        this.expectAtLeastMajorVersion(2);
        this.uncompressedDataIndexSize = uncompressedDataIndexSize;
    }

    private static int extractMajorVersion(int serializedVersion) {
        return serializedVersion & 0xFFFFFF;
    }

    private static int extractMinorVersion(int serializedVersion) {
        return serializedVersion >>> 24;
    }

    private static int materializeVersion(int majorVersion, int minorVersion) {
        return majorVersion & 0xFFFFFF | minorVersion << 24;
    }
}

