/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;

public abstract class ServerCallable<T>
implements Callable<T> {
    protected final HConnection connection;
    protected final byte[] tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    protected HRegionInterface server;
    protected int callTimeout;
    protected long globalStartTime;
    protected long startTime;
    protected long endTime;
    protected static final int MIN_RPC_TIMEOUT = 2000;

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row) {
        this(connection, tableName, row, Integer.MAX_VALUE);
    }

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row, int callTimeout) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
        this.callTimeout = callTimeout;
    }

    public void connect(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        this.server = this.connection.getHRegionConnection(this.location.getHostname(), this.location.getPort());
    }

    public String getServerName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getHostnamePort();
    }

    public byte[] getRegionName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo().getRegionName();
    }

    public byte[] getRow() {
        return this.row;
    }

    public void beforeCall() {
        this.startTime = EnvironmentEdgeManager.currentTimeMillis();
        int remaining = (int)((long)this.callTimeout - (this.startTime - this.globalStartTime));
        if (remaining < 2000) {
            remaining = 2000;
        }
        HBaseRPC.setRpcTimeout(remaining);
    }

    public void afterCall() {
        HBaseRPC.resetRpcTimeout();
        this.endTime = EnvironmentEdgeManager.currentTimeMillis();
    }

    HConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T withRetries() throws IOException, RuntimeException {
        Configuration c = this.getConnection().getConfiguration();
        long pause = c.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        int numRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        long expectedSleep = 0L;
        for (int tries = 0; tries < numRetries; ++tries) {
            try {
                this.beforeCall();
                this.connect(tries != 0);
                Object v = this.call();
                return (T)v;
            }
            catch (Throwable t) {
                t = ServerCallable.translateException(t);
                if (t instanceof SocketTimeoutException || t instanceof ConnectException || t instanceof RetriesExhaustedException) {
                    HRegionLocation hrl = this.location;
                    if (hrl != null) {
                        this.getConnection().clearCaches(hrl.getHostnamePort());
                    }
                } else if (t instanceof NotServingRegionException && numRetries == 1) {
                    this.getConnection().deleteCachedRegionLocation(this.location);
                }
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTimeMillis(), this.toString());
                exceptions.add(qt);
                if (tries == numRetries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                expectedSleep = ConnectionUtils.getPauseTime(pause, tries + 1);
                long duration = this.singleCallDuration(expectedSleep);
                if (duration > (long)this.callTimeout) {
                    throw (SocketTimeoutException)new SocketTimeoutException("Call to access row '" + Bytes.toString(this.row) + "' on table '" + Bytes.toString(this.tableName) + "' failed on timeout. " + " callTimeout=" + this.callTimeout + ", callDuration=" + duration).initCause(t);
                }
            }
            finally {
                this.afterCall();
            }
            try {
                Thread.sleep(expectedSleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Giving up after tries=" + tries, e);
            }
        }
        return null;
    }

    public T withoutRetries() throws IOException, RuntimeException {
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.beforeCall();
            this.connect(false);
            Object v = this.call();
            return (T)v;
        }
        catch (Throwable t) {
            Throwable t2 = ServerCallable.translateException(t);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
        finally {
            this.afterCall();
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTimeMillis() - this.globalStartTime + 2000L + expectedSleep;
    }

    private static Throwable translateException(Throwable t) throws IOException {
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        return t;
    }

    public HRegionInfo getHRegionInfo() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo();
    }
}

