/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import sqlline.ClassNameCompleter;
import sqlline.DispatchCallback;
import sqlline.SqlLineSignalHandler;

public class SqlLine {
    private static final ResourceBundle loc = ResourceBundle.getBundle(SqlLine.class.getName());
    private static final String sep = System.getProperty("line.separator");
    public static final String COMMAND_PREFIX = "!";
    public static final String SQLLINE_BASE_DIR = "x.sqlline.basedir";
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static boolean initComplete = false;
    static final SortedSet KNOWN_DRIVERS = new TreeSet<String>(Arrays.asList("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.informix.InformixDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.oracle.OracleDriver", "net.sourceforge.jtds.jdbc.Driver", "com.pointbase.jdbc.jdbcDriver", "com.internetcds.jdbc.tds.SybaseDriver", "org.enhydra.instantdb.jdbc.idbDriver", "com.sybase.jdbc2.jdbc.SybDriver", "com.ddtek.jdbc.sybase.SybaseDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.jnetdirect.jsql.JSQLDriver", "com.lucidera.jdbc.LucidDbRmiDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.hsqldb.jdbcDriver", "com.pointbase.jdbc.jdbcUniversalDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.oracle.OracleDriver", "oracle.jdbc.OracleDriver", "com.informix.jdbc.IfxDriver", "com.merant.datadirect.jdbc.informix.InformixDriver", "com.ibm.db2.jcc.DB2Driver", "com.pointbase.jdbc.jdbcEmbeddedDriver", "org.gjt.mm.mysql.Driver", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "interbase.interclient.Driver", "com.mysql.jdbc.NonRegisteringDriver", "com.merant.datadirect.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.sybase.SybaseDriver", "com.internetcds.jdbc.tds.Driver", "org.hsqldb.jdbcDriver", "org.hsql.jdbcDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.ddtek.jdbc.db2.DB2Driver", "interbase.interclient.Driver", "com.mysql.jdbc.Driver", "com.ddtek.jdbc.oracle.OracleDriver", "org.postgresql.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.jnetdirect.jsql.JSQLDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "weblogic.jdbc.mssqlserver4.Driver", "com.ddtek.jdbc.sybase.SybaseDriver", "oracle.jdbc.pool.OracleDataSource", "org.axiondb.jdbc.AxionDriver", "COM.ibm.db2.jdbc.app.DB2Driver", "com.ibm.as400.access.AS400JDBCDriver", "COM.FirstSQL.Dbcp.DbcpDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.enhydra.instantdb.jdbc.idbDriver", "com.informix.jdbc.IfxDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.imaginary.sql.msql.MsqlDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle.jdbc.driver.OracleDriver", "intersolv.jdbc.sequelink.SequeLinkDriver", "openlink.jdbc2.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "postgres95.PGDriver", "postgresql.Driver", "solid.jdbc.SolidDriver", "centura.java.sqlbase.SqlbaseDriver", "interbase.interclient.Driver", "com.mckoi.JDBCDriver", "com.inet.tds.TdsDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.thinweb.tds.Driver", "weblogic.jdbc.mssqlserver4.Driver", "com.mysql.jdbc.DatabaseMetaData", "org.gjt.mm.mysql.Driver", "com.sap.dbtech.jdbc.DriverSapDB", "com.sybase.jdbc2.jdbc.SybDriver", "com.sybase.jdbc.SybDriver", "com.internetcds.jdbc.tds.Driver", "weblogic.jdbc.pool.Driver", "com.sqlstream.jdbc.Driver", "org.luciddb.jdbc.LucidDbClientDriver"));
    private SqlLineSignalHandler signalHandler = null;
    private boolean exit = false;
    private Collection drivers = null;
    private Connections connections = new Connections();
    private Completer sqlLineCommandCompleter;
    private Map completions = new HashMap();
    private Opts opts = new Opts(System.getProperties());
    String lastProgress = null;
    private Map seenWarnings = new HashMap();
    private final Commands command = new Commands();
    private OutputFile script = null;
    private OutputFile record = null;
    private ConsoleReader reader;
    private List batch = null;
    private final Map formats = SqlLine.map(new Object[]{"vertical", new VerticalOutputFormat(), "table", new TableOutputFormat(), "csv", new SeparatedValuesOutputFormat(','), "tsv", new SeparatedValuesOutputFormat('\t'), "xmlattr", new XMLAttributeOutputFormat(), "xmlelements", new XMLElementOutputFormat()});
    private CommandHandler[] commands = new CommandHandler[]{new ReflectiveCommandHandler(new String[]{"quit", "done", "exit"}, null), new ReflectiveCommandHandler(new String[]{"connect", "open"}, new Completer[]{new StringsCompleter(this.getConnectionURLExamples())}), new ReflectiveCommandHandler(new String[]{"describe"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"indexes"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"primarykeys"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"exportedkeys"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"manual"}, null), new ReflectiveCommandHandler(new String[]{"importedkeys"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"procedures"}, null), new ReflectiveCommandHandler(new String[]{"tables"}, null), new ReflectiveCommandHandler(new String[]{"typeinfo"}, null), new ReflectiveCommandHandler(new String[]{"columns"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"reconnect"}, null), new ReflectiveCommandHandler(new String[]{"dropall"}, new Completer[]{new TableNameCompleter()}), new ReflectiveCommandHandler(new String[]{"history"}, null), new ReflectiveCommandHandler(new String[]{"metadata"}, new Completer[]{new StringsCompleter(this.getMetadataMethodNames())}), new ReflectiveCommandHandler(new String[]{"nativesql"}, null), new ReflectiveCommandHandler(new String[]{"dbinfo"}, null), new ReflectiveCommandHandler(new String[]{"rehash"}, null), new ReflectiveCommandHandler(new String[]{"verbose"}, null), new ReflectiveCommandHandler(new String[]{"run"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(new String[]{"batch"}, null), new ReflectiveCommandHandler(new String[]{"list"}, null), new ReflectiveCommandHandler(new String[]{"all"}, null), new ReflectiveCommandHandler(new String[]{"go", "#"}, null), new ReflectiveCommandHandler(new String[]{"script"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(new String[]{"record"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(new String[]{"brief"}, null), new ReflectiveCommandHandler(new String[]{"close"}, null), new ReflectiveCommandHandler(new String[]{"closeall"}, null), new ReflectiveCommandHandler(new String[]{"isolation"}, new Completer[]{new StringsCompleter(this.getIsolationLevels())}), new ReflectiveCommandHandler(new String[]{"outputformat"}, new Completer[]{new StringsCompleter(this.formats.keySet().toArray(new String[0]))}), new ReflectiveCommandHandler(new String[]{"autocommit"}, null), new ReflectiveCommandHandler(new String[]{"commit"}, null), new ReflectiveCommandHandler(new String[]{"properties"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(new String[]{"rollback"}, null), new ReflectiveCommandHandler(new String[]{"help", "?"}, null), new ReflectiveCommandHandler(new String[]{"set"}, this.opts.optionCompletors()), new ReflectiveCommandHandler(new String[]{"save"}, null), new ReflectiveCommandHandler(new String[]{"scan"}, null), new ReflectiveCommandHandler(new String[]{"sql"}, null), new ReflectiveCommandHandler(new String[]{"call"}, null)};
    private static final int SPACE = 0;
    private static final int DOT_SPACE = 1;
    private static final int QUOTED = 2;
    private static final int UNQUOTED = 3;

    SqlLine() {
        this.sqlLineCommandCompleter = new SQLLineCommandCompleter();
        try {
            Class<?> handlerClass = Class.forName("sqlline.SunSignalHandler");
            this.signalHandler = (SqlLineSignalHandler)handlerClass.newInstance();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    static Manifest getManifest() throws IOException {
        URL base = SqlLine.class.getResource("/META-INF/MANIFEST.MF");
        URLConnection c = base.openConnection();
        if (c instanceof JarURLConnection) {
            return ((JarURLConnection)c).getManifest();
        }
        return null;
    }

    static String getManifestAttribute(String name) {
        try {
            Manifest m = SqlLine.getManifest();
            if (m == null) {
                return "??";
            }
            Attributes attrs = m.getAttributes("sqlline");
            if (attrs == null) {
                return "???";
            }
            String val = attrs.getValue(name);
            if (val == null || "".equals(val)) {
                return "????";
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "?????";
        }
    }

    private String getApplicationTitle() {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/sqlline/sqlline/pom.properties");
        Properties properties = new Properties();
        properties.put("artifactId", "sqlline");
        properties.put("version", "???");
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return SqlLine.loc("app-introduction", properties.getProperty("artifactId"), properties.getProperty("version"));
    }

    static String getApplicationContactInformation() {
        return SqlLine.getManifestAttribute("Implementation-Vendor");
    }

    static String loc(String res) {
        return SqlLine.loc(res, EMPTY_OBJ_ARRAY);
    }

    static String loc(String res, int param) {
        try {
            return MessageFormat.format(new ChoiceFormat(loc.getString(res)).format(param), new Integer(param));
        }
        catch (Exception e) {
            return res + ": " + param;
        }
    }

    static String loc(String res, Object param1) {
        return SqlLine.loc(res, new Object[]{param1});
    }

    static String loc(String res, Object param1, Object param2) {
        return SqlLine.loc(res, new Object[]{param1, param2});
    }

    static String loc(String res, Object[] params) {
        try {
            return MessageFormat.format(loc.getString(res), params);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return res + ": " + Arrays.asList(params);
            }
            catch (Exception e2) {
                return res;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        SqlLine.start(args, null, true);
    }

    public static boolean mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        return SqlLine.start(args, inputStream, false);
    }

    public static boolean start(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        SqlLine sqlline = new SqlLine();
        boolean retVal = sqlline.begin(args, inputStream, saveHistory);
        if (!Boolean.getBoolean("sqlline.system.exit")) {
            System.exit(retVal ? 1 : 0);
        }
        return retVal;
    }

    DatabaseConnection con() {
        return this.connections.current();
    }

    Connection conn() {
        if (this.connections.current() == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        if (this.connections.current().connection == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        return this.connections.current().connection;
    }

    DatabaseMetaData meta() {
        if (this.connections.current() == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        if (this.connections.current().meta == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        return this.connections.current().meta;
    }

    public String[] getIsolationLevels() {
        return new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    }

    public String[] getMetadataMethodNames() {
        try {
            TreeSet<String> mnames = new TreeSet<String>();
            Method[] m = DatabaseMetaData.class.getDeclaredMethods();
            for (int i = 0; m != null && i < m.length; ++i) {
                mnames.add(m[i].getName());
            }
            return mnames.toArray(new String[0]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public String[] getConnectionURLExamples() {
        return new String[]{"jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hsqldb:<database>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:luciddb:http://<hostname>", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>"};
    }

    ColorBuffer color() {
        return new ColorBuffer(this.opts.getColor());
    }

    ColorBuffer color(String msg) {
        return new ColorBuffer(msg, this.opts.getColor());
    }

    void registerKnownDrivers() {
        Iterator i = KNOWN_DRIVERS.iterator();
        while (i.hasNext()) {
            try {
                Class.forName(i.next().toString());
            }
            catch (Throwable throwable) {}
        }
    }

    boolean initArgs(String[] args) {
        LinkedList<String> commands = new LinkedList<String>();
        LinkedList<String> files = new LinkedList<String>();
        String driver = null;
        String user = null;
        String pass = null;
        String url = null;
        Object cmd = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                this.usage();
                return false;
            }
            if (args[i].startsWith("--")) {
                boolean ret;
                String[] parts = this.split(args[i].substring(2), "=");
                this.debug(SqlLine.loc("setting-prop", Arrays.asList(parts)));
                if (parts.length <= 0 || (ret = parts.length >= 2 ? this.opts.set(parts[0], parts[1], true) : this.opts.set(parts[0], "true", true))) continue;
                return false;
            }
            if (args[i].equals("-d")) {
                driver = args[i++ + 1];
                continue;
            }
            if (args[i].equals("-n")) {
                user = args[i++ + 1];
                continue;
            }
            if (args[i].equals("-p")) {
                pass = args[i++ + 1];
                continue;
            }
            if (args[i].equals("-u")) {
                url = args[i++ + 1];
                continue;
            }
            if (args[i].equals("-e")) {
                commands.add(args[i++ + 1]);
                continue;
            }
            files.add(args[i]);
        }
        if (url != null) {
            String com = "!connect " + url + " " + (user == null || user.length() == 0 ? "''" : user) + " " + (pass == null || pass.length() == 0 ? "''" : pass) + " " + (driver == null ? "" : driver);
            this.debug("issuing: " + com);
            this.dispatch(com, new DispatchCallback());
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            this.dispatch("!properties " + i.next(), new DispatchCallback());
        }
        if (commands.size() > 0) {
            this.opts.setColor(false);
            this.opts.setHeaderInterval(-1);
            i = commands.iterator();
            while (i.hasNext()) {
                String command = i.next().toString();
                this.debug(SqlLine.loc("executing-command", command));
                this.dispatch(command, new DispatchCallback());
            }
            this.exit = true;
        }
        if (this.opts.getRun() != null) {
            this.dispatch("!run " + this.opts.getRun(), new DispatchCallback());
            this.dispatch("!quit", new DispatchCallback());
        }
        return true;
    }

    boolean begin(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        try {
            this.opts.load();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        FileHistory fileHistory = new FileHistory(new File(this.opts.getHistoryFile()));
        ConsoleReader reader = this.getConsoleReader(inputStream, fileHistory);
        if (!this.initArgs(args)) {
            this.usage();
            return false;
        }
        try {
            this.info(this.getApplicationTitle());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        initComplete = true;
        DispatchCallback callback = new DispatchCallback();
        while (!this.exit) {
            try {
                this.signalHandler.setCallback(callback);
                this.dispatch(reader.readLine(this.getPrompt()), callback);
                if (!saveHistory) continue;
                fileHistory.flush();
            }
            catch (EOFException eof) {
                this.command.quit(null, callback);
            }
            catch (UserInterruptException ioe) {
                try {
                    callback.forceKillSqlQuery();
                    callback.setToCancel();
                    this.output(SqlLine.loc("command-canceled"));
                }
                catch (SQLException sqle) {
                    this.handleException(sqle);
                }
            }
            catch (Throwable t) {
                this.handleException(t);
                callback.setToFailure();
            }
        }
        this.command.closeall(null, new DispatchCallback());
        return callback.isSuccess();
    }

    public ConsoleReader getConsoleReader(InputStream inputStream, FileHistory fileHistory) throws IOException {
        Terminal terminal = TerminalFactory.create();
        try {
            terminal.init();
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.toString());
            ioException.initCause(e);
            throw ioException;
        }
        this.reader = inputStream != null ? new ConsoleReader(inputStream, (OutputStream)System.out) : new ConsoleReader();
        this.reader.addCompleter((Completer)new SQLLineCompleter());
        this.reader.setHistory((History)fileHistory);
        this.reader.setHandleUserInterrupt(true);
        this.reader.setExpandEvents(false);
        return this.reader;
    }

    void usage() {
        this.output(SqlLine.loc("cmd-usage"));
    }

    void dispatch(String line, DispatchCallback callback) {
        if (line == null) {
            this.exit = true;
            return;
        }
        if (line.trim().length() == 0) {
            return;
        }
        if (this.isComment(line)) {
            return;
        }
        line = line.trim();
        if (this.script != null) {
            this.script.addLine(line);
        }
        if (this.isHelpRequest(line)) {
            line = "!help";
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            TreeMap<String, CommandHandler> cmdMap = new TreeMap<String, CommandHandler>();
            line = line.substring(1);
            for (int i = 0; i < this.commands.length; ++i) {
                String match = this.commands[i].matches(line);
                if (match == null) continue;
                cmdMap.put(match, this.commands[i]);
            }
            if (cmdMap.size() == 0) {
                callback.setStatus(DispatchCallback.Status.FAILURE);
                this.error(SqlLine.loc("unknown-command", line));
            } else if (cmdMap.size() > 1) {
                callback.setStatus(DispatchCallback.Status.FAILURE);
                this.error(SqlLine.loc("multiple-matches", cmdMap.keySet().toString()));
            } else {
                callback.setStatus(DispatchCallback.Status.RUNNING);
                ((CommandHandler)cmdMap.values().iterator().next()).execute(line, callback);
            }
        } else {
            callback.setStatus(DispatchCallback.Status.RUNNING);
            this.command.sql(line, callback);
        }
    }

    boolean needsContinuation(String line) {
        if (null == line) {
            return false;
        }
        if (this.isHelpRequest(line)) {
            return false;
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            return false;
        }
        if (this.isComment(line)) {
            return false;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        return !trimmed.endsWith(";");
    }

    boolean isHelpRequest(String line) {
        return line.equals("?") || line.equalsIgnoreCase("help");
    }

    boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--");
    }

    void output(String msg) {
        this.output(msg, true);
    }

    void info(String msg) {
        if (!this.opts.getSilent()) {
            this.output(msg, true, System.err);
        }
    }

    void info(ColorBuffer msg) {
        if (!this.opts.getSilent()) {
            this.output(msg, true, System.err);
        }
    }

    boolean error(String msg) {
        this.output(this.color().red(msg), true, System.err);
        return false;
    }

    boolean error(Throwable t) {
        this.handleException(t);
        return false;
    }

    void debug(String msg) {
        if (this.opts.getVerbose()) {
            this.output(this.color().blue(msg), true, System.err);
        }
    }

    void output(ColorBuffer msg) {
        this.output(msg, true);
    }

    void output(String msg, boolean newline, PrintStream out) {
        this.output(this.color(msg), newline, out);
    }

    void output(ColorBuffer msg, boolean newline) {
        this.output(msg, newline, System.out);
    }

    void output(ColorBuffer msg, boolean newline, PrintStream out) {
        if (newline) {
            out.println(msg.getColor());
        } else {
            out.print(msg.getColor());
        }
        if (this.record == null) {
            return;
        }
        if (newline) {
            this.record.addLine(msg.getMono());
        }
    }

    void output(String msg, boolean newline) {
        this.output(this.color(msg), newline);
    }

    void autocommitStatus(Connection c) throws SQLException {
        this.debug(SqlLine.loc("autocommit-status", c.getAutoCommit() + ""));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.con().connection.getAutoCommit()) {
                return this.error(SqlLine.loc("autocommit-needs-off"));
            }
        }
        catch (Exception e) {
            return this.error(e);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.con() == null || this.con().connection == null) {
                return this.error(SqlLine.loc("no-current-connection"));
            }
            if (this.con().connection.isClosed()) {
                return this.error(SqlLine.loc("connection-is-closed"));
            }
        }
        catch (SQLException sqle) {
            return this.error(SqlLine.loc("no-current-connection"));
        }
        return true;
    }

    void showWarnings() {
        if (this.con().connection == null) {
            return;
        }
        if (!this.opts.getShowWarnings()) {
            return;
        }
        try {
            this.showWarnings(this.con().connection.getWarnings());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void showWarnings(SQLWarning warn) {
        SQLWarning next;
        if (warn == null) {
            return;
        }
        if (this.seenWarnings.get(warn) == null) {
            this.seenWarnings.put(warn, new Date());
            this.handleSQLException(warn);
        }
        if ((next = warn.getNextWarning()) != warn) {
            this.showWarnings(next);
        }
    }

    String getPrompt() {
        if (this.con() == null || this.con().url == null) {
            return "sqlline> ";
        }
        return SqlLine.getPrompt(this.connections.getIndex() + ": " + this.con().url) + "> ";
    }

    static String getPrompt(String url) {
        if (url == null || url.length() == 0) {
            url = "sqlline";
        }
        if (url.indexOf(";") > -1) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.indexOf("?") > -1) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.length() > 45) {
            url = url.substring(0, 45);
        }
        return url;
    }

    int getSize(ResultSet rs) {
        try {
            if (rs.getType() == 1003) {
                return -1;
            }
            rs.last();
            int total = rs.getRow();
            rs.beforeFirst();
            return total;
        }
        catch (SQLException sqle) {
            return -1;
        }
        catch (AbstractMethodError ame) {
            return -1;
        }
    }

    ResultSet getColumns(String table) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.con().meta.getColumns(this.con().meta.getConnection().getCatalog(), null, table, "%");
    }

    ResultSet getTables() throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.con().meta.getTables(this.con().meta.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getColumnNames(DatabaseMetaData meta) throws SQLException {
        HashSet<String> names = new HashSet<String>();
        this.info(SqlLine.loc("building-tables"));
        try {
            ResultSet columns = this.getColumns("%");
            try {
                int total = this.getSize(columns);
                int index = 0;
                while (columns.next()) {
                    this.progress(index++, total);
                    String name = columns.getString("TABLE_NAME");
                    names.add(name);
                    names.add(columns.getString("COLUMN_NAME"));
                    names.add(columns.getString("TABLE_NAME") + "." + columns.getString("COLUMN_NAME"));
                }
                this.progress(index, index);
            }
            finally {
                columns.close();
            }
            this.info(SqlLine.loc("done"));
            return names.toArray(new String[0]);
        }
        catch (Throwable t) {
            this.handleException(t);
            return new String[0];
        }
    }

    String[] split(String line) {
        return this.split(line, " ");
    }

    String[][] splitCompound(String line) {
        int n;
        DatabaseConnection databaseConnection = this.con();
        Quoting quoting = databaseConnection == null ? Quoting.DEFAULT : databaseConnection.quoting;
        int state = 0;
        int idStart = -1;
        char[] chars = line.toCharArray();
        for (n = chars.length; n > 0 && (Character.isWhitespace(chars[n - 1]) || chars[n - 1] == ';'); --n) {
        }
        ArrayList<String[]> words = new ArrayList<String[]>();
        ArrayList<String> current = new ArrayList<String>();
        int i = 0;
        block10: while (i < n) {
            char c = chars[i];
            switch (state) {
                case 0: 
                case 1: {
                    ++i;
                    if (Character.isWhitespace(c)) break;
                    if (c == '.') {
                        state = 1;
                        break;
                    }
                    if (c == quoting.start) {
                        if (state == 0 && current.size() > 0) {
                            words.add(current.toArray(new String[current.size()]));
                            current.clear();
                        }
                        state = 2;
                        idStart = i;
                        break;
                    }
                    if (state == 0 && current.size() > 0) {
                        words.add(current.toArray(new String[current.size()]));
                        current.clear();
                    }
                    state = 3;
                    idStart = i - 1;
                    break;
                }
                case 2: {
                    ++i;
                    if (c != quoting.end) continue block10;
                    if (i < n && chars[i] == quoting.end) {
                        System.arraycopy(chars, i, chars, i - 1, n - i);
                        --n;
                        break;
                    }
                    state = 0;
                    String word = new String(chars, idStart, i - idStart - 1);
                    current.add(word);
                    break;
                }
                case 3: {
                    ++i;
                    if (!Character.isWhitespace(c) && c != '.') continue block10;
                    String word = new String(chars, idStart, i - idStart - 1);
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (quoting.upper) {
                        word = word.toUpperCase();
                    }
                    current.add(word);
                    state = c == '.' ? 1 : 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state " + state));
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String word = new String(chars, idStart, n - idStart);
                if (state == 3) {
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (quoting.upper) {
                        word = word.toUpperCase();
                    }
                }
                current.add(word);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected state " + state));
            }
        }
        if (current.size() > 0) {
            words.add(current.toArray(new String[current.size()]));
        }
        return (String[][])words.toArray((T[])new String[words.size()][]);
    }

    String dequote(String str) {
        if (str == null) {
            return null;
        }
        while (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    String[] split(String line, String delim) {
        StringTokenizer tok = new StringTokenizer(line, delim);
        String[] ret = new String[tok.countTokens()];
        int index = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            t = this.dequote(t);
            ret[index++] = t;
        }
        return ret;
    }

    static Map map(Object[] obs) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (int i = 0; i < obs.length - 1; i += 2) {
            m.put(obs[i], obs[i + 1]);
        }
        return Collections.unmodifiableMap(m);
    }

    static boolean getMoreResults(Statement stmnt) {
        try {
            return stmnt.getMoreResults();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static String xmlattrencode(String str) {
        str = SqlLine.replace(str, "\"", "&quot;");
        str = SqlLine.replace(str, "<", "&lt;");
        return str;
    }

    static String replace(String source, String from, String to) {
        if (source == null) {
            return null;
        }
        if (from.equals(to)) {
            return source;
        }
        StringBuffer replaced = new StringBuffer();
        int index = -1;
        while ((index = source.indexOf(from)) != -1) {
            replaced.append(source.substring(0, index));
            replaced.append(to);
            source = source.substring(index + from.length());
        }
        replaced.append(source);
        return replaced.toString();
    }

    String[] split(String line, int assertLen, String usage) {
        String[] ret = this.split(line);
        if (ret.length != assertLen) {
            this.error(usage);
            return null;
        }
        return ret;
    }

    String wrap(String toWrap, int len, int start) {
        String cur = toWrap;
        StringBuffer buff = new StringBuffer();
        StringBuffer line = new StringBuffer();
        char[] head = new char[start];
        Arrays.fill(head, ' ');
        StringTokenizer tok = new StringTokenizer(toWrap, " ");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (line.length() + next.length() > len) {
                buff.append(line).append(sep).append(head);
                line.setLength(0);
            }
            line.append(line.length() == 0 ? "" : " ").append(next);
        }
        buff.append(line);
        return buff.toString();
    }

    void progress(int cur, int max) {
        StringBuffer out = new StringBuffer();
        if (this.lastProgress != null) {
            char[] back = new char[this.lastProgress.length()];
            Arrays.fill(back, '\b');
            out.append(back);
        }
        String progress = cur + "/" + (max == -1 ? "?" : "" + max) + " " + (max == -1 ? "(??%)" : "(" + cur * 100 / (max == 0 ? 1 : max) + "%)");
        if (cur >= max && max != -1) {
            progress = progress + " " + SqlLine.loc("done") + sep;
            this.lastProgress = null;
        } else {
            this.lastProgress = progress;
        }
        out.append(progress);
        System.out.print(out.toString());
        System.out.flush();
    }

    void handleException(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof SQLException) {
            this.handleSQLException((SQLException)e);
        } else if (!initComplete && !this.opts.getVerbose()) {
            if (e.getMessage() == null) {
                this.error(e.getClass().getName());
            } else {
                this.error(e.getMessage());
            }
        } else {
            e.printStackTrace(System.err);
        }
    }

    void handleSQLException(SQLException e) {
        if (e instanceof SQLWarning && !initComplete && !this.opts.getShowWarnings()) {
            return;
        }
        String type = e instanceof SQLWarning ? SqlLine.loc("Warning") : SqlLine.loc("Error");
        this.error(SqlLine.loc(e instanceof SQLWarning ? "Warning" : "Error", new Object[]{e.getMessage() == null ? "" : e.getMessage().trim(), e.getSQLState() == null ? "" : e.getSQLState().trim(), new Integer(e.getErrorCode())}));
        if (!initComplete && this.opts.getVerbose()) {
            e.printStackTrace();
        }
        if (initComplete && !this.opts.getShowNestedErrs()) {
            return;
        }
        for (SQLException nested = e.getNextException(); nested != null && nested != e; nested = nested.getNextException()) {
            this.handleSQLException(nested);
        }
    }

    private boolean scanForDriver(String url) {
        try {
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(true);
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(false);
            return this.findRegisteredDriver(url) != null;
        }
        catch (Exception e) {
            this.debug(e.toString());
            return false;
        }
    }

    private Driver findRegisteredDriver(String url) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers != null && drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    Driver[] scanDrivers(String line) throws IOException {
        return this.scanDrivers(false);
    }

    Driver[] scanDrivers(boolean knownOnly) throws IOException {
        long start = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        if (!knownOnly) {
            classNames.addAll(Arrays.asList(ClassNameCompleter.getClassNames()));
        }
        classNames.addAll(KNOWN_DRIVERS);
        HashSet driverClasses = new HashSet();
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            String className = i.next().toString();
            if (className.toLowerCase().indexOf("driver") == -1) continue;
            try {
                Class<?> c = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                if (!Driver.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                driverClasses.add(c.newInstance());
            }
            catch (Throwable t) {}
        }
        this.info("scan complete in " + (System.currentTimeMillis() - start) + "ms");
        return driverClasses.toArray(new Driver[0]);
    }

    int print(ResultSet rs, DispatchCallback callback) throws SQLException {
        String format = this.opts.getOutputFormat();
        OutputFormat f = (OutputFormat)this.formats.get(format);
        if (f == null) {
            this.error(SqlLine.loc("unknown-format", new Object[]{format, this.formats.keySet()}));
            f = new TableOutputFormat();
        }
        Rows rows = this.opts.getIncremental() ? new IncrementalRows(rs, callback) : new BufferedRows(rs);
        return f.print(rows);
    }

    private Statement createStatement() throws SQLException {
        Statement stmnt = this.con().connection.createStatement();
        if (this.opts.timeout > -1) {
            stmnt.setQueryTimeout(this.opts.timeout);
        }
        if (this.opts.rowLimit != 0) {
            stmnt.setMaxRows(this.opts.rowLimit);
        }
        return stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatch(List statements) {
        try {
            Statement stmnt = this.createStatement();
            try {
                Iterator i = statements.iterator();
                while (i.hasNext()) {
                    stmnt.addBatch(i.next().toString());
                }
                int[] counts = stmnt.executeBatch();
                this.output(this.color().pad(this.color().bold("COUNT"), 8).append(this.color().bold("STATEMENT")));
                for (int i2 = 0; counts != null && i2 < counts.length; ++i2) {
                    this.output(this.color().pad(counts[i2] + "", 8).append(statements.get(i2).toString()));
                }
            }
            finally {
                try {
                    stmnt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int runCommands(List cmds, DispatchCallback callback) {
        int successCount = 0;
        try {
            int index = 1;
            int size = cmds.size();
            Iterator i = cmds.iterator();
            while (i.hasNext()) {
                String cmd = i.next().toString();
                this.info(this.color().pad(index++ + "/" + size, 13).append(cmd));
                this.dispatch(cmd, callback);
                boolean success = callback.isSuccess();
                if (!success && !this.opts.getForce()) {
                    this.error(SqlLine.loc("abort-on-error", cmd));
                    return successCount;
                }
                successCount += success ? 1 : 0;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return successCount;
    }

    private void setCompletions() throws SQLException, IOException {
        if (this.con() != null) {
            this.con().setCompletions(this.opts.getFastConnect());
        }
    }

    static {
        String testClass = "jline.console.ConsoleReader";
        try {
            Class.forName(testClass);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(SqlLine.loc("jline-missing", testClass));
        }
    }

    private static class Quoting {
        private final char start;
        private final char end;
        private final boolean upper;
        public static final Quoting DEFAULT = new Quoting('\"', '\"', true);

        Quoting(char start, char end, boolean upper) {
            this.start = start;
            this.end = end;
            this.upper = upper;
        }
    }

    static class DriverInfo {
        public String sampleURL;

        public DriverInfo(String name) throws IOException {
            Properties props = new Properties();
            props.load(DriverInfo.class.getResourceAsStream(name));
            this.fromProperties(props);
        }

        public DriverInfo(Properties props) {
            this.fromProperties(props);
        }

        public void fromProperties(Properties props) {
        }
    }

    public class OutputFile {
        final File file;
        final PrintWriter out;

        public OutputFile(String filename) throws IOException {
            this.file = new File(filename);
            this.out = new PrintWriter(new FileWriter(this.file));
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public void addLine(String command) {
            this.out.println(command);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    static class Reflector {
        Reflector() {
        }

        public static Object invoke(Object on, String method, Object[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            return Reflector.invoke(on, method, Arrays.asList(args));
        }

        public static Object invoke(Object on, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            return Reflector.invoke(on, on == null ? null : on.getClass(), method, args);
        }

        public static Object invoke(Object on, Class defClass, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            Class<?> c = defClass != null ? defClass : on.getClass();
            LinkedList<Method> candidateMethods = new LinkedList<Method>();
            Method[] m = c.getMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getName().equalsIgnoreCase(method)) continue;
                candidateMethods.add(m[i]);
            }
            if (candidateMethods.size() == 0) {
                throw new IllegalArgumentException(SqlLine.loc("no-method", new Object[]{method, c.getName()}));
            }
            for (Method meth : candidateMethods) {
                Object[] converted;
                Class[] ptypes = meth.getParameterTypes();
                if (ptypes.length != args.size() || (converted = Reflector.convert(args, ptypes)) == null || !Modifier.isPublic(meth.getModifiers())) continue;
                return meth.invoke(on, converted);
            }
            return null;
        }

        public static Object[] convert(List objects, Class[] toTypes) throws ClassNotFoundException {
            Object[] converted = new Object[objects.size()];
            for (int i = 0; i < converted.length; ++i) {
                converted[i] = Reflector.convert(objects.get(i), toTypes[i]);
            }
            return converted;
        }

        public static Object convert(Object ob, Class toType) throws ClassNotFoundException {
            if (ob == null || ob.toString().equals("null")) {
                return null;
            }
            if (toType == String.class) {
                return new String(ob.toString());
            }
            if (toType == Byte.class || toType == Byte.TYPE) {
                return new Byte(ob.toString());
            }
            if (toType == Character.class || toType == Character.TYPE) {
                return new Character(ob.toString().charAt(0));
            }
            if (toType == Short.class || toType == Short.TYPE) {
                return new Short(ob.toString());
            }
            if (toType == Integer.class || toType == Integer.TYPE) {
                return new Integer(ob.toString());
            }
            if (toType == Long.class || toType == Long.TYPE) {
                return new Long(ob.toString());
            }
            if (toType == Double.class || toType == Double.TYPE) {
                return new Double(ob.toString());
            }
            if (toType == Float.class || toType == Float.TYPE) {
                return new Float(ob.toString());
            }
            if (toType == Boolean.class || toType == Boolean.TYPE) {
                return new Boolean(ob.toString().equals("true") || ob.toString().equals("true") || ob.toString().equals("1") || ob.toString().equals("on") || ob.toString().equals("yes"));
            }
            if (toType == Class.class) {
                return Class.forName(ob.toString());
            }
            return null;
        }
    }

    class Opts
    implements Completer {
        public static final String PROPERTY_PREFIX = "sqlline.";
        public static final String PROPERTY_NAME_EXIT = "sqlline.system.exit";
        private boolean autosave = false;
        private boolean silent = false;
        private boolean color = false;
        private boolean showHeader = true;
        private int headerInterval = 100;
        private boolean fastConnect = true;
        private boolean autoCommit = true;
        private boolean verbose = false;
        private boolean force = false;
        private boolean incremental = true;
        private boolean showTime = true;
        private boolean showWarnings = true;
        private boolean showNestedErrs = false;
        private String numberFormat = "default";
        private int maxWidth = TerminalFactory.get().getWidth();
        private int maxHeight = TerminalFactory.get().getHeight();
        private int maxColumnWidth = 15;
        private int rowLimit = 0;
        private int timeout = -1;
        private String isolation = "TRANSACTION_REPEATABLE_READ";
        private String outputFormat = "table";
        private boolean trimScripts = true;
        private File rcFile = new File(this.saveDir(), "sqlline.properties");
        private String historyFile = new File(this.saveDir(), "history").getAbsolutePath();
        private String runFile;

        public Opts(Properties props) {
            this.loadProperties(props);
        }

        public Completer[] optionCompletors() {
            return new Completer[]{this};
        }

        public String[] possibleSettingValues() {
            LinkedList<String> vals = new LinkedList<String>();
            vals.addAll(Arrays.asList("yes", "no"));
            return vals.toArray(new String[vals.size()]);
        }

        public File saveDir() {
            String dir = System.getProperty("sqlline.rcfile");
            if (dir != null && dir.length() > 0) {
                return new File(dir);
            }
            String baseDir = System.getProperty(SqlLine.SQLLINE_BASE_DIR);
            if (baseDir != null && baseDir.length() > 0) {
                File saveDir = new File(baseDir).getAbsoluteFile();
                saveDir.mkdirs();
                return saveDir;
            }
            File f = new File(System.getProperty("user.home"), (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "" : ".") + "sqlline").getAbsoluteFile();
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                // empty catch block
            }
            return f;
        }

        public int complete(String buf, int pos, List cand) {
            try {
                return new StringsCompleter(this.propertyNames()).complete(buf, pos, cand);
            }
            catch (Throwable t) {
                return -1;
            }
        }

        public void save() throws IOException {
            FileOutputStream out = new FileOutputStream(this.rcFile);
            this.save(out);
            ((OutputStream)out).close();
        }

        public void save(OutputStream out) throws IOException {
            try {
                Properties props = this.toProperties();
                props.remove("sqlline.maxwidth");
                props.store(out, SqlLine.this.getApplicationTitle());
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
        }

        String[] propertyNames() throws IllegalAccessException, InvocationTargetException {
            TreeSet<String> names = new TreeSet<String>();
            Method[] m = this.getClass().getDeclaredMethods();
            for (int i = 0; m != null && i < m.length; ++i) {
                String propName;
                if (!m[i].getName().startsWith("get") || m[i].getParameterTypes().length != 0 || (propName = m[i].getName().substring(3).toLowerCase()).equals("run")) continue;
                names.add(propName);
            }
            return names.toArray(new String[names.size()]);
        }

        public Properties toProperties() throws IllegalAccessException, InvocationTargetException, ClassNotFoundException {
            Properties props = new Properties();
            String[] names = this.propertyNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                props.setProperty(PROPERTY_PREFIX + names[i], Reflector.invoke((Object)this, "get" + names[i], EMPTY_OBJ_ARRAY).toString());
            }
            SqlLine.this.debug("properties: " + props.toString());
            return props;
        }

        public void load() throws IOException {
            if (this.rcFile.exists()) {
                FileInputStream in = new FileInputStream(this.rcFile);
                this.load(in);
                ((InputStream)in).close();
            }
        }

        public void load(InputStream fin) throws IOException {
            Properties p = new Properties();
            p.load(fin);
            this.loadProperties(p);
        }

        public void loadProperties(Properties props) {
            Iterator<Object> i = props.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                if (key.equals(PROPERTY_NAME_EXIT) || !key.startsWith(PROPERTY_PREFIX)) continue;
                this.set(key.substring(PROPERTY_PREFIX.length()), props.getProperty(key));
            }
        }

        public void set(String key, String value) {
            this.set(key, value, false);
        }

        public boolean set(String key, String value, boolean quiet) {
            try {
                Reflector.invoke((Object)this, "set" + key, new Object[]{value});
                return true;
            }
            catch (Exception e) {
                if (!quiet) {
                    System.err.println(SqlLine.loc("error-setting", new Object[]{key, e}));
                }
                return false;
            }
        }

        public void setFastConnect(boolean fastConnect) {
            this.fastConnect = fastConnect;
        }

        public boolean getFastConnect() {
            return this.fastConnect;
        }

        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean getVerbose() {
            return this.verbose;
        }

        public void setShowTime(boolean showTime) {
            this.showTime = showTime;
        }

        public boolean getShowTime() {
            return this.showTime;
        }

        public void setShowWarnings(boolean showWarnings) {
            this.showWarnings = showWarnings;
        }

        public boolean getShowWarnings() {
            return this.showWarnings;
        }

        public void setShowNestedErrs(boolean showNestedErrs) {
            this.showNestedErrs = showNestedErrs;
        }

        public boolean getShowNestedErrs() {
            return this.showNestedErrs;
        }

        public void setNumberFormat(String numberFormat) {
            this.numberFormat = numberFormat;
        }

        public String getNumberFormat() {
            return this.numberFormat;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxColumnWidth(int maxColumnWidth) {
            this.maxColumnWidth = maxColumnWidth;
        }

        public int getMaxColumnWidth() {
            return this.maxColumnWidth;
        }

        public void setRowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
        }

        public int getRowLimit() {
            return this.rowLimit;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setIsolation(String isolation) {
            this.isolation = isolation;
        }

        public String getIsolation() {
            return this.isolation;
        }

        public void setHistoryFile(String historyFile) {
            this.historyFile = historyFile;
        }

        public String getHistoryFile() {
            return this.historyFile;
        }

        public void setColor(boolean color) {
            this.color = color;
        }

        public boolean getColor() {
            return this.color;
        }

        public void setShowHeader(boolean showHeader) {
            this.showHeader = showHeader;
        }

        public boolean getShowHeader() {
            return this.showHeader;
        }

        public void setHeaderInterval(int headerInterval) {
            this.headerInterval = headerInterval;
        }

        public int getHeaderInterval() {
            return this.headerInterval;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public boolean getForce() {
            return this.force;
        }

        public void setIncremental(boolean incremental) {
            this.incremental = incremental;
        }

        public boolean getIncremental() {
            return this.incremental;
        }

        public void setSilent(boolean silent) {
            this.silent = silent;
        }

        public boolean getSilent() {
            return this.silent;
        }

        public void setAutosave(boolean autosave) {
            this.autosave = autosave;
        }

        public boolean getAutosave() {
            return this.autosave;
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public void setTrimScripts(boolean trimScripts) {
            this.trimScripts = trimScripts;
        }

        public boolean getTrimScripts() {
            return this.trimScripts;
        }

        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public void setRun(String runFile) {
            this.runFile = runFile;
        }

        public String getRun() {
            return this.runFile;
        }
    }

    private class DatabaseConnection {
        Connection connection;
        DatabaseMetaData meta;
        Quoting quoting;
        private final String driver;
        private final String url;
        private final String username;
        private final String password;
        private Schema schema = null;
        private Completer sqlLineSQLCompleter = null;

        public DatabaseConnection(String driver, String url, String username, String password) throws SQLException {
            this.driver = driver;
            this.url = url;
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return this.url + "";
        }

        private void setCompletions(boolean skipmeta) throws SQLException, IOException {
            String startQuote = this.meta.getIdentifierQuoteString();
            boolean upper = this.meta.storesUpperCaseIdentifiers();
            if (startQuote == null || startQuote.equals("") || startQuote.equals(" ")) {
                this.quoting = this.meta.getDatabaseProductName().startsWith("MySQL") ? new Quoting('`', '`', upper) : new Quoting('\u0000', '\u0000', false);
            } else if (startQuote.equals("[")) {
                this.quoting = new Quoting('[', ']', upper);
            } else if (startQuote.length() > 1) {
                SqlLine.this.error("Identifier quote string is '" + startQuote + "'; quote strings longer than 1 char are not supported");
                this.quoting = Quoting.DEFAULT;
            } else {
                this.quoting = new Quoting(startQuote.charAt(0), startQuote.charAt(0), upper);
            }
            final String extraNameCharacters = this.meta == null || this.meta.getExtraNameCharacters() == null ? "" : this.meta.getExtraNameCharacters();
            this.sqlLineSQLCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)new ArgumentCompleter.WhitespaceArgumentDelimiter(){

                public boolean isDelimiterChar(CharSequence buffer, int pos) {
                    char c = buffer.charAt(pos);
                    if (Character.isWhitespace(c)) {
                        return true;
                    }
                    return !Character.isLetterOrDigit(c) && c != '_' && extraNameCharacters.indexOf(c) == -1;
                }
            }, new Completer[]{new SQLLineSQLCompletor(skipmeta)});
            ((ArgumentCompleter)this.sqlLineSQLCompleter).setStrict(false);
        }

        boolean connect() throws SQLException {
            try {
                if (this.driver != null && this.driver.length() != 0) {
                    Class.forName(this.driver);
                }
            }
            catch (ClassNotFoundException cnfe) {
                return SqlLine.this.error(cnfe);
            }
            boolean foundDriver = false;
            Driver theDriver = null;
            try {
                theDriver = DriverManager.getDriver(this.url);
                foundDriver = theDriver != null;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!foundDriver) {
                SqlLine.this.output(SqlLine.loc("autoloading-known-drivers", this.url));
                SqlLine.this.registerKnownDrivers();
            }
            try {
                this.close();
            }
            catch (Exception e) {
                return SqlLine.this.error(e);
            }
            Properties info = new Properties();
            info.put("user", this.username);
            info.put("password", this.password);
            this.connection = theDriver.connect(this.url, info);
            this.meta = this.connection.getMetaData();
            try {
                SqlLine.this.debug(SqlLine.loc("connected", new Object[]{this.meta.getDatabaseProductName(), this.meta.getDatabaseProductVersion()}));
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            try {
                SqlLine.this.debug(SqlLine.loc("driver", new Object[]{this.meta.getDriverName(), this.meta.getDriverVersion()}));
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            try {
                this.connection.setAutoCommit(SqlLine.this.opts.getAutoCommit());
                SqlLine.this.autocommitStatus(this.connection);
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            try {
                SqlLine.this.command.isolation("isolation: " + SqlLine.this.opts.getIsolation(), new DispatchCallback());
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            SqlLine.this.showWarnings();
            return true;
        }

        public Connection getConnection() throws SQLException {
            if (this.connection != null) {
                return this.connection;
            }
            this.connect();
            return this.connection;
        }

        public void reconnect() throws Exception {
            this.close();
            this.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                try {
                    if (this.connection != null && !this.connection.isClosed()) {
                        SqlLine.this.output(SqlLine.loc("closing", this.connection));
                        this.connection.close();
                    }
                }
                catch (Exception e) {
                    SqlLine.this.handleException(e);
                }
            }
            finally {
                this.connection = null;
                this.meta = null;
            }
        }

        public String[] getTableNames(boolean force) {
            Schema.Table[] t = this.getSchema().getTables();
            TreeSet<String> names = new TreeSet<String>();
            for (int i = 0; t != null && i < t.length; ++i) {
                names.add(t[i].getName());
            }
            return names.toArray(new String[names.size()]);
        }

        Schema getSchema() {
            if (this.schema == null) {
                this.schema = new Schema();
            }
            return this.schema;
        }

        class Schema {
            private Table[] tables = null;

            Schema() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Table[] getTables() {
                if (this.tables != null) {
                    return this.tables;
                }
                LinkedList<Table> tnames = new LinkedList<Table>();
                try {
                    ResultSet rs = DatabaseConnection.this.meta.getTables(DatabaseConnection.this.connection.getCatalog(), null, "%", new String[]{"TABLE"});
                    try {
                        while (rs.next()) {
                            tnames.add(new Table(rs.getString("TABLE_NAME")));
                        }
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.tables = tnames.toArray(new Table[0]);
                return this.tables;
            }

            Table getTable(String name) {
                Table[] t = this.getTables();
                for (int i = 0; t != null && i < t.length; ++i) {
                    if (!name.equalsIgnoreCase(t[i].getName())) continue;
                    return t[i];
                }
                return null;
            }

            class Table {
                final String name;
                Column[] columns;

                public Table(String name) {
                    this.name = name;
                }

                public String getName() {
                    return this.name;
                }

                class Column {
                    final String name;
                    boolean isPrimaryKey;

                    public Column(String name) {
                        this.name = name;
                    }
                }
            }
        }
    }

    private static class Connections {
        private final List connections = new ArrayList();
        private int index = -1;

        private Connections() {
        }

        public DatabaseConnection current() {
            if (this.index != -1) {
                return (DatabaseConnection)this.connections.get(this.index);
            }
            return null;
        }

        public int size() {
            return this.connections.size();
        }

        public Iterator iterator() {
            return this.connections.iterator();
        }

        public void remove() {
            if (this.index != -1) {
                this.connections.remove(this.index);
            }
            while (this.index >= this.connections.size()) {
                --this.index;
            }
        }

        public void addConnection(DatabaseConnection connection) {
            this.connections.add(connection);
        }

        public void setConnection(DatabaseConnection connection) {
            if (this.connections.indexOf(connection) == -1) {
                this.connections.add(connection);
            }
            this.index = this.connections.indexOf(connection);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean setIndex(int index) {
            if (index < 0 || index >= this.connections.size()) {
                return false;
            }
            this.index = index;
            return true;
        }
    }

    class SQLLineSQLCompletor
    extends StringsCompleter {
        public SQLLineSQLCompletor(boolean skipmeta) throws IOException, SQLException {
            super(new String[0]);
            TreeSet<String> completions = new TreeSet<String>();
            String keywords = new BufferedReader(new InputStreamReader(SQLLineSQLCompletor.class.getResourceAsStream("sql-keywords.properties"))).readLine();
            try {
                keywords = keywords + "," + SqlLine.this.con().meta.getSQLKeywords();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                keywords = keywords + "," + SqlLine.this.con().meta.getStringFunctions();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                keywords = keywords + "," + SqlLine.this.con().meta.getNumericFunctions();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                keywords = keywords + "," + SqlLine.this.con().meta.getSystemFunctions();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                keywords = keywords + "," + SqlLine.this.con().meta.getTimeDateFunctions();
            }
            catch (Throwable t) {
                // empty catch block
            }
            keywords = keywords + "," + keywords.toLowerCase();
            StringTokenizer tok = new StringTokenizer(keywords, ", ");
            while (tok.hasMoreTokens()) {
                completions.add(tok.nextToken());
            }
            if (!skipmeta) {
                String[] columns = SqlLine.this.getColumnNames(SqlLine.this.con().meta);
                for (int i = 0; columns != null && i < columns.length; ++i) {
                    completions.add(columns[i++]);
                }
            }
            this.getStrings().addAll(completions);
        }
    }

    class TableNameCompleter
    implements Completer {
        TableNameCompleter() {
        }

        public int complete(String buf, int pos, List cand) {
            if (SqlLine.this.con() == null) {
                return -1;
            }
            return new StringsCompleter(SqlLine.this.con().getTableNames(true)).complete(buf, pos, cand);
        }
    }

    class SQLLineCommandCompleter
    extends AggregateCompleter {
        public SQLLineCommandCompleter() {
            LinkedList<ArgumentCompleter> completors = new LinkedList<ArgumentCompleter>();
            for (int i = 0; i < SqlLine.this.commands.length; ++i) {
                String[] cmds = SqlLine.this.commands[i].getNames();
                for (int j = 0; cmds != null && j < cmds.length; ++j) {
                    Completer[] comps = SqlLine.this.commands[i].getParameterCompleters();
                    LinkedList<Object> compl = new LinkedList<Object>();
                    compl.add(new StringsCompleter(new String[]{SqlLine.COMMAND_PREFIX + cmds[j]}));
                    compl.addAll(Arrays.asList(comps));
                    compl.add(new NullCompleter());
                    completors.add(new ArgumentCompleter(compl));
                }
            }
            this.getCompleters().addAll(completors);
        }
    }

    class SQLLineCompleter
    implements Completer {
        SQLLineCompleter() {
        }

        public int complete(String buf, int pos, List cand) {
            if (buf != null && buf.startsWith(SqlLine.COMMAND_PREFIX) && !buf.startsWith("!all") && !buf.startsWith("!sql")) {
                return SqlLine.this.sqlLineCommandCompleter.complete(buf, pos, cand);
            }
            if (SqlLine.this.con() != null && SqlLine.this.con().sqlLineSQLCompleter != null) {
                return SqlLine.this.con().sqlLineSQLCompleter.complete(buf, pos, cand);
            }
            return -1;
        }
    }

    public class Commands {
        public void metadata(String line, DispatchCallback callback) {
            SqlLine.this.debug(line);
            String[] parts = SqlLine.this.split(line);
            LinkedList<String> params = new LinkedList<String>(Arrays.asList(parts));
            if (parts == null || parts.length == 0) {
                this.dbinfo("", callback);
                return;
            }
            params.remove(0);
            params.remove(0);
            SqlLine.this.debug(((Object)params).toString());
            this.metadata(parts[1], params, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void metadata(String cmd, List argList, DispatchCallback callback) {
            block10: {
                try {
                    Method[] m = SqlLine.this.con().meta.getClass().getMethods();
                    TreeSet<String> methodNames = new TreeSet<String>();
                    TreeSet<String> methodNamesUpper = new TreeSet<String>();
                    for (int i = 0; i < m.length; ++i) {
                        methodNames.add(m[i].getName());
                        methodNamesUpper.add(m[i].getName().toUpperCase());
                    }
                    if (!methodNamesUpper.contains(cmd.toUpperCase())) {
                        SqlLine.this.error(SqlLine.loc("no-such-method", cmd));
                        SqlLine.this.error(SqlLine.loc("possible-methods"));
                        Iterator i = methodNames.iterator();
                        while (i.hasNext()) {
                            SqlLine.this.error("   " + i.next());
                        }
                        callback.setToFailure();
                        return;
                    }
                    Object res = Reflector.invoke(SqlLine.this.con().meta, DatabaseMetaData.class, cmd, argList);
                    if (res instanceof ResultSet) {
                        ResultSet rs = (ResultSet)res;
                        if (rs == null) break block10;
                        try {
                            SqlLine.this.print(rs, callback);
                            break block10;
                        }
                        finally {
                            rs.close();
                        }
                    }
                    if (res != null) {
                        SqlLine.this.output(res.toString());
                    }
                }
                catch (Exception e) {
                    callback.setToFailure();
                    SqlLine.this.error(e);
                }
            }
            callback.setToSuccess();
        }

        public void history(String line, DispatchCallback callback) {
            ListIterator hist = SqlLine.this.reader.getHistory().entries();
            int index = 1;
            while (hist.hasNext()) {
                SqlLine.this.output(SqlLine.this.color().pad(++index + ".", 6).append(((History.Entry)hist.next()).toString()));
            }
            callback.setToSuccess();
        }

        String arg1(String line, String paramname) {
            return this.arg1(line, paramname, null);
        }

        String arg1(String line, String paramname, String def) {
            String[] ret = SqlLine.this.split(line);
            if (ret == null || ret.length != 2) {
                if (def != null) {
                    return def;
                }
                throw new IllegalArgumentException(SqlLine.loc("arg-usage", new Object[]{ret.length == 0 ? "" : ret[0], paramname}));
            }
            return ret[1];
        }

        private List buildMetadataArgs(String line, String paramname, String[] defaultValues) {
            String[] compound;
            ArrayList<String> list = new ArrayList<String>();
            String[][] ret = SqlLine.this.splitCompound(line);
            if (ret == null || ret.length != 2) {
                if (defaultValues[defaultValues.length - 1] == null) {
                    throw new IllegalArgumentException(SqlLine.loc("arg-usage", new Object[]{ret.length == 0 ? "" : ret[0][0], paramname}));
                }
                compound = new String[]{};
            } else {
                compound = ret[1];
            }
            if (compound.length <= defaultValues.length) {
                list.addAll(Arrays.asList(defaultValues).subList(0, defaultValues.length - compound.length));
                list.addAll(Arrays.asList(compound));
            } else {
                list.addAll(Arrays.asList(compound).subList(0, defaultValues.length));
            }
            return list;
        }

        public void indexes(String line, DispatchCallback callback) throws Exception {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            args.add(Boolean.FALSE);
            args.add(Boolean.TRUE);
            this.metadata("getIndexInfo", args, callback);
        }

        public void primarykeys(String line, DispatchCallback callback) throws Exception {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            this.metadata("getPrimaryKeys", args, callback);
        }

        public void exportedkeys(String line, DispatchCallback callback) throws Exception {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            this.metadata("getExportedKeys", args, callback);
        }

        public void importedkeys(String line, DispatchCallback callback) throws Exception {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            this.metadata("getImportedKeys", args, callback);
        }

        public void procedures(String line, DispatchCallback callback) throws Exception {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "procedure name pattern", strings);
            this.metadata("getProcedures", args, callback);
        }

        public void tables(String line, DispatchCallback callback) throws SQLException {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            args.add(null);
            this.metadata("getTables", args, callback);
        }

        public void typeinfo(String line, DispatchCallback callback) throws Exception {
            this.metadata("getTypeInfo", Collections.EMPTY_LIST, callback);
        }

        public void nativesql(String sql, DispatchCallback callback) throws Exception {
            if (sql.startsWith(SqlLine.COMMAND_PREFIX)) {
                sql = sql.substring(1);
            }
            if (sql.startsWith("native")) {
                sql = sql.substring("native".length() + 1);
            }
            String nat = SqlLine.this.con().getConnection().nativeSQL(sql);
            SqlLine.this.output(nat);
            callback.setToSuccess();
        }

        public void columns(String line, DispatchCallback callback) throws SQLException {
            String[] strings = new String[]{SqlLine.this.conn().getCatalog(), null, "%"};
            List args = this.buildMetadataArgs(line, "table name", strings);
            args.add("%");
            this.metadata("getColumns", args, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dropall(String line, DispatchCallback callback) {
            if (SqlLine.this.con() == null || SqlLine.this.con().url == null) {
                SqlLine.this.error(SqlLine.loc("no-current-connection"));
                callback.setToFailure();
                return;
            }
            try {
                if (!SqlLine.this.reader.readLine(SqlLine.loc("really-drop-all")).equals("y")) {
                    SqlLine.this.error("abort-drop-all");
                    callback.setToFailure();
                    return;
                }
                LinkedList<String> cmds = new LinkedList<String>();
                ResultSet rs = SqlLine.this.getTables();
                try {
                    while (rs.next()) {
                        cmds.add("DROP TABLE " + rs.getString("TABLE_NAME") + ";");
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (SqlLine.this.runCommands(cmds, callback) == cmds.size()) {
                    callback.setToSuccess();
                } else {
                    callback.setToFailure();
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        public void reconnect(String line, DispatchCallback callback) {
            if (SqlLine.this.con() == null || SqlLine.this.con().url == null) {
                SqlLine.this.error(SqlLine.loc("no-current-connection"));
                callback.setToFailure();
                return;
            }
            SqlLine.this.info(SqlLine.loc("reconnecting", SqlLine.this.con().url));
            try {
                SqlLine.this.con().reconnect();
            }
            catch (Exception e) {
                SqlLine.this.error(e);
                callback.setToFailure();
                return;
            }
            callback.setToSuccess();
        }

        public void scan(String line, DispatchCallback callback) throws IOException {
            TreeSet<String> names = new TreeSet<String>();
            if (SqlLine.this.drivers == null) {
                SqlLine.this.drivers = Arrays.asList(SqlLine.this.scanDrivers(line));
            }
            SqlLine.this.info(SqlLine.loc("drivers-found-count", SqlLine.this.drivers.size()));
            Iterator i = SqlLine.this.drivers.iterator();
            while (i.hasNext()) {
                names.add(((Driver)i.next()).getClass().getName());
            }
            SqlLine.this.output(SqlLine.this.color().bold(SqlLine.this.color().pad(SqlLine.loc("compliant"), 10).getMono()).bold(SqlLine.this.color().pad(SqlLine.loc("jdbc-version"), 8).getMono()).bold(SqlLine.this.color(SqlLine.loc("driver-class")).getMono()));
            i = names.iterator();
            while (i.hasNext()) {
                String name = i.next().toString();
                try {
                    Driver driver = (Driver)Class.forName(name).newInstance();
                    ColorBuffer msg = SqlLine.this.color().pad(driver.jdbcCompliant() ? "yes" : "no", 10).pad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8).append(name);
                    if (driver.jdbcCompliant()) {
                        SqlLine.this.output(msg);
                        continue;
                    }
                    SqlLine.this.output(SqlLine.this.color().red(msg.getMono()));
                }
                catch (Throwable t) {
                    SqlLine.this.output(SqlLine.this.color().red(name));
                }
            }
            callback.setToSuccess();
        }

        public void save(String line, DispatchCallback callback) throws IOException {
            SqlLine.this.info(SqlLine.loc("saving-options", SqlLine.this.opts.rcFile));
            SqlLine.this.opts.save();
            callback.setToSuccess();
        }

        public void load(String line, DispatchCallback callback) throws IOException {
            SqlLine.this.opts.load();
            SqlLine.this.info(SqlLine.loc("loaded-options", SqlLine.this.opts.rcFile));
            callback.setToSuccess();
        }

        public void config(String line, DispatchCallback callback) {
            try {
                Properties props = SqlLine.this.opts.toProperties();
                TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
                for (String string : keys) {
                    ColorBuffer colorBuffer = SqlLine.this.color();
                    ColorBuffer colorBuffer2 = SqlLine.this.color();
                    SqlLine.this.opts;
                    SqlLine.this.output(colorBuffer.green(colorBuffer2.pad(string.substring("sqlline.".length()), 20).getMono()).append(props.getProperty(string)));
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
                return;
            }
            callback.setToSuccess();
        }

        public void set(String line, DispatchCallback callback) {
            if (line == null || line.trim().equals("set") || line.length() == 0) {
                this.config(null, callback);
                return;
            }
            String[] parts = SqlLine.this.split(line, 3, "Usage: set <key> <value>");
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            String key = parts[1];
            String value = parts[2];
            boolean success = SqlLine.this.opts.set(key, value, false);
            if (success && SqlLine.this.opts.getAutosave()) {
                try {
                    SqlLine.this.opts.save();
                }
                catch (Exception saveException) {
                    // empty catch block
                }
            }
            callback.setToSuccess();
        }

        private void reportResult(String action, long start, long end) {
            if (SqlLine.this.opts.getShowTime()) {
                SqlLine.this.info(action + " " + SqlLine.loc("time-ms", new Object[]{new Double((double)(end - start) / 1000.0)}));
            } else {
                SqlLine.this.info(action);
            }
        }

        public void commit(String line, DispatchCallback callback) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            if (!SqlLine.this.assertAutoCommit()) {
                callback.setToFailure();
                return;
            }
            try {
                long start = System.currentTimeMillis();
                SqlLine.this.con().connection.commit();
                long end = System.currentTimeMillis();
                SqlLine.this.showWarnings();
                this.reportResult(SqlLine.loc("commit-complete"), start, end);
                callback.setToSuccess();
                return;
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
                return;
            }
        }

        public void rollback(String line, DispatchCallback callback) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            if (!SqlLine.this.assertAutoCommit()) {
                callback.setToFailure();
                return;
            }
            try {
                long start = System.currentTimeMillis();
                SqlLine.this.con().connection.rollback();
                long end = System.currentTimeMillis();
                SqlLine.this.showWarnings();
                this.reportResult(SqlLine.loc("rollback-complete"), start, end);
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        public void autocommit(String line, DispatchCallback callback) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            if (line.endsWith("on")) {
                SqlLine.this.con().connection.setAutoCommit(true);
            } else if (line.endsWith("off")) {
                SqlLine.this.con().connection.setAutoCommit(false);
            }
            SqlLine.this.showWarnings();
            SqlLine.this.autocommitStatus(SqlLine.this.con().connection);
            callback.setToSuccess();
        }

        public void dbinfo(String line, DispatchCallback callback) {
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            SqlLine.this.showWarnings();
            int padlen = 50;
            String[] m = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
            for (int i = 0; i < m.length; ++i) {
                try {
                    SqlLine.this.output(SqlLine.this.color().pad(m[i], padlen).append("" + Reflector.invoke((Object)SqlLine.this.con().meta, m[i], EMPTY_OBJ_ARRAY)));
                    continue;
                }
                catch (Exception e) {
                    SqlLine.this.handleException(e);
                }
            }
            callback.setToSuccess();
        }

        public void verbose(String line, DispatchCallback callback) {
            SqlLine.this.info("verbose: on");
            this.set("set verbose true", callback);
        }

        public void outputformat(String line, DispatchCallback callback) {
            this.set("set " + line, callback);
        }

        public void brief(String line, DispatchCallback callback) {
            SqlLine.this.info("verbose: off");
            this.set("set verbose false", callback);
        }

        public void isolation(String line, DispatchCallback callback) throws SQLException {
            String isoldesc;
            int i;
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            if (line.endsWith("TRANSACTION_NONE")) {
                i = 0;
            } else if (line.endsWith("TRANSACTION_READ_COMMITTED")) {
                i = 2;
            } else if (line.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
                i = 1;
            } else if (line.endsWith("TRANSACTION_REPEATABLE_READ")) {
                i = 4;
            } else if (line.endsWith("TRANSACTION_SERIALIZABLE")) {
                i = 8;
            } else {
                callback.setToFailure();
                SqlLine.this.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE>");
                return;
            }
            SqlLine.this.con().connection.setTransactionIsolation(i);
            int isol = SqlLine.this.con().connection.getTransactionIsolation();
            switch (i) {
                case 0: {
                    isoldesc = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    isoldesc = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 1: {
                    isoldesc = "TRANSACTION_READ_UNCOMMITTED";
                    break;
                }
                case 4: {
                    isoldesc = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    isoldesc = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    isoldesc = "UNKNOWN";
                }
            }
            SqlLine.this.debug(SqlLine.loc("isolation-status", isoldesc));
            callback.setToSuccess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void batch(String line, DispatchCallback callback) {
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            if (SqlLine.this.batch == null) {
                SqlLine.this.batch = new LinkedList();
                SqlLine.this.info(SqlLine.loc("batch-start"));
                callback.setToSuccess();
                return;
            }
            SqlLine.this.info(SqlLine.loc("running-batch"));
            try {
                SqlLine.this.runBatch(SqlLine.this.batch);
                callback.setToSuccess();
                return;
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
            finally {
                SqlLine.this.batch = null;
            }
        }

        public void sql(String line, DispatchCallback callback) {
            this.execute(line, false, callback);
        }

        public void call(String line, DispatchCallback callback) {
            this.execute(line, true, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(String line, boolean call, DispatchCallback callback) {
            String prefix;
            if (line == null || line.length() == 0) {
                callback.setStatus(DispatchCallback.Status.FAILURE);
            }
            try {
                while (!line.trim().endsWith(";")) {
                    StringBuffer prompt = new StringBuffer(SqlLine.this.getPrompt());
                    for (int i = 0; i < prompt.length() - 1; ++i) {
                        if (prompt.charAt(i) == '>') continue;
                        prompt.setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                    }
                    String extra = SqlLine.this.reader.readLine(prompt.toString());
                    if (null != extra) {
                        if (SqlLine.this.isComment(extra)) continue;
                        line = line + sep + extra;
                        continue;
                    }
                    break;
                }
            }
            catch (UserInterruptException uie) {
                callback.setStatus(DispatchCallback.Status.CANCELED);
                SqlLine.this.output(SqlLine.loc("command-canceled"));
                return;
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            if (line.trim().endsWith(";")) {
                line = line.trim();
                line = line.substring(0, line.length() - 1);
            }
            if (!SqlLine.this.assertConnection()) {
                callback.setToFailure();
                return;
            }
            String sql = line;
            if (sql.startsWith(SqlLine.COMMAND_PREFIX)) {
                sql = sql.substring(1);
            }
            String string = prefix = call ? "call" : "sql";
            if (sql.startsWith(prefix)) {
                sql = sql.substring(prefix.length());
            }
            if (SqlLine.this.batch != null) {
                SqlLine.this.batch.add(sql);
                callback.setToSuccess();
                return;
            }
            try {
                Statement stmnt = null;
                try {
                    boolean hasResults;
                    long start = System.currentTimeMillis();
                    if (call) {
                        stmnt = SqlLine.this.con().connection.prepareCall(sql);
                        callback.trackSqlQuery(stmnt);
                        hasResults = ((CallableStatement)stmnt).execute();
                    } else {
                        stmnt = SqlLine.this.createStatement();
                        callback.trackSqlQuery(stmnt);
                        hasResults = stmnt.execute(sql);
                        callback.setToSuccess();
                    }
                    SqlLine.this.showWarnings();
                    SqlLine.this.showWarnings(stmnt.getWarnings());
                    if (hasResults) {
                        do {
                            ResultSet rs = stmnt.getResultSet();
                            try {
                                int count = SqlLine.this.print(rs, callback);
                                long end = System.currentTimeMillis();
                                this.reportResult(SqlLine.loc("rows-selected", count), start, end);
                            }
                            finally {
                                rs.close();
                            }
                        } while (SqlLine.getMoreResults(stmnt));
                    } else {
                        int count = stmnt.getUpdateCount();
                        long end = System.currentTimeMillis();
                        this.reportResult(SqlLine.loc("rows-affected", count), start, end);
                    }
                }
                finally {
                    if (stmnt != null) {
                        SqlLine.this.showWarnings(stmnt.getWarnings());
                        stmnt.close();
                    }
                }
            }
            catch (UserInterruptException uie) {
                callback.setStatus(DispatchCallback.Status.CANCELED);
                SqlLine.this.output(SqlLine.loc("command-canceled"));
                return;
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
                return;
            }
            SqlLine.this.showWarnings();
            callback.setToSuccess();
        }

        public void quit(String line, DispatchCallback callback) {
            SqlLine.this.exit = true;
            this.close(null, callback);
        }

        public void closeall(String line, DispatchCallback callback) {
            this.close(null, callback);
            if (callback.isSuccess()) {
                while (callback.isSuccess()) {
                    this.close(null, callback);
                }
                callback.setToSuccess();
            }
            callback.setToFailure();
        }

        public void close(String line, DispatchCallback callback) {
            if (SqlLine.this.con() == null) {
                callback.setToFailure();
                return;
            }
            try {
                if (SqlLine.this.con().connection != null && !SqlLine.this.con().connection.isClosed()) {
                    SqlLine.this.info(SqlLine.loc("closing", SqlLine.this.con().connection.getClass().getName()));
                    SqlLine.this.con().connection.close();
                } else {
                    SqlLine.this.info(SqlLine.loc("already-closed"));
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
                return;
            }
            SqlLine.this.connections.remove();
            callback.setToSuccess();
        }

        public void properties(String line, DispatchCallback callback) throws Exception {
            String example = "";
            example = example + "Usage: properties <properties file>" + sep;
            String[] parts = SqlLine.this.split(line);
            if (parts.length < 2) {
                callback.setToFailure();
                SqlLine.this.error(example);
                return;
            }
            int successes = 0;
            for (int i = 1; i < parts.length; ++i) {
                Properties props = new Properties();
                props.load(new FileInputStream(parts[i]));
                this.connect(props, callback);
                if (!callback.isSuccess()) continue;
                ++successes;
            }
            if (successes != parts.length - 1) {
                callback.setToFailure();
            } else {
                callback.setToSuccess();
            }
        }

        public void connect(String line, DispatchCallback callback) throws Exception {
            String example = "";
            example = example + "Usage: connect <url> <username> <password> [driver]" + sep;
            String[] parts = SqlLine.this.split(line);
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            if (parts.length < 2) {
                callback.setToFailure();
                SqlLine.this.error(example);
                return;
            }
            String url = parts.length < 2 ? null : parts[1];
            String user = parts.length < 3 ? null : parts[2];
            String pass = parts.length < 4 ? null : parts[3];
            String driver = parts.length < 5 ? null : parts[4];
            Properties props = new Properties();
            if (url != null) {
                props.setProperty("url", url);
            }
            if (driver != null) {
                props.setProperty("driver", driver);
            }
            if (user != null) {
                props.setProperty("user", user);
            }
            if (pass != null) {
                props.setProperty("password", pass);
            }
            this.connect(props, callback);
        }

        private String getProperty(Properties props, String[] keys) {
            for (int i = 0; i < keys.length; ++i) {
                String string = props.getProperty(keys[i]);
                if (string == null) continue;
                return string;
            }
            for (String string : props.keySet()) {
                for (int j = 0; j < keys.length; ++j) {
                    if (!string.endsWith(keys[j])) continue;
                    return props.getProperty(string);
                }
            }
            return null;
        }

        public void connect(Properties props, DispatchCallback callback) throws IOException {
            String url = this.getProperty(props, new String[]{"url", "javax.jdo.option.ConnectionURL", "ConnectionURL"});
            String driver = this.getProperty(props, new String[]{"driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"});
            String username = this.getProperty(props, new String[]{"user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"});
            String password = this.getProperty(props, new String[]{"password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword"});
            if (url == null || url.length() == 0) {
                callback.setToFailure();
                SqlLine.this.error("Property \"url\" is required");
                return;
            }
            if (!(driver != null && driver.length() != 0 || SqlLine.this.scanForDriver(url))) {
                callback.setToFailure();
                SqlLine.this.error(SqlLine.loc("no-driver", url));
                return;
            }
            SqlLine.this.debug("Connecting to " + url);
            if (username == null) {
                username = SqlLine.this.reader.readLine("Enter username for " + url + ": ");
            }
            if (password == null) {
                password = SqlLine.this.reader.readLine("Enter password for " + url + ": ", new Character('*'));
            }
            try {
                SqlLine.this.completions.clear();
                SqlLine.this.connections.setConnection(new DatabaseConnection(driver, url, username, password));
                SqlLine.this.con().getConnection();
                SqlLine.this.setCompletions();
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        public void rehash(String line, DispatchCallback callback) {
            try {
                if (!SqlLine.this.assertConnection()) {
                    callback.setToFailure();
                }
                SqlLine.this.completions.clear();
                if (SqlLine.this.con() != null) {
                    SqlLine.this.con().setCompletions(false);
                }
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        public void list(String line, DispatchCallback callback) {
            int index = 0;
            SqlLine.this.info(SqlLine.loc("active-connections", SqlLine.this.connections.size()));
            Iterator i = SqlLine.this.connections.iterator();
            while (i.hasNext()) {
                DatabaseConnection c = (DatabaseConnection)i.next();
                boolean closed = false;
                try {
                    closed = c.connection.isClosed();
                }
                catch (Exception e) {
                    closed = true;
                }
                SqlLine.this.output(SqlLine.this.color().pad(" #" + index + "", 5).pad(closed ? SqlLine.loc("closed") : SqlLine.loc("open"), 9).append(c.url));
                ++index;
            }
            callback.setToSuccess();
        }

        public void all(String line, DispatchCallback callback) {
            int index = SqlLine.this.connections.getIndex();
            boolean success = true;
            for (int i = 0; i < SqlLine.this.connections.size(); ++i) {
                SqlLine.this.connections.setIndex(i);
                SqlLine.this.output(SqlLine.loc("executing-con", SqlLine.this.con()));
                this.sql(line.substring("all ".length()), callback);
                success = callback.isSuccess() && success;
            }
            SqlLine.this.connections.setIndex(index);
            if (success) {
                callback.setToSuccess();
            } else {
                callback.setToFailure();
            }
        }

        public void go(String line, DispatchCallback callback) {
            String[] parts = SqlLine.this.split(line, 2, "Usage: go <connection index>");
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            int index = Integer.parseInt(parts[1]);
            if (!SqlLine.this.connections.setIndex(index)) {
                SqlLine.this.error(SqlLine.loc("invalid-connection", "" + index));
                this.list("", callback);
                callback.setToFailure();
                return;
            }
            callback.setToSuccess();
        }

        public void script(String line, DispatchCallback callback) {
            if (SqlLine.this.script == null) {
                this.startScript(line, callback);
            } else {
                this.stopScript(line, callback);
            }
        }

        private void stopScript(String line, DispatchCallback callback) {
            try {
                SqlLine.this.script.close();
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            SqlLine.this.output(SqlLine.loc("script-closed", SqlLine.this.script));
            SqlLine.this.script = null;
            callback.setToSuccess();
        }

        private void startScript(String line, DispatchCallback callback) {
            if (SqlLine.this.script != null) {
                callback.setToFailure();
                SqlLine.this.error(SqlLine.loc("script-already-running", SqlLine.this.script));
                return;
            }
            String[] parts = SqlLine.this.split(line, 2, "Usage: script <filename>");
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            try {
                SqlLine.this.script = new OutputFile(parts[1]);
                SqlLine.this.output(SqlLine.loc("script-started", SqlLine.this.script));
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String line, DispatchCallback callback) {
            String[] parts = SqlLine.this.split(line, 2, "Usage: run <scriptfile>");
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            LinkedList<String> cmds = new LinkedList<String>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(parts[1]));
                try {
                    String scriptLine;
                    StringBuffer cmd = null;
                    while ((scriptLine = reader.readLine()) != null) {
                        String trimmedLine = scriptLine.trim();
                        if (SqlLine.this.opts.getTrimScripts()) {
                            scriptLine = trimmedLine;
                        }
                        if (cmd != null) {
                            cmd.append(" \n");
                            cmd.append(scriptLine);
                            if (!trimmedLine.endsWith(";")) continue;
                            cmds.add(cmd.toString());
                            cmd = null;
                            continue;
                        }
                        if (SqlLine.this.needsContinuation(scriptLine)) {
                            cmd = new StringBuffer(scriptLine);
                            continue;
                        }
                        cmds.add(scriptLine);
                    }
                    if (cmd != null) {
                        cmd.append(";");
                        cmds.add(cmd.toString());
                    }
                }
                finally {
                    reader.close();
                }
                if (SqlLine.this.runCommands(cmds, callback) == cmds.size()) {
                    callback.setToSuccess();
                } else {
                    callback.setToFailure();
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
                return;
            }
        }

        public void record(String line, DispatchCallback callback) {
            if (SqlLine.this.record == null) {
                this.startRecording(line, callback);
            } else {
                this.stopRecording(line, callback);
            }
        }

        private void stopRecording(String line, DispatchCallback callback) {
            try {
                SqlLine.this.record.close();
            }
            catch (Exception e) {
                SqlLine.this.handleException(e);
            }
            SqlLine.this.output(SqlLine.loc("record-closed", SqlLine.this.record));
            SqlLine.this.record = null;
            callback.setToSuccess();
        }

        private void startRecording(String line, DispatchCallback callback) {
            if (SqlLine.this.record != null) {
                callback.setToFailure();
                SqlLine.this.error(SqlLine.loc("record-already-running", SqlLine.this.record));
                return;
            }
            String[] parts = SqlLine.this.split(line, 2, "Usage: record <filename>");
            if (parts == null) {
                callback.setToFailure();
                return;
            }
            try {
                SqlLine.this.record = new OutputFile(parts[1]);
                SqlLine.this.output(SqlLine.loc("record-started", SqlLine.this.record));
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }

        public void describe(String line, DispatchCallback callback) throws SQLException {
            String[][] cmd = SqlLine.this.splitCompound(line);
            if (cmd.length != 2) {
                SqlLine.this.error("Usage: describe <table name>");
                callback.setToFailure();
                return;
            }
            if (cmd[1].length == 1 && cmd[1][0] != null && cmd[1][0].equalsIgnoreCase("tables")) {
                this.tables("tables", callback);
            } else {
                this.columns(line, callback);
            }
        }

        public void help(String line, DispatchCallback callback) {
            String[] parts = SqlLine.this.split(line);
            String cmd = parts.length > 1 ? parts[1] : "";
            TreeSet<ColorBuffer> clist = new TreeSet<ColorBuffer>();
            for (int i = 0; i < SqlLine.this.commands.length; ++i) {
                if (cmd.length() != 0 && !Arrays.asList(SqlLine.this.commands[i].getNames()).contains(cmd)) continue;
                clist.add(SqlLine.this.color().pad(SqlLine.COMMAND_PREFIX + SqlLine.this.commands[i].getName(), 20).append(SqlLine.this.wrap(SqlLine.this.commands[i].getHelpText(), 60, 20)));
            }
            Iterator i = clist.iterator();
            while (i.hasNext()) {
                SqlLine.this.output((ColorBuffer)i.next());
            }
            if (cmd.length() == 0) {
                SqlLine.this.output("");
                SqlLine.this.output(SqlLine.loc("comments", SqlLine.getApplicationContactInformation()));
            }
            callback.setToSuccess();
        }

        public void manual(String line, DispatchCallback callback) throws IOException {
            String man;
            InputStream in = SqlLine.class.getResourceAsStream("manual.txt");
            if (in == null) {
                callback.setToFailure();
                SqlLine.this.error(SqlLine.loc("no-manual"));
                return;
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(in));
            int index = 0;
            while ((man = breader.readLine()) != null) {
                String ret;
                SqlLine.this.output(man);
                if (++index % (SqlLine.this.opts.getMaxHeight() - 1) != 0 || (ret = SqlLine.this.reader.readLine(SqlLine.loc("enter-for-more"))) == null || !ret.startsWith("q")) continue;
                break;
            }
            breader.close();
            callback.setToSuccess();
        }
    }

    public class ReflectiveCommandHandler
    extends AbstractCommandHandler {
        public ReflectiveCommandHandler(String[] cmds, Completer[] completer) {
            super(cmds, SqlLine.loc("help-" + cmds[0]), completer);
        }

        public void execute(String line, DispatchCallback callback) {
            try {
                SqlLine.this.command.getClass().getMethod(this.getName(), String.class, DispatchCallback.class).invoke((Object)SqlLine.this.command, line, callback);
            }
            catch (Throwable e) {
                callback.setToFailure();
                SqlLine.this.error(e);
            }
        }
    }

    public abstract class AbstractCommandHandler
    implements CommandHandler {
        private final String name;
        private final String[] names;
        private final String helpText;
        private Completer[] parameterCompleters = new Completer[0];

        public AbstractCommandHandler(String[] names, String helpText, Completer[] completors) {
            this.name = names[0];
            this.names = names;
            this.helpText = helpText;
            if (completors == null || completors.length == 0) {
                this.parameterCompleters = new Completer[]{new NullCompleter()};
            } else {
                LinkedList<Completer> c = new LinkedList<Completer>(Arrays.asList(completors));
                c.add((Completer)new NullCompleter());
                this.parameterCompleters = c.toArray(new Completer[0]);
            }
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getName() {
            return this.name;
        }

        public String[] getNames() {
            return this.names;
        }

        public String matches(String line) {
            if (line == null || line.length() == 0) {
                return null;
            }
            String[] parts = SqlLine.this.split(line);
            if (parts == null || parts.length == 0) {
                return null;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].startsWith(parts[0])) continue;
                return this.names[i];
            }
            return null;
        }

        public void setParameterCompleters(Completer[] parameterCompleters) {
            this.parameterCompleters = parameterCompleters;
        }

        public Completer[] getParameterCompleters() {
            return this.parameterCompleters;
        }
    }

    static final class ColorBuffer
    implements Comparable {
        private static final ColorAttr BOLD = new ColorAttr("\u001b[1m");
        private static final ColorAttr NORMAL = new ColorAttr("\u001b[m");
        private static final ColorAttr REVERS = new ColorAttr("\u001b[7m");
        private static final ColorAttr LINED = new ColorAttr("\u001b[4m");
        private static final ColorAttr GREY = new ColorAttr("\u001b[1;30m");
        private static final ColorAttr RED = new ColorAttr("\u001b[1;31m");
        private static final ColorAttr GREEN = new ColorAttr("\u001b[1;32m");
        private static final ColorAttr BLUE = new ColorAttr("\u001b[1;34m");
        private static final ColorAttr CYAN = new ColorAttr("\u001b[1;36m");
        private static final ColorAttr YELLOW = new ColorAttr("\u001b[1;33m");
        private static final ColorAttr MAGENTA = new ColorAttr("\u001b[1;35m");
        private static final ColorAttr INVISIBLE = new ColorAttr("\u001b[8m");
        private final List parts = new LinkedList();
        private final boolean useColor;

        public ColorBuffer(boolean useColor) {
            this.useColor = useColor;
            this.append("");
        }

        public ColorBuffer(String str, boolean useColor) {
            this.useColor = useColor;
            this.append(str);
        }

        ColorBuffer pad(ColorBuffer str, int len) {
            for (int n = str.getVisibleLength(); n < len; ++n) {
                str.append(" ");
            }
            return this.append(str);
        }

        ColorBuffer center(String str, int len) {
            StringBuffer buf = new StringBuffer(str);
            while (buf.length() < len) {
                buf.append(" ");
                if (buf.length() >= len) continue;
                buf.insert(0, " ");
            }
            return this.append(buf.toString());
        }

        ColorBuffer pad(String str, int len) {
            if (str == null) {
                str = "";
            }
            return this.pad(new ColorBuffer(str, false), len);
        }

        public String getColor() {
            return this.getBuffer(this.useColor);
        }

        public String getMono() {
            return this.getBuffer(false);
        }

        String getBuffer(boolean color) {
            StringBuffer buf = new StringBuffer();
            for (Object next : this.parts) {
                if (!color && next instanceof ColorAttr) continue;
                buf.append(next.toString());
            }
            return buf.toString();
        }

        public ColorBuffer truncate(int len) {
            ColorBuffer cbuff = new ColorBuffer(this.useColor);
            ColorAttr lastAttr = null;
            Iterator i = this.parts.iterator();
            while (cbuff.getVisibleLength() < len && i.hasNext()) {
                Object next = i.next();
                if (next instanceof ColorAttr) {
                    lastAttr = (ColorAttr)next;
                    cbuff.append((ColorAttr)next);
                    continue;
                }
                String val = next.toString();
                if (cbuff.getVisibleLength() + val.length() > len) {
                    int partLen = len - cbuff.getVisibleLength();
                    val = val.substring(0, partLen);
                }
                cbuff.append(val);
            }
            if (lastAttr != null && lastAttr != NORMAL) {
                cbuff.append(NORMAL);
            }
            return cbuff;
        }

        public String toString() {
            return this.getColor();
        }

        public ColorBuffer append(String str) {
            this.parts.add(str);
            return this;
        }

        public ColorBuffer append(ColorBuffer buf) {
            this.parts.addAll(buf.parts);
            return this;
        }

        public ColorBuffer append(ColorAttr attr) {
            this.parts.add(attr);
            return this;
        }

        public int getVisibleLength() {
            return this.getMono().length();
        }

        public ColorBuffer append(ColorAttr attr, String val) {
            this.parts.add(attr);
            this.parts.add(val);
            this.parts.add(NORMAL);
            return this;
        }

        public ColorBuffer bold(String str) {
            return this.append(BOLD, str);
        }

        public ColorBuffer lined(String str) {
            return this.append(LINED, str);
        }

        public ColorBuffer grey(String str) {
            return this.append(GREY, str);
        }

        public ColorBuffer red(String str) {
            return this.append(RED, str);
        }

        public ColorBuffer blue(String str) {
            return this.append(BLUE, str);
        }

        public ColorBuffer green(String str) {
            return this.append(GREEN, str);
        }

        public ColorBuffer cyan(String str) {
            return this.append(CYAN, str);
        }

        public ColorBuffer yellow(String str) {
            return this.append(YELLOW, str);
        }

        public ColorBuffer magenta(String str) {
            return this.append(MAGENTA, str);
        }

        public int compareTo(Object other) {
            return this.getMono().compareTo(((ColorBuffer)other).getMono());
        }

        private static class ColorAttr {
            private final String attr;

            public ColorAttr(String attr) {
                this.attr = attr;
            }

            public String toString() {
                return this.attr;
            }
        }
    }

    class IncrementalRows
    extends Rows {
        private final ResultSet rs;
        private Rows.Row labelRow;
        private Rows.Row maxRow;
        private Rows.Row nextRow;
        private boolean endOfResult;
        private boolean normalizingWidths;
        private DispatchCallback dispatchCallback;

        IncrementalRows(ResultSet rs, DispatchCallback dispatchCallback) throws SQLException {
            super(rs);
            this.rs = rs;
            this.dispatchCallback = dispatchCallback;
            this.labelRow = new Rows.Row(this.rsMeta.getColumnCount());
            this.maxRow = new Rows.Row(this.rsMeta.getColumnCount());
            for (int i = 0; i < this.maxRow.sizes.length; ++i) {
                ((Rows.Row)this.maxRow).sizes[i] = Math.max(this.maxRow.sizes[i], this.rsMeta.getColumnDisplaySize(i + 1));
            }
            this.nextRow = this.labelRow;
            this.endOfResult = false;
        }

        public boolean hasNext() {
            if (this.endOfResult || this.dispatchCallback.isCanceled()) {
                return false;
            }
            if (this.nextRow == null) {
                try {
                    if (this.rs.next()) {
                        this.nextRow = new Rows.Row(this.labelRow.sizes.length, this.rs);
                        if (this.normalizingWidths) {
                            Rows.Row.access$902(this.nextRow, this.labelRow.sizes);
                        }
                    } else {
                        this.endOfResult = true;
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
            return this.nextRow != null;
        }

        public Object next() {
            if (!this.hasNext() && !this.dispatchCallback.isCanceled()) {
                throw new NoSuchElementException();
            }
            Rows.Row ret = this.nextRow;
            this.nextRow = null;
            return ret;
        }

        void normalizeWidths() {
            Rows.Row.access$902(this.labelRow, this.maxRow.sizes);
            this.normalizingWidths = true;
        }
    }

    class BufferedRows
    extends Rows {
        private final LinkedList list;
        private final Iterator iterator;

        BufferedRows(ResultSet rs) throws SQLException {
            super(rs);
            this.list = new LinkedList();
            int count = this.rsMeta.getColumnCount();
            this.list.add(new Rows.Row(count));
            while (rs.next()) {
                this.list.add(new Rows.Row(count, rs));
            }
            this.iterator = this.list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        void normalizeWidths() {
            Rows.Row row;
            int i;
            int[] max = null;
            for (i = 0; i < this.list.size(); ++i) {
                row = (Rows.Row)this.list.get(i);
                if (max == null) {
                    max = new int[row.values.length];
                }
                for (int j = 0; j < max.length; ++j) {
                    max[j] = Math.max(max[j], row.sizes[j] + 1);
                }
            }
            for (i = 0; i < this.list.size(); ++i) {
                row = (Rows.Row)this.list.get(i);
                Rows.Row.access$902(row, max);
            }
        }
    }

    abstract class Rows
    implements Iterator {
        final ResultSetMetaData rsMeta;
        final Boolean[] primaryKeys;
        final NumberFormat numberFormat;

        Rows(ResultSet rs) throws SQLException {
            this.rsMeta = rs.getMetaData();
            int count = this.rsMeta.getColumnCount();
            this.primaryKeys = new Boolean[count];
            this.numberFormat = SqlLine.this.opts.getNumberFormat().equals("default") ? null : new DecimalFormat(SqlLine.this.opts.getNumberFormat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract void normalizeWidths();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isPrimaryKey(int col) {
            if (this.primaryKeys[col] != null) {
                return this.primaryKeys[col];
            }
            try {
                String table = this.rsMeta.getTableName(col + 1);
                String column = this.rsMeta.getColumnName(col + 1);
                if (table == null || table.length() == 0 || column == null || column.length() == 0) {
                    this.primaryKeys[col] = new Boolean(false);
                    return this.primaryKeys[col];
                }
                ResultSet pks = SqlLine.this.con().meta.getPrimaryKeys(SqlLine.this.con().meta.getConnection().getCatalog(), null, table);
                try {
                    while (pks.next()) {
                        if (!column.equalsIgnoreCase(pks.getString("COLUMN_NAME"))) continue;
                        this.primaryKeys[col] = new Boolean(true);
                        boolean bl = this.primaryKeys[col];
                        return bl;
                    }
                }
                finally {
                    pks.close();
                }
                this.primaryKeys[col] = new Boolean(false);
                return this.primaryKeys[col];
            }
            catch (SQLException sqle) {
                this.primaryKeys[col] = new Boolean(false);
                return this.primaryKeys[col];
            }
        }

        class Row {
            final String[] values;
            final boolean isMeta;
            private boolean deleted;
            private boolean inserted;
            private boolean updated;
            private int[] sizes;

            Row(int size) throws SQLException {
                this.isMeta = true;
                this.values = new String[size];
                this.sizes = new int[size];
                for (int i = 0; i < size; ++i) {
                    this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                    this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
                }
                this.deleted = false;
                this.updated = false;
                this.inserted = false;
            }

            Row(int size, ResultSet rs) throws SQLException {
                this.isMeta = false;
                this.values = new String[size];
                this.sizes = new int[size];
                try {
                    this.deleted = rs.rowDeleted();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    this.updated = rs.rowUpdated();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    this.inserted = rs.rowInserted();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                for (int i = 0; i < size; ++i) {
                    Object o;
                    this.values[i] = Rows.this.numberFormat != null ? ((o = rs.getObject(i + 1)) == null ? null : (o instanceof Number ? Rows.this.numberFormat.format(o) : o.toString())) : String.valueOf(rs.getObject(i + 1));
                    this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
                }
            }

            static /* synthetic */ int[] access$902(Row x0, int[] x1) {
                x0.sizes = x1;
                return x1;
            }
        }
    }

    class TableOutputFormat
    implements OutputFormat {
        TableOutputFormat() {
        }

        public int print(Rows rows) {
            int index = 0;
            ColorBuffer header = null;
            ColorBuffer headerCols = null;
            int width = SqlLine.this.opts.getMaxWidth() - 4;
            rows.normalizeWidths();
            while (rows.hasNext()) {
                Rows.Row row = (Rows.Row)rows.next();
                ColorBuffer cbuf = this.getOutputString(rows, row);
                cbuf = cbuf.truncate(width);
                if (index == 0) {
                    StringBuffer h = new StringBuffer();
                    for (int j = 0; j < row.sizes.length; ++j) {
                        for (int k = 0; k < row.sizes[j]; ++k) {
                            h.append('-');
                        }
                        h.append("-+-");
                    }
                    headerCols = cbuf;
                    header = SqlLine.this.color().green(h.toString()).truncate(headerCols.getVisibleLength());
                }
                if (index == 0 || SqlLine.this.opts.getHeaderInterval() > 0 && index % SqlLine.this.opts.getHeaderInterval() == 0 && SqlLine.this.opts.getShowHeader()) {
                    this.printRow(header, true);
                    this.printRow(headerCols, false);
                    this.printRow(header, true);
                }
                if (index != 0) {
                    this.printRow(cbuf, false);
                }
                ++index;
            }
            if (header != null && SqlLine.this.opts.getShowHeader()) {
                this.printRow(header, true);
            }
            return index - 1;
        }

        void printRow(ColorBuffer cbuff, boolean header) {
            if (header) {
                SqlLine.this.output(SqlLine.this.color().green("+-").append(cbuff).green("-+"));
            } else {
                SqlLine.this.output(SqlLine.this.color().green("| ").append(cbuff).green(" |"));
            }
        }

        public ColorBuffer getOutputString(Rows rows, Rows.Row row) {
            return this.getOutputString(rows, row, " | ");
        }

        ColorBuffer getOutputString(Rows rows, Rows.Row row, String delim) {
            ColorBuffer buf = SqlLine.this.color();
            for (int i = 0; i < row.values.length; ++i) {
                ColorBuffer v;
                if (buf.getVisibleLength() > 0) {
                    buf.green(delim);
                }
                if (row.isMeta) {
                    v = SqlLine.this.color().center(row.values[i], row.sizes[i]);
                    if (rows.isPrimaryKey(i)) {
                        buf.cyan(v.getMono());
                        continue;
                    }
                    buf.bold(v.getMono());
                    continue;
                }
                v = SqlLine.this.color().pad(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    buf.cyan(v.getMono());
                    continue;
                }
                buf.append(v.getMono());
            }
            if (row.deleted) {
                buf = SqlLine.this.color().red(buf.getMono());
            } else if (row.updated) {
                buf = SqlLine.this.color().blue(buf.getMono());
            } else if (row.inserted) {
                buf = SqlLine.this.color().green(buf.getMono());
            }
            return buf;
        }
    }

    class SeparatedValuesOutputFormat
    implements OutputFormat {
        private char separator;

        public SeparatedValuesOutputFormat(char separator) {
            this.setSeparator(separator);
        }

        public int print(Rows rows) {
            int count = 0;
            while (rows.hasNext()) {
                this.printRow(rows, (Rows.Row)rows.next());
                ++count;
            }
            return count - 1;
        }

        public void printRow(Rows rows, Rows.Row row) {
            String[] vals = row.values;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                buf.append(buf.length() == 0 ? "" : "" + this.getSeparator()).append('\'').append(vals[i] == null ? "" : vals[i]).append('\'');
            }
            SqlLine.this.output(buf.toString());
        }

        public void setSeparator(char separator) {
            this.separator = separator;
        }

        public char getSeparator() {
            return this.separator;
        }
    }

    class VerticalOutputFormat
    implements OutputFormat {
        VerticalOutputFormat() {
        }

        public int print(Rows rows) {
            int count = 0;
            Rows.Row header = (Rows.Row)rows.next();
            while (rows.hasNext()) {
                this.printRow(rows, header, (Rows.Row)rows.next());
                ++count;
            }
            return count;
        }

        public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
            int i;
            String[] head = header.values;
            String[] vals = row.values;
            int headwidth = 0;
            for (i = 0; i < head.length && i < vals.length; ++i) {
                headwidth = Math.max(headwidth, head[i].length());
            }
            headwidth += 2;
            for (i = 0; i < head.length && i < vals.length; ++i) {
                SqlLine.this.output(SqlLine.this.color().bold(SqlLine.this.color().pad(head[i], headwidth).getMono()).append(vals[i] == null ? "" : vals[i]));
            }
            SqlLine.this.output("");
        }
    }

    class XMLElementOutputFormat
    extends AbstractOutputFormat {
        XMLElementOutputFormat() {
        }

        public void printHeader(Rows.Row header) {
            SqlLine.this.output("<resultset>");
        }

        public void printFooter(Rows.Row header) {
            SqlLine.this.output("</resultset>");
        }

        public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
            String[] head = header.values;
            String[] vals = row.values;
            SqlLine.this.output("  <result>");
            for (int i = 0; i < head.length && i < vals.length; ++i) {
                SqlLine.this.output("    <" + head[i] + ">" + SqlLine.xmlattrencode(vals[i]) + "</" + head[i] + ">");
            }
            SqlLine.this.output("  </result>");
        }
    }

    class XMLAttributeOutputFormat
    extends AbstractOutputFormat {
        XMLAttributeOutputFormat() {
        }

        public void printHeader(Rows.Row header) {
            SqlLine.this.output("<resultset>");
        }

        public void printFooter(Rows.Row header) {
            SqlLine.this.output("</resultset>");
        }

        public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
            String[] head = header.values;
            String[] vals = row.values;
            StringBuffer result = new StringBuffer("  <result");
            for (int i = 0; i < head.length && i < vals.length; ++i) {
                result.append(' ').append(head[i]).append("=\"").append(SqlLine.xmlattrencode(vals[i])).append('\"');
            }
            result.append("/>");
            SqlLine.this.output(result.toString());
        }
    }

    abstract class AbstractOutputFormat
    implements OutputFormat {
        AbstractOutputFormat() {
        }

        public int print(Rows rows) {
            int count = 0;
            Rows.Row header = (Rows.Row)rows.next();
            this.printHeader(header);
            while (rows.hasNext()) {
                this.printRow(rows, header, (Rows.Row)rows.next());
                ++count;
            }
            this.printFooter(header);
            return count;
        }

        abstract void printHeader(Rows.Row var1);

        abstract void printFooter(Rows.Row var1);

        abstract void printRow(Rows var1, Rows.Row var2, Rows.Row var3);
    }

    static interface CommandHandler {
        public String getName();

        public String[] getNames();

        public String getHelpText();

        public String matches(String var1);

        public void execute(String var1, DispatchCallback var2);

        public Completer[] getParameterCompleters();
    }

    static interface OutputFormat {
        public int print(Rows var1);
    }
}

