/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class MapOperator
extends Operator<MapWork>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private final Map<MapInputPath, MapOpCtx> opCtxMap = new HashMap<MapInputPath, MapOpCtx>();
    private final Map<Operator<? extends OperatorDesc>, MapOpCtx> childrenOpToOpCtxMap = new HashMap<Operator<? extends OperatorDesc>, MapOpCtx>();
    private transient MapOpCtx current;
    private transient List<Operator<? extends OperatorDesc>> extraChildrenToClose = null;

    public void initializeAsRoot(Configuration hconf, MapWork mapWork) throws HiveException {
        this.setConf(mapWork);
        this.setChildren(hconf);
        this.initialize(hconf, null);
    }

    private MapOpCtx initObjectInspector(Configuration hconf, MapInputPath ctx, Map<TableDesc, StructObjectInspector> convertedOI) throws Exception {
        TableScanOperator tsOp;
        TableScanDesc tsDesc;
        PartitionDesc pd = ctx.partDesc;
        TableDesc td = pd.getTableDesc();
        MapOpCtx opCtx = new MapOpCtx();
        Properties partProps = this.isPartitioned(pd) ? pd.getOverlayedProperties() : pd.getTableDesc().getProperties();
        LinkedHashMap<String, String> partSpec = pd.getPartSpec();
        opCtx.tableName = String.valueOf(partProps.getProperty("name"));
        opCtx.partName = String.valueOf(partSpec);
        Class serdeclass = pd.getDeserializerClass();
        if (serdeclass == null) {
            String className = this.checkSerdeClassName(pd.getSerdeClassName(), opCtx.tableName);
            serdeclass = hconf.getClassByName(className);
        }
        opCtx.deserializer = serdeclass.newInstance();
        opCtx.deserializer.initialize(hconf, partProps);
        StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)opCtx.deserializer.getObjectInspector();
        opCtx.tblRawRowObjectInspector = convertedOI.get(td);
        opCtx.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter(partRawRowObjectInspector, opCtx.tblRawRowObjectInspector);
        String pcols = partProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String[] partKeys = pcols.trim().split("/");
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                partValues[i] = partSpec == null ? null : new Text((String)partSpec.get(key));
                partObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            }
            opCtx.rowWithPart = new Object[]{null, partValues};
            opCtx.partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        }
        if (ctx.op instanceof TableScanOperator && (tsDesc = (TableScanDesc)(tsOp = (TableScanOperator)ctx.op).getConf()) != null && tsDesc.hasVirtualCols()) {
            opCtx.vcs = tsDesc.getVirtualCols();
            opCtx.vcValues = new Writable[opCtx.vcs.size()];
            opCtx.vcsObjectInspector = VirtualColumn.getVCSObjectInspector(opCtx.vcs);
            opCtx.rowWithPartAndVC = opCtx.isPartitioned() ? Arrays.copyOfRange(opCtx.rowWithPart, 0, 3) : new Object[2];
        }
        if (!opCtx.hasVC() && !opCtx.isPartitioned()) {
            opCtx.rowObjectInspector = opCtx.tblRawRowObjectInspector;
            return opCtx;
        }
        ArrayList<StructObjectInspector> inspectors = new ArrayList<StructObjectInspector>();
        inspectors.add(opCtx.tblRawRowObjectInspector);
        if (opCtx.isPartitioned()) {
            inspectors.add(opCtx.partObjectInspector);
        }
        if (opCtx.hasVC()) {
            inspectors.add(opCtx.vcsObjectInspector);
        }
        opCtx.rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(inspectors);
        return opCtx;
    }

    private Map<TableDesc, StructObjectInspector> getConvertedOI(Configuration hconf) throws HiveException {
        HashMap<TableDesc, StructObjectInspector> tableDescOI = new HashMap<TableDesc, StructObjectInspector>();
        HashSet<TableDesc> identityConverterTableDesc = new HashSet<TableDesc>();
        try {
            for (String onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
                PartitionDesc pd = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
                TableDesc tableDesc = pd.getTableDesc();
                Properties tblProps = tableDesc.getProperties();
                Properties partProps = this.isPartitioned(pd) ? pd.getOverlayedProperties() : tblProps;
                Class sdclass = pd.getDeserializerClass();
                if (sdclass == null) {
                    String className = this.checkSerdeClassName(pd.getSerdeClassName(), pd.getProperties().getProperty("name"));
                    sdclass = hconf.getClassByName(className);
                }
                Deserializer partDeserializer = sdclass.newInstance();
                partDeserializer.initialize(hconf, partProps);
                StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
                StructObjectInspector tblRawRowObjectInspector = (StructObjectInspector)tableDescOI.get(tableDesc);
                if (tblRawRowObjectInspector != null && !identityConverterTableDesc.contains(tableDesc)) continue;
                sdclass = tableDesc.getDeserializerClass();
                if (sdclass == null) {
                    String className = this.checkSerdeClassName(tableDesc.getSerdeClassName(), tableDesc.getProperties().getProperty("name"));
                    sdclass = hconf.getClassByName(className);
                }
                Deserializer tblDeserializer = sdclass.newInstance();
                tblDeserializer.initialize(hconf, tblProps);
                tblRawRowObjectInspector = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI(partRawRowObjectInspector, tblDeserializer.getObjectInspector(), true);
                if (identityConverterTableDesc.contains(tableDesc)) {
                    if (!partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                        identityConverterTableDesc.remove(tableDesc);
                    }
                } else if (partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                    identityConverterTableDesc.add(tableDesc);
                }
                tableDescOI.put(tableDesc, tblRawRowObjectInspector);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return tableDescOI;
    }

    private boolean isPartitioned(PartitionDesc pd) {
        return pd.getPartSpec() != null && !pd.getPartSpec().isEmpty();
    }

    private String checkSerdeClassName(String className, String tableName) throws HiveException {
        if (className == null || className.isEmpty()) {
            throw new HiveException("SerDe class or the SerDe class name is not set for table: " + tableName);
        }
        return className;
    }

    public void setChildren(Configuration hconf) throws HiveException {
        Path fpath = new Path(HiveConf.getVar(hconf, HiveConf.ConfVars.HADOOPMAPFILENAME));
        boolean schemeless = fpath.toUri().getScheme() == null;
        ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
        Map<TableDesc, StructObjectInspector> convertedOI = this.getConvertedOI(hconf);
        try {
            for (Map.Entry<String, ArrayList<String>> entry : ((MapWork)this.conf).getPathToAliases().entrySet()) {
                String onefile = entry.getKey();
                List aliases = entry.getValue();
                Path onepath = new Path(onefile);
                if (schemeless) {
                    onepath = new Path(onepath.toUri().getPath());
                }
                PartitionDesc partDesc = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
                for (String onealias : aliases) {
                    Operator<? extends OperatorDesc> op = ((MapWork)this.conf).getAliasToWork().get(onealias);
                    this.LOG.info((Object)("Adding alias " + onealias + " to work list for file " + onefile));
                    MapInputPath inp = new MapInputPath(onefile, onealias, op, partDesc);
                    if (this.opCtxMap.containsKey(inp)) continue;
                    MapOpCtx opCtx = this.initObjectInspector(hconf, inp, convertedOI);
                    this.opCtxMap.put(inp, opCtx);
                    op.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                    op.getParentOperators().add(this);
                    if (!onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) {
                        children.add(op);
                        this.childrenOpToOpCtxMap.put(op, opCtx);
                        this.LOG.info((Object)("dump " + op.getName() + " " + this.opCtxMap.get((Object)inp).rowObjectInspector.getTypeName()));
                    }
                    this.current = opCtx;
                }
            }
            if (children.size() == 0) {
                this.LOG.error((Object)("Configuration does not have any alias for path: " + fpath.toUri()));
                throw new HiveException("Configuration and input path are inconsistent");
            }
            this.setChildOperators(children);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        MapOpCtx mapOpCtx;
        this.state = Operator.State.INIT;
        this.statsMap.put(Counter.DESERIALIZE_ERRORS, this.deserialize_error_count);
        List<Operator<OperatorDesc>> children = this.getChildOperators();
        for (Map.Entry<Operator<? extends OperatorDesc>, MapOpCtx> entry : this.childrenOpToOpCtxMap.entrySet()) {
            Operator<? extends OperatorDesc> child = entry.getKey();
            mapOpCtx = entry.getValue();
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, mapOpCtx.tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, mapOpCtx.partName);
            child.initialize(hconf, new ObjectInspector[]{mapOpCtx.rowObjectInspector});
        }
        for (Map.Entry<Object, MapOpCtx> entry : this.opCtxMap.entrySet()) {
            MapInputPath input = (MapInputPath)entry.getKey();
            mapOpCtx = entry.getValue();
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, mapOpCtx.tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, mapOpCtx.partName);
            Operator<?> op = input.op;
            if (children.indexOf(op) != -1) continue;
            if (this.extraChildrenToClose == null) {
                this.extraChildrenToClose = new ArrayList<Operator<? extends OperatorDesc>>();
            }
            this.extraChildrenToClose.add(op);
            op.initialize(hconf, new ObjectInspector[]{entry.getValue().rowObjectInspector});
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.extraChildrenToClose != null) {
            for (Operator<? extends OperatorDesc> op : this.extraChildrenToClose) {
                op.close(abort);
            }
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        Path fpath = this.normalizePath(this.getExecContext().getCurrentInputFile());
        for (String onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
            Path onepath = this.normalizePath(onefile);
            if (onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) continue;
            PartitionDesc partDesc = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
            for (String onealias : ((MapWork)this.conf).getPathToAliases().get(onefile)) {
                Operator<? extends OperatorDesc> op;
                MapInputPath inp = new MapInputPath(onefile, onealias, op = ((MapWork)this.conf).getAliasToWork().get(onealias), partDesc);
                MapOpCtx context = this.opCtxMap.get(inp);
                if (context == null) continue;
                this.current = context;
                this.LOG.info((Object)("Processing alias " + onealias + " for file " + onefile));
                return;
            }
        }
        throw new IllegalStateException("Invalid path " + fpath);
    }

    private Path normalizePath(String onefile) {
        return new Path(onefile);
    }

    public void process(Writable value) throws HiveException {
        Object[] row;
        ExecMapperContext context = this.getExecContext();
        if (context != null && context.inputFileChanged()) {
            this.cleanUpInputFileChanged();
        }
        try {
            row = this.current.readRow(value);
            if (this.current.hasVC()) {
                this.current.rowWithPartAndVC[0] = row;
                if (context != null) {
                    MapOperator.populateVirtualColumnValues(context, this.current.vcs, this.current.vcValues, this.current.deserializer);
                }
                int vcPos = this.current.isPartitioned() ? 2 : 1;
                this.current.rowWithPartAndVC[vcPos] = this.current.vcValues;
                row = this.current.rowWithPartAndVC;
            } else if (this.current.isPartitioned()) {
                this.current.rowWithPart[0] = row;
                row = this.current.rowWithPart;
            }
        }
        catch (Exception e) {
            String rawRowString;
            try {
                rawRowString = value.toString();
            }
            catch (Exception e2) {
                rawRowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
            throw new HiveException("Hive Runtime Error while processing writable " + rawRowString, e);
        }
        try {
            this.forward(row, this.current.rowObjectInspector);
        }
        catch (Exception e) {
            String rowString;
            try {
                rowString = SerDeUtils.getJSONString(row, this.current.rowObjectInspector);
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            throw new HiveException("Hive Runtime Error while processing row " + rowString, e);
        }
    }

    public static Writable[] populateVirtualColumnValues(ExecMapperContext ctx, List<VirtualColumn> vcs, Writable[] vcValues, Deserializer deserializer) {
        if (vcs == null) {
            return vcValues;
        }
        if (vcValues == null) {
            vcValues = new Writable[vcs.size()];
        }
        for (int i = 0; i < vcs.size(); ++i) {
            LongWritable old;
            LongWritable old2;
            long current;
            VirtualColumn vc = vcs.get(i);
            if (vc.equals(VirtualColumn.FILENAME)) {
                if (!ctx.inputFileChanged()) continue;
                vcValues[i] = new Text(ctx.getCurrentInputFile());
                continue;
            }
            if (vc.equals(VirtualColumn.BLOCKOFFSET)) {
                current = ctx.getIoCxt().getCurrentBlockStart();
                old2 = (LongWritable)vcValues[i];
                if (old2 == null) {
                    old2 = new LongWritable(current);
                    vcValues[i] = old2;
                    continue;
                }
                if (current == old2.get()) continue;
                old2.set(current);
                continue;
            }
            if (vc.equals(VirtualColumn.ROWOFFSET)) {
                current = ctx.getIoCxt().getCurrentRow();
                old2 = (LongWritable)vcValues[i];
                if (old2 == null) {
                    old2 = new LongWritable(current);
                    vcValues[i] = old2;
                    continue;
                }
                if (current == old2.get()) continue;
                old2.set(current);
                continue;
            }
            if (!vc.equals(VirtualColumn.RAWDATASIZE)) continue;
            current = 0L;
            SerDeStats stats = deserializer.getSerDeStats();
            if (stats != null) {
                current = stats.getRawDataSize();
            }
            if ((old = (LongWritable)vcValues[i]) == null) {
                old = new LongWritable(current);
                vcValues[i] = old;
                continue;
            }
            if (current == old.get()) continue;
            old.set(current);
        }
        return vcValues;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return MapOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    private static class MapOpCtx {
        StructObjectInspector tblRawRowObjectInspector;
        StructObjectInspector partObjectInspector;
        StructObjectInspector vcsObjectInspector;
        StructObjectInspector rowObjectInspector;
        ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
        Object[] rowWithPart;
        Object[] rowWithPartAndVC;
        Deserializer deserializer;
        String tableName;
        String partName;
        List<VirtualColumn> vcs;
        Writable[] vcValues;

        private MapOpCtx() {
        }

        private boolean isPartitioned() {
            return this.partObjectInspector != null;
        }

        private boolean hasVC() {
            return this.vcsObjectInspector != null;
        }

        private Object readRow(Writable value) throws SerDeException {
            return this.partTblObjectInspectorConverter.convert(this.deserializer.deserialize(value));
        }
    }

    private static class MapInputPath {
        String path;
        String alias;
        Operator<?> op;
        PartitionDesc partDesc;

        public MapInputPath(String path, String alias, Operator<?> op, PartitionDesc partDesc) {
            this.path = path;
            this.alias = alias;
            this.op = op;
            this.partDesc = partDesc;
        }

        public boolean equals(Object o) {
            if (o instanceof MapInputPath) {
                MapInputPath mObj = (MapInputPath)o;
                return this.path.equals(mObj.path) && this.alias.equals(mObj.alias) && this.op.equals(mObj.op);
            }
            return false;
        }

        public int hashCode() {
            int ret = this.path == null ? 0 : this.path.hashCode();
            ret += this.alias == null ? 0 : this.alias.hashCode();
            return ret += this.op == null ? 0 : this.op.hashCode();
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS;

    }
}

