/*
 * Decompiled with CFR 0.152.
 */
package com.google.hive12.hive12.hive12.hive12.common.collect;

import com.google.hive12.hive12.hive12.hive12.common.annotations.GwtCompatible;
import com.google.hive12.hive12.hive12.hive12.common.base.Objects;
import com.google.hive12.hive12.hive12.hive12.common.base.Preconditions;
import com.google.hive12.hive12.hive12.hive12.common.collect.BoundType;
import com.google.hive12.hive12.hive12.hive12.common.collect.Ordering;
import com.google.hive12.hive12.hive12.hive12.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    @Nullable
    private final T lowerEndpoint;
    private final BoundType lowerBoundType;
    private final boolean hasUpperBound;
    @Nullable
    private final T upperEndpoint;
    private final BoundType upperBoundType;
    private transient GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        T lowerEndpoint = range.hasLowerBound() ? (T)range.lowerEndpoint() : null;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        T upperEndpoint = range.hasUpperBound() ? (T)range.upperEndpoint() : null;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<Object>(Ordering.natural(), range.hasLowerBound(), lowerEndpoint, lowerBoundType, range.hasUpperBound(), upperEndpoint, upperBoundType);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<Object>(comparator, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, @Nullable T endpoint, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, true, endpoint, boundType, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, @Nullable T endpoint, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, false, null, BoundType.OPEN, true, endpoint, boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, @Nullable T lower, BoundType lowerType, @Nullable T upper, BoundType upperType) {
        return new GeneralRange<T>(comparator, true, lower, lowerType, true, upper, upperType);
    }

    private GeneralRange(Comparator<? super T> comparator, boolean hasLowerBound, @Nullable T lowerEndpoint, BoundType lowerBoundType, boolean hasUpperBound, @Nullable T upperEndpoint, BoundType upperBoundType) {
        this.comparator = Preconditions.checkNotNull(comparator);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerEndpoint = lowerEndpoint;
        this.lowerBoundType = Preconditions.checkNotNull(lowerBoundType);
        this.upperEndpoint = upperEndpoint;
        this.upperBoundType = Preconditions.checkNotNull(upperBoundType);
        if (hasLowerBound) {
            comparator.compare(lowerEndpoint, lowerEndpoint);
        }
        if (hasUpperBound) {
            comparator.compare(upperEndpoint, upperEndpoint);
        }
        if (hasLowerBound && hasUpperBound) {
            int cmp = comparator.compare(lowerEndpoint, upperEndpoint);
            Preconditions.checkArgument(cmp <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", lowerEndpoint, upperEndpoint);
            if (cmp == 0) {
                Preconditions.checkArgument(lowerBoundType != BoundType.OPEN | upperBoundType != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(this.upperEndpoint) || this.hasLowerBound() && this.tooHigh(this.lowerEndpoint);
    }

    boolean tooLow(@Nullable T t) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T lbound = this.lowerEndpoint;
        int cmp = this.comparator.compare(t, lbound);
        return cmp < 0 | cmp == 0 & this.lowerBoundType == BoundType.OPEN;
    }

    boolean tooHigh(@Nullable T t) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T ubound = this.upperEndpoint;
        int cmp = this.comparator.compare(t, ubound);
        return cmp > 0 | cmp == 0 & this.upperBoundType == BoundType.OPEN;
    }

    boolean contains(@Nullable T t) {
        return !this.tooLow(t) && !this.tooHigh(t);
    }

    GeneralRange<T> intersect(GeneralRange<T> other) {
        int cmp;
        int cmp2;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(((Object)this.comparator).equals(other.comparator));
        boolean hasLowBound = this.hasLowerBound;
        T lowEnd = this.lowerEndpoint;
        BoundType lowType = this.lowerBoundType;
        if (!this.hasLowerBound()) {
            hasLowBound = other.hasLowerBound;
            lowEnd = other.lowerEndpoint;
            lowType = other.lowerBoundType;
        } else if (other.hasLowerBound() && ((cmp2 = this.comparator.compare(this.lowerEndpoint, other.lowerEndpoint)) < 0 || cmp2 == 0 && other.lowerBoundType == BoundType.OPEN)) {
            lowEnd = other.lowerEndpoint;
            lowType = other.lowerBoundType;
        }
        boolean hasUpBound = this.hasUpperBound;
        T upEnd = this.upperEndpoint;
        BoundType upType = this.upperBoundType;
        if (!this.hasUpperBound()) {
            hasUpBound = other.hasUpperBound;
            upEnd = other.upperEndpoint;
            upType = other.upperBoundType;
        } else if (other.hasUpperBound() && ((cmp = this.comparator.compare(this.upperEndpoint, other.upperEndpoint)) > 0 || cmp == 0 && other.upperBoundType == BoundType.OPEN)) {
            upEnd = other.upperEndpoint;
            upType = other.upperBoundType;
        }
        if (hasLowBound && hasUpBound && ((cmp = this.comparator.compare(lowEnd, upEnd)) > 0 || cmp == 0 && lowType == BoundType.OPEN && upType == BoundType.OPEN)) {
            lowEnd = upEnd;
            lowType = BoundType.OPEN;
            upType = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, hasLowBound, lowEnd, lowType, hasUpBound, upEnd, upType);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GeneralRange) {
            GeneralRange r = (GeneralRange)obj;
            return ((Object)this.comparator).equals(r.comparator) && this.hasLowerBound == r.hasLowerBound && this.hasUpperBound == r.hasUpperBound && this.lowerBoundType.equals((Object)r.lowerBoundType) && this.upperBoundType.equals((Object)r.upperBoundType) && Objects.equal(this.lowerEndpoint, r.lowerEndpoint) && Objects.equal(this.upperEndpoint, r.upperEndpoint);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.lowerEndpoint, this.lowerBoundType, this.upperEndpoint, this.upperBoundType});
    }

    public GeneralRange<T> reverse() {
        GeneralRange<Object> result = this.reverse;
        if (result == null) {
            result = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.upperEndpoint, this.upperBoundType, this.hasLowerBound, this.lowerEndpoint, this.lowerBoundType);
            result.reverse = this;
            this.reverse = result;
            return this.reverse;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.comparator).append(":");
        switch (this.lowerBoundType) {
            case CLOSED: {
                builder.append('[');
                break;
            }
            case OPEN: {
                builder.append('(');
            }
        }
        if (this.hasLowerBound()) {
            builder.append(this.lowerEndpoint);
        } else {
            builder.append("-\u221e");
        }
        builder.append(',');
        if (this.hasUpperBound()) {
            builder.append(this.upperEndpoint);
        } else {
            builder.append("\u221e");
        }
        switch (this.upperBoundType) {
            case CLOSED: {
                builder.append(']');
                break;
            }
            case OPEN: {
                builder.append(')');
            }
        }
        return builder.toString();
    }
}

