/*
 * Decompiled with CFR 0.152.
 */
package com.google.hive12.hive12.common.base;

import com.google.hive12.hive12.common.annotations.Beta;
import com.google.hive12.hive12.common.annotations.GwtCompatible;
import com.google.hive12.hive12.common.annotations.GwtIncompatible;
import com.google.hive12.hive12.common.base.Function;
import com.google.hive12.hive12.common.base.Joiner;
import com.google.hive12.hive12.common.base.Objects;
import com.google.hive12.hive12.common.base.Preconditions;
import com.google.hive12.hive12.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(",");

    private Predicates() {
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return new AndPredicate(Predicates.asList(Preconditions.checkNotNull(first), Preconditions.checkNotNull(second)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new OrPredicate(Predicates.asList(Preconditions.checkNotNull(first), Preconditions.checkNotNull(second)));
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    @GwtIncompatible(value="Class.isInstance")
    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    @GwtIncompatible(value="Class.isAssignableFrom")
    @Beta
    public static Predicate<Class<?>> assignableFrom(Class<?> clazz) {
        return new AssignableFromPredicate(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        return new InPredicate(target);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public static Predicate<CharSequence> containsPattern(String pattern) {
        return new ContainsPatternPredicate(pattern);
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new ContainsPatternPredicate(pattern);
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> first, Predicate<? super T> second) {
        return Arrays.asList(first, second);
    }

    private static <T> List<T> defensiveCopy(T ... array) {
        return Predicates.defensiveCopy(Arrays.asList(array));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(Preconditions.checkNotNull(element));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="Only used by other GWT-incompatible code.")
    private static class ContainsPatternPredicate
    implements Predicate<CharSequence>,
    Serializable {
        final Pattern pattern;
        private static final long serialVersionUID = 0L;

        ContainsPatternPredicate(Pattern pattern) {
            this.pattern = Preconditions.checkNotNull(pattern);
        }

        ContainsPatternPredicate(String patternStr) {
            this(Pattern.compile(patternStr));
        }

        @Override
        public boolean apply(CharSequence t) {
            return this.pattern.matcher(t).find();
        }

        public int hashCode() {
            return Objects.hashCode(this.pattern.pattern(), this.pattern.flags());
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ContainsPatternPredicate) {
                ContainsPatternPredicate that = (ContainsPatternPredicate)obj;
                return Objects.equal(this.pattern.pattern(), that.pattern.pattern()) && Objects.equal(this.pattern.flags(), that.pattern.flags());
            }
            return false;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("pattern", this.pattern).add("pattern.flags", Integer.toHexString(this.pattern.flags())).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> p;
        final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        private CompositionPredicate(Predicate<B> p, Function<A, ? extends B> f) {
            this.p = Preconditions.checkNotNull(p);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public boolean apply(A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof CompositionPredicate) {
                CompositionPredicate that = (CompositionPredicate)obj;
                return ((Object)this.f).equals(that.f) && ((Object)this.p).equals(that.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return this.p.toString() + "(" + this.f.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;
        private static final long serialVersionUID = 0L;

        private InPredicate(Collection<?> target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof InPredicate) {
                InPredicate that = (InPredicate)obj;
                return ((Object)this.target).equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.target).hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="Class.isAssignableFrom")
    private static class AssignableFromPredicate
    implements Predicate<Class<?>>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        private AssignableFromPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(Class<?> input) {
            return this.clazz.isAssignableFrom(input);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof AssignableFromPredicate) {
                AssignableFromPredicate that = (AssignableFromPredicate)obj;
                return this.clazz == that.clazz;
            }
            return false;
        }

        public String toString() {
            return "IsAssignableFrom(" + this.clazz.getName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="Class.isInstance")
    private static class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        private InstanceOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@Nullable Object o) {
            return this.clazz.isInstance(o);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == that.clazz;
            }
            return false;
        }

        public String toString() {
            return "IsInstanceOf(" + this.clazz.getName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;
        private static final long serialVersionUID = 0L;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private OrPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.components.get(i).apply(t)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.components).hashCode() + 87855567;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof OrPredicate) {
                OrPredicate that = (OrPredicate)obj;
                return ((Object)this.components).equals(that.components);
            }
            return false;
        }

        public String toString() {
            return "Or(" + COMMA_JOINER.join(this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private AndPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).apply(t)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.components).hashCode() + 306654252;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof AndPredicate) {
                AndPredicate that = (AndPredicate)obj;
                return ((Object)this.components).equals(that.components);
            }
            return false;
        }

        public String toString() {
            return "And(" + COMMA_JOINER.join(this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof NotPredicate) {
                NotPredicate that = (NotPredicate)obj;
                return ((Object)this.predicate).equals(that.predicate);
            }
            return false;
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            public boolean apply(@Nullable Object o) {
                return true;
            }
        }
        ,
        ALWAYS_FALSE{

            public boolean apply(@Nullable Object o) {
                return false;
            }
        }
        ,
        IS_NULL{

            public boolean apply(@Nullable Object o) {
                return o == null;
            }
        }
        ,
        NOT_NULL{

            public boolean apply(@Nullable Object o) {
                return o != null;
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }
}

