/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.hbase.config.HBasePStore;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.PStoreRegistry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBasePStoreProvider
implements PStoreProvider {
    static final Logger logger = LoggerFactory.getLogger(HBasePStoreProvider.class);
    static final byte[] FAMILY = Bytes.toBytes((String)"s");
    static final byte[] QUALIFIER = Bytes.toBytes((String)"d");
    private final String storeTableName;
    private Configuration hbaseConf;
    private HConnection connection;
    private HTableInterface table;

    public HBasePStoreProvider(PStoreRegistry registry) {
        Map config = (Map)registry.getConfig().getAnyRef("drill.exec.sys.store.provider.hbase.config");
        this.hbaseConf = HBaseConfiguration.create();
        this.hbaseConf.set(HConstants.HBASE_CLIENT_INSTANCE_ID, "drill-hbase-persistent-store-client");
        if (config != null) {
            for (Map.Entry entry : config.entrySet()) {
                this.hbaseConf.set((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        this.storeTableName = registry.getConfig().getString("drill.exec.sys.store.provider.hbase.table");
    }

    @VisibleForTesting
    public HBasePStoreProvider(Configuration conf, String storeTableName) {
        this.hbaseConf = conf;
        this.storeTableName = storeTableName;
    }

    public <V> PStore<V> getPStore(PStoreConfig<V> store) throws IOException {
        return new HBasePStore<V>(store, this.table);
    }

    public void start() throws IOException {
        this.connection = HConnectionManager.createConnection((Configuration)this.hbaseConf);
        try (HBaseAdmin admin = new HBaseAdmin(this.connection);){
            HTableDescriptor desc;
            if (!admin.tableExists(this.storeTableName)) {
                desc = new HTableDescriptor(this.storeTableName);
                desc.addFamily(new HColumnDescriptor(FAMILY).setMaxVersions(1));
                admin.createTable(desc);
            } else {
                desc = admin.getTableDescriptor(Bytes.toBytes((String)this.storeTableName));
                if (!desc.hasFamily(FAMILY)) {
                    throw new DrillRuntimeException("The HBase table " + this.storeTableName + " specified as persistent store exists but does not contain column family: " + Bytes.toString((byte[])FAMILY));
                }
            }
        }
        this.table = this.connection.getTable(this.storeTableName);
        this.table.setAutoFlush(true);
    }

    public synchronized void close() {
        if (this.table != null) {
            try {
                this.table.close();
                this.table = null;
            }
            catch (IOException e) {
                logger.warn("Caught exception while closing HBase table.", (Throwable)e);
            }
        }
        if (this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                logger.warn("Caught exception while closing HBase connection.", (Throwable)e);
            }
            this.connection = null;
        }
    }
}

