/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.hadoop.hbase.client.HTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStatsCalculator {
    static final Logger logger = LoggerFactory.getLogger(TableStatsCalculator.class);
    private static final String DRILL_EXEC_HBASE_SCAN_SAMPLE_ROWS_COUNT = "drill.exec.hbase.scan.samplerows.count";
    private static final String DRILL_EXEC_HBASE_SCAN_SIZECALCULATOR_ENABLED = "drill.exec.hbase.scan.sizecalculator.enabled";
    private static final int DEFAULT_SAMPLE_SIZE = 100;
    private Map<byte[], Long> sizeMap;
    private int avgRowSizeInBytes;
    private int colsPerRow;

    /*
     * Exception decompiling
     */
    public TableStatsCalculator(HTable table, HBaseScanSpec hbaseScanSpec, DrillConfig config) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean enabled(DrillConfig config) {
        return config.hasPath(DRILL_EXEC_HBASE_SCAN_SIZECALCULATOR_ENABLED) ? config.getBoolean(DRILL_EXEC_HBASE_SCAN_SIZECALCULATOR_ENABLED) : true;
    }

    private int rowsToSample(DrillConfig config) {
        return config.hasPath(DRILL_EXEC_HBASE_SCAN_SAMPLE_ROWS_COUNT) ? config.getInt(DRILL_EXEC_HBASE_SCAN_SAMPLE_ROWS_COUNT) : 100;
    }

    public long getRegionSizeInBytes(byte[] regionId) {
        if (this.sizeMap == null) {
            return this.avgRowSizeInBytes * 1024 * 1024;
        }
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            logger.debug("Unknown region:" + Arrays.toString(regionId));
            return 0L;
        }
        return size;
    }

    public int getAvgRowSizeInBytes() {
        return this.avgRowSizeInBytes;
    }

    public int getColsPerRow() {
        return this.colsPerRow;
    }
}

