/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseUtils {
    static final ParseFilter FILTER_PARSEER = new ParseFilter();
    static final int FIRST_FILTER = 0;
    static final int LAST_FILTER = -1;

    public static byte[] getBytes(String str) {
        return str == null ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)str);
    }

    static Filter parseFilterString(String filterString) {
        if (filterString == null) {
            return null;
        }
        try {
            return FILTER_PARSEER.parseFilterString(filterString);
        }
        catch (CharacterCodingException e) {
            throw new DrillRuntimeException("Error parsing filter string: " + filterString, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeFilter(Filter filter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Filter deserializeFilter(byte[] filterBytes) {
        if (filterBytes == null) {
            return null;
        }
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(filterBytes));){
            Filter filter = (Filter)HbaseObjectWritable.readObject((DataInput)dis, null);
            return filter;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Error deserializing filter: " + filterBytes, (Throwable)e);
        }
    }

    public static Filter andFilterAtIndex(Filter currentFilter, int index, Filter newFilter) {
        if (currentFilter == null) {
            return newFilter;
        }
        if (newFilter == null) {
            return currentFilter;
        }
        ArrayList allFilters = Lists.newArrayList();
        if (currentFilter instanceof FilterList && ((FilterList)currentFilter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            allFilters.addAll(((FilterList)currentFilter).getFilters());
        } else {
            allFilters.add(currentFilter);
        }
        allFilters.add(index == -1 ? allFilters.size() : index, newFilter);
        return new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)allFilters);
    }

    public static Filter orFilterAtIndex(Filter currentFilter, int index, Filter newFilter) {
        if (currentFilter == null) {
            return newFilter;
        }
        if (newFilter == null) {
            return currentFilter;
        }
        ArrayList allFilters = Lists.newArrayList();
        if (currentFilter instanceof FilterList && ((FilterList)currentFilter).getOperator() == FilterList.Operator.MUST_PASS_ONE) {
            allFilters.addAll(((FilterList)currentFilter).getFilters());
        } else {
            allFilters.add(currentFilter);
        }
        allFilters.add(index == -1 ? allFilters.size() : index, newFilter);
        return new FilterList(FilterList.Operator.MUST_PASS_ONE, (List)allFilters);
    }

    public static byte[] maxOfStartRows(byte[] left, byte[] right) {
        if (left == null || left.length == 0 || right == null || right.length == 0) {
            return left == null || left.length == 0 ? right : left;
        }
        return Bytes.compareTo((byte[])left, (byte[])right) > 0 ? left : right;
    }

    public static byte[] minOfStartRows(byte[] left, byte[] right) {
        if (left == null || left.length == 0 || right == null || right.length == 0) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        return Bytes.compareTo((byte[])left, (byte[])right) < 0 ? left : right;
    }

    public static byte[] maxOfStopRows(byte[] left, byte[] right) {
        if (left == null || left.length == 0 || right == null || right.length == 0) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        return Bytes.compareTo((byte[])left, (byte[])right) > 0 ? left : right;
    }

    public static byte[] minOfStopRows(byte[] left, byte[] right) {
        if (left == null || left.length == 0 || right == null || right.length == 0) {
            return left == null || left.length == 0 ? right : left;
        }
        return Bytes.compareTo((byte[])left, (byte[])right) < 0 ? left : right;
    }
}

