/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hbase.HBaseGroupScan;
import org.apache.drill.exec.store.hbase.HBasePushFilterIntoScan;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.exec.store.hbase.HBaseSchemaFactory;
import org.apache.drill.exec.store.hbase.HBaseStoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(HBaseStoragePlugin.class);
    private final DrillbitContext context;
    private final HBaseStoragePluginConfig engineConfig;
    private final HBaseSchemaFactory schemaFactory;
    private final String name;

    public HBaseStoragePlugin(HBaseStoragePluginConfig configuration, DrillbitContext context, String name) throws IOException {
        this.context = context;
        this.schemaFactory = new HBaseSchemaFactory(this, name);
        this.engineConfig = configuration;
        this.name = name;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public boolean supportsRead() {
        return true;
    }

    public HBaseGroupScan getPhysicalScan(JSONOptions selection) throws IOException {
        HBaseScanSpec scanSpec = (HBaseScanSpec)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<HBaseScanSpec>(){});
        return new HBaseGroupScan(this, scanSpec, null);
    }

    public void registerSchemas(UserSession session, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(session, parent);
    }

    public HBaseStoragePluginConfig getConfig() {
        return this.engineConfig;
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules() {
        return ImmutableSet.of((Object)HBasePushFilterIntoScan.INSTANCE);
    }
}

