/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.hbase.DrillHBaseTable;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.exec.store.hbase.HBaseStoragePlugin;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSchemaFactory
implements SchemaFactory {
    static final Logger logger = LoggerFactory.getLogger(HBaseSchemaFactory.class);
    final String schemaName;
    final HBaseStoragePlugin plugin;

    public HBaseSchemaFactory(HBaseStoragePlugin plugin, String name) throws IOException {
        this.plugin = plugin;
        this.schemaName = name;
    }

    public void registerSchemas(UserSession session, SchemaPlus parent) {
        HBaseSchema schema = new HBaseSchema(this.schemaName);
        SchemaPlus hPlus = parent.add(this.schemaName, (Schema)schema);
        schema.setHolder(hPlus);
    }

    class HBaseSchema
    extends AbstractSchema {
        public HBaseSchema(String name) {
            super((List)ImmutableList.of(), name);
        }

        public void setHolder(SchemaPlus plusOfThis) {
        }

        public Schema getSubSchema(String name) {
            return null;
        }

        public Set<String> getSubSchemaNames() {
            return Collections.emptySet();
        }

        public Table getTable(String name) {
            HBaseScanSpec scanSpec = new HBaseScanSpec(name);
            return new DrillHBaseTable(HBaseSchemaFactory.this.schemaName, HBaseSchemaFactory.this.plugin, scanSpec);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set<String> getTableNames() {
            try (HBaseAdmin admin = new HBaseAdmin(HBaseSchemaFactory.this.plugin.getConfig().getHBaseConf());){
                HTableDescriptor[] tables = admin.listTables();
                HashSet tableNames = Sets.newHashSet();
                for (HTableDescriptor table : tables) {
                    tableNames.add(new String(table.getName()));
                }
                HashSet hashSet = tableNames;
                return hashSet;
            }
            catch (Exception e) {
                logger.warn("Failure while loading table names for database '{}'.", (Object)HBaseSchemaFactory.this.schemaName, (Object)e.getCause());
                return Collections.emptySet();
            }
        }

        public String getTypeName() {
            return "hbase";
        }
    }
}

