/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.hbase.HBaseRecordReader;
import org.apache.drill.exec.store.hbase.HBaseSubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseScanBatchCreator
implements BatchCreator<HBaseSubScan> {
    static final Logger logger = LoggerFactory.getLogger(HBaseScanBatchCreator.class);

    public RecordBatch getBatch(FragmentContext context, HBaseSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        ArrayList readers = Lists.newArrayList();
        List columns = null;
        for (HBaseSubScan.HBaseSubScanSpec scanSpec : subScan.getRegionScanSpecList()) {
            try {
                columns = subScan.getColumns();
                if (columns == null) {
                    columns = GroupScan.ALL_COLUMNS;
                }
                readers.add(new HBaseRecordReader(subScan.getStorageConfig().getHBaseConf(), scanSpec, columns, context));
            }
            catch (Exception e1) {
                throw new ExecutionSetupException((Throwable)e1);
            }
        }
        return new ScanBatch((PhysicalOperator)subScan, context, readers.iterator());
    }
}

