/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hbase.DrillHBaseConstants;
import org.apache.drill.exec.store.hbase.HBaseSubScan;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRecordReader
extends AbstractRecordReader
implements DrillHBaseConstants {
    private static final Logger logger = LoggerFactory.getLogger(HBaseRecordReader.class);
    private static final int TARGET_RECORD_COUNT = 4000;
    private OutputMutator outputMutator;
    private Map<String, MapVector> familyVectorMap;
    private VarBinaryVector rowKeyVector;
    private HTable hTable;
    private ResultScanner resultScanner;
    private String hbaseTableName;
    private Scan hbaseScan;
    private Configuration hbaseConf;
    private Result leftOver;
    private FragmentContext fragmentContext;
    private OperatorContext operatorContext;

    public HBaseRecordReader(Configuration conf, HBaseSubScan.HBaseSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, FragmentContext context) throws OutOfMemoryException {
        this.hbaseConf = conf;
        this.hbaseTableName = ((HBaseSubScan.HBaseSubScanSpec)Preconditions.checkNotNull((Object)subScanSpec, (Object)"HBase reader needs a sub-scan spec")).getTableName();
        this.hbaseScan = new Scan(subScanSpec.getStartRow(), subScanSpec.getStopRow());
        this.hbaseScan.setFilter(subScanSpec.getScanFilter()).setCaching(4000);
        this.setColumns(projectedColumns);
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> columns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (!this.isStarQuery()) {
            boolean rowKeyOnly = true;
            for (SchemaPath column : columns) {
                if (column.getRootSegment().getPath().equalsIgnoreCase("row_key")) {
                    transformed.add(ROW_KEY_PATH);
                    continue;
                }
                rowKeyOnly = false;
                PathSegment.NameSegment root = column.getRootSegment();
                byte[] family = root.getPath().getBytes();
                transformed.add(SchemaPath.getSimplePath((String)root.getPath()));
                PathSegment child = root.getChild();
                if (child != null && child.isNamed()) {
                    byte[] qualifier = child.getNameSegment().getPath().getBytes();
                    this.hbaseScan.addColumn(family, qualifier);
                    continue;
                }
                this.hbaseScan.addFamily(family);
            }
            if (rowKeyOnly) {
                this.hbaseScan.setFilter(HBaseUtils.andFilterAtIndex(this.hbaseScan.getFilter(), -1, (Filter)new FirstKeyOnlyFilter()));
            }
        } else {
            transformed.add(ROW_KEY_PATH);
        }
        return transformed;
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public void setOperatorContext(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    public void setup(OutputMutator output) throws ExecutionSetupException {
        this.outputMutator = output;
        this.familyVectorMap = new HashMap<String, MapVector>();
        try {
            for (SchemaPath column : this.getColumns()) {
                if (column.equals((Object)ROW_KEY_PATH)) {
                    MaterializedField field = MaterializedField.create((SchemaPath)column, (TypeProtos.MajorType)ROW_KEY_TYPE);
                    this.rowKeyVector = (VarBinaryVector)this.outputMutator.addField(field, VarBinaryVector.class);
                    continue;
                }
                this.getOrCreateFamilyVector(column.getRootSegment().getPath(), false);
            }
            logger.debug("Opening scanner for HBase table '{}', Zookeeper quorum '{}', port '{}', znode '{}'.", new Object[]{this.hbaseTableName, this.hbaseConf.get("hbase.zookeeper.quorum"), this.hbaseConf.get("hbase.zookeeper.property.clientPort"), this.hbaseConf.get("zookeeper.znode.parent")});
            this.hTable = new HTable(this.hbaseConf, this.hbaseTableName);
            this.resultScanner = this.hTable.getScanner(this.hbaseScan);
        }
        catch (IOException | SchemaChangeException e) {
            throw new ExecutionSetupException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int next() {
        int rowCount;
        Stopwatch watch = new Stopwatch();
        watch.start();
        if (this.rowKeyVector != null) {
            this.rowKeyVector.clear();
            this.rowKeyVector.allocateNew();
        }
        for (ValueVector valueVector : this.familyVectorMap.values()) {
            valueVector.clear();
            valueVector.allocateNew();
        }
        block3: for (rowCount = 0; rowCount < 4000; ++rowCount) {
            void var3_9;
            Object var3_6 = null;
            try {
                if (this.leftOver != null) {
                    Result result = this.leftOver;
                    this.leftOver = null;
                } else {
                    Result result = this.resultScanner.next();
                }
            }
            catch (IOException e) {
                throw new DrillRuntimeException((Throwable)e);
            }
            if (var3_9 == null) break;
            KeyValue[] kvs = var3_9.raw();
            byte[] bytes = var3_9.getBytes().get();
            if (this.rowKeyVector != null && !this.rowKeyVector.getMutator().setSafe(rowCount, bytes, kvs[0].getRowOffset(), (int)kvs[0].getRowLength())) {
                this.leftOver = var3_9;
                break;
            }
            for (KeyValue kv : kvs) {
                int familyOffset = kv.getFamilyOffset();
                byte familyLength = kv.getFamilyLength();
                MapVector mv = this.getOrCreateFamilyVector(new String(bytes, familyOffset, (int)familyLength), true);
                int qualifierOffset = kv.getQualifierOffset();
                int qualifierLength = kv.getQualifierLength();
                NullableVarBinaryVector v = this.getOrCreateColumnVector(mv, new String(bytes, qualifierOffset, qualifierLength));
                int valueOffset = kv.getValueOffset();
                int valueLength = kv.getValueLength();
                if (v.getMutator().setSafe(rowCount, bytes, valueOffset, valueLength)) continue;
                this.leftOver = var3_9;
                break block3;
            }
        }
        this.setOutputRowCount(rowCount);
        logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)rowCount);
        return rowCount;
    }

    private MapVector getOrCreateFamilyVector(String familyName, boolean allocateOnCreate) {
        try {
            MapVector v = this.familyVectorMap.get(familyName);
            if (v == null) {
                SchemaPath column = SchemaPath.getSimplePath((String)familyName);
                MaterializedField field = MaterializedField.create((SchemaPath)column, (TypeProtos.MajorType)COLUMN_FAMILY_TYPE);
                v = (MapVector)this.outputMutator.addField(field, MapVector.class);
                if (allocateOnCreate) {
                    v.allocateNew();
                }
                this.getColumns().add(column);
                this.familyVectorMap.put(familyName, v);
            }
            return v;
        }
        catch (SchemaChangeException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    private NullableVarBinaryVector getOrCreateColumnVector(MapVector mv, String qualifier) {
        int oldSize = mv.size();
        NullableVarBinaryVector v = (NullableVarBinaryVector)mv.addOrGet(qualifier, COLUMN_TYPE, NullableVarBinaryVector.class);
        if (oldSize != mv.size()) {
            v.allocateNew();
        }
        return v;
    }

    public void cleanup() {
        try {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
            if (this.hTable != null) {
                this.hTable.close();
            }
        }
        catch (IOException e) {
            logger.warn("Failure while closing HBase table: " + this.hbaseTableName, (Throwable)e);
        }
    }

    private void setOutputRowCount(int count) {
        for (ValueVector valueVector : this.familyVectorMap.values()) {
            valueVector.getMutator().setValueCount(count);
        }
        if (this.rowKeyVector != null) {
            this.rowKeyVector.getMutator().setValueCount(count);
        }
    }
}

