/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hbase.HBaseFilterBuilder;
import org.apache.drill.exec.store.hbase.HBaseGroupScan;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

public class HBasePushFilterIntoScan
extends StoragePluginOptimizerRule {
    public static final StoragePluginOptimizerRule INSTANCE = new HBasePushFilterIntoScan();

    private HBasePushFilterIntoScan() {
        super(RelOptHelper.some(FilterPrel.class, (RelOptRuleOperand)RelOptHelper.any(ScanPrel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HBasePushFilterIntoScan");
    }

    public void onMatch(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        FilterPrel filter = (FilterPrel)call.rel(0);
        RexNode condition = filter.getCondition();
        HBaseGroupScan groupScan = (HBaseGroupScan)scan.getGroupScan();
        if (groupScan.isFilterPushedDown()) {
            return;
        }
        LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(), (RelNode)scan, (RexNode)condition);
        HBaseFilterBuilder hbaseFilterBuilder = new HBaseFilterBuilder(groupScan, conditionExp);
        HBaseScanSpec newScanSpec = hbaseFilterBuilder.parseTree();
        if (newScanSpec == null) {
            return;
        }
        HBaseGroupScan newGroupsScan = new HBaseGroupScan(groupScan.getStoragePlugin(), newScanSpec, groupScan.getColumns());
        newGroupsScan.setFilterPushedDown(true);
        ScanPrel newScanPrel = ScanPrel.create((RelNode)scan, (RelTraitSet)filter.getTraitSet(), (GroupScan)newGroupsScan, (RelDataType)scan.getRowType());
        if (hbaseFilterBuilder.isAllExpressionsConverted()) {
            call.transformTo((RelNode)newScanPrel);
        } else {
            call.transformTo(filter.copy(filter.getTraitSet(), (List)ImmutableList.of((Object)newScanPrel)));
        }
    }

    public boolean matches(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        if (scan.getGroupScan() instanceof HBaseGroupScan) {
            return super.matches(call);
        }
        return false;
    }
}

