/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.hbase.CompareFunctionsProcessor;
import org.apache.drill.exec.store.hbase.DrillHBaseConstants;
import org.apache.drill.exec.store.hbase.HBaseGroupScan;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class HBaseFilterBuilder
extends AbstractExprVisitor<HBaseScanSpec, Void, RuntimeException>
implements DrillHBaseConstants {
    private final HBaseGroupScan groupScan;
    private final LogicalExpression le;
    private boolean allExpressionsConverted = true;

    HBaseFilterBuilder(HBaseGroupScan groupScan, LogicalExpression le) {
        this.groupScan = groupScan;
        this.le = le;
    }

    public HBaseScanSpec parseTree() {
        HBaseScanSpec parsedSpec = (HBaseScanSpec)this.le.accept((ExprVisitor)this, null);
        if (parsedSpec != null) {
            parsedSpec = this.mergeScanSpecs("booleanAnd", this.groupScan.getHBaseScanSpec(), parsedSpec);
            if (parsedSpec.filter instanceof RowFilter) {
                parsedSpec.filter = null;
            }
        }
        return parsedSpec;
    }

    public boolean isAllExpressionsConverted() {
        return this.allExpressionsConverted;
    }

    public HBaseScanSpec visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        this.allExpressionsConverted = false;
        return null;
    }

    public HBaseScanSpec visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        HBaseScanSpec nodeScanSpec = null;
        String functionName = call.getName();
        ImmutableList args = call.args;
        if (CompareFunctionsProcessor.isCompareFunction(functionName)) {
            boolean nullComparatorSupported = this.groupScan.getHBaseConf().getBoolean("drill.hbase.supports.null.comparator", false);
            CompareFunctionsProcessor processor = CompareFunctionsProcessor.process(call, nullComparatorSupported);
            if (processor.isSuccess()) {
                nodeScanSpec = this.createHBaseScanSpec(processor.getFunctionName(), processor.getPath(), processor.getValue());
            }
        } else {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    HBaseScanSpec leftScanSpec = (HBaseScanSpec)((LogicalExpression)args.get(0)).accept((ExprVisitor)this, null);
                    HBaseScanSpec rightScanSpec = (HBaseScanSpec)((LogicalExpression)args.get(1)).accept((ExprVisitor)this, null);
                    if (leftScanSpec != null && rightScanSpec != null) {
                        nodeScanSpec = this.mergeScanSpecs(functionName, leftScanSpec, rightScanSpec);
                        break;
                    }
                    this.allExpressionsConverted = false;
                    if (!"booleanAnd".equals(functionName)) break;
                    HBaseScanSpec hBaseScanSpec = nodeScanSpec = leftScanSpec == null ? rightScanSpec : leftScanSpec;
                }
            }
        }
        if (nodeScanSpec == null) {
            this.allExpressionsConverted = false;
        }
        return nodeScanSpec;
    }

    private HBaseScanSpec mergeScanSpecs(String functionName, HBaseScanSpec leftScanSpec, HBaseScanSpec rightScanSpec) {
        Filter newFilter = null;
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        switch (functionName) {
            case "booleanAnd": {
                newFilter = HBaseUtils.andFilterAtIndex(leftScanSpec.filter, -1, rightScanSpec.filter);
                startRow = HBaseUtils.maxOfStartRows(leftScanSpec.startRow, rightScanSpec.startRow);
                stopRow = HBaseUtils.minOfStopRows(leftScanSpec.stopRow, rightScanSpec.stopRow);
                break;
            }
            case "booleanOr": {
                newFilter = HBaseUtils.orFilterAtIndex(leftScanSpec.filter, -1, rightScanSpec.filter);
                startRow = HBaseUtils.minOfStartRows(leftScanSpec.startRow, rightScanSpec.startRow);
                stopRow = HBaseUtils.maxOfStopRows(leftScanSpec.stopRow, rightScanSpec.stopRow);
            }
        }
        return new HBaseScanSpec(this.groupScan.getTableName(), startRow, stopRow, newFilter);
    }

    private HBaseScanSpec createHBaseScanSpec(String functionName, SchemaPath field, byte[] fieldValue) {
        boolean isRowKey = field.getAsUnescapedPath().equals("row_key");
        if (!(isRowKey || field.getRootSegment().getChild() != null && field.getRootSegment().getChild().isNamed())) {
            return null;
        }
        CompareFilter.CompareOp compareOp = null;
        boolean isNullTest = false;
        BinaryComparator comparator = new BinaryComparator(fieldValue);
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        switch (functionName) {
            case "equal": {
                compareOp = CompareFilter.CompareOp.EQUAL;
                if (!isRowKey) break;
                stopRow = fieldValue;
                startRow = fieldValue;
                break;
            }
            case "not_equal": {
                compareOp = CompareFilter.CompareOp.NOT_EQUAL;
                break;
            }
            case "greater_than_or_equal_to": {
                compareOp = CompareFilter.CompareOp.GREATER_OR_EQUAL;
                if (!isRowKey) break;
                startRow = fieldValue;
                break;
            }
            case "greater_than": {
                compareOp = CompareFilter.CompareOp.GREATER;
                if (!isRowKey) break;
                startRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case "less_than_or_equal_to": {
                compareOp = CompareFilter.CompareOp.LESS_OR_EQUAL;
                if (!isRowKey) break;
                stopRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case "less_than": {
                compareOp = CompareFilter.CompareOp.LESS;
                if (!isRowKey) break;
                stopRow = fieldValue;
                break;
            }
            case "isnull": 
            case "isNull": 
            case "is null": {
                if (isRowKey) {
                    return null;
                }
                isNullTest = true;
                compareOp = CompareFilter.CompareOp.EQUAL;
                comparator = new NullComparator();
                break;
            }
            case "isnotnull": 
            case "isNotNull": 
            case "is not null": {
                if (isRowKey) {
                    return null;
                }
                compareOp = CompareFilter.CompareOp.NOT_EQUAL;
                comparator = new NullComparator();
            }
        }
        if (compareOp != null || startRow != HConstants.EMPTY_START_ROW || stopRow != HConstants.EMPTY_END_ROW) {
            RowFilter filter = null;
            if (isRowKey) {
                if (compareOp != null) {
                    filter = new RowFilter(compareOp, (WritableByteArrayComparable)comparator);
                }
            } else {
                byte[] family = HBaseUtils.getBytes(field.getRootSegment().getPath());
                byte[] qualifier = HBaseUtils.getBytes(field.getRootSegment().getChild().getNameSegment().getPath());
                filter = new SingleColumnValueFilter(family, qualifier, compareOp, (WritableByteArrayComparable)comparator);
                ((SingleColumnValueFilter)filter).setLatestVersionOnly(true);
                if (!isNullTest) {
                    ((SingleColumnValueFilter)filter).setFilterIfMissing(true);
                }
            }
            return new HBaseScanSpec(this.groupScan.getTableName(), startRow, stopRow, (Filter)filter);
        }
        return null;
    }
}

