/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.vocabulary.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.phenotips.vocabulary.Vocabulary;
import org.phenotips.vocabulary.VocabularyTerm;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Named(value="hgncRemote")
@Singleton
public class RemoteGeneNomenclature
implements Vocabulary,
Initializable {
    private static final VocabularyTerm EMPTY_MARKER = new JSONOntologyTerm(null, null);
    private static final String RESPONSE_KEY = "response";
    private static final String DATA_KEY = "docs";
    private static final String LABEL_KEY = "symbol";
    private static final String WILDCARD = "*";
    private static final String DEFAULT_OPERATOR = "AND";
    private static final Map<String, String> QUERY_OPERATORS = new HashMap<String, String>();
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    private String baseServiceURL;
    private String searchServiceURL;
    private String infoServiceURL;
    private String fetchServiceURL;
    private final CloseableHttpClient client = HttpClients.createSystem();
    @Inject
    private Logger logger;
    private Cache<VocabularyTerm> cache;
    private Cache<JSONObject> infoCache;
    @Inject
    private CacheManager cacheFactory;

    public void initialize() throws InitializationException {
        try {
            this.baseServiceURL = (String)this.configuration.getProperty("phenotips.ontologies.hgnc.serviceURL", (Object)"http://rest.genenames.org/");
            this.searchServiceURL = this.baseServiceURL + "search/";
            this.infoServiceURL = this.baseServiceURL + "info";
            this.fetchServiceURL = this.baseServiceURL + "fetch/";
            this.cache = this.cacheFactory.createNewLocalCache(new CacheConfiguration());
            LRUEvictionConfiguration infoConfig = new LRUEvictionConfiguration(1);
            infoConfig.setTimeToLive(300);
            this.infoCache = this.cacheFactory.createNewLocalCache(new CacheConfiguration((EntryEvictionConfiguration)infoConfig));
        }
        catch (CacheException ex) {
            throw new InitializationException("Cannot create cache: " + ex.getMessage());
        }
        QUERY_OPERATORS.put("OR", "");
        QUERY_OPERATORS.put(DEFAULT_OPERATOR, "AND ");
        QUERY_OPERATORS.put("NOT", "-");
    }

    public VocabularyTerm getTerm(String id) {
        VocabularyTerm result = (VocabularyTerm)this.cache.get(id);
        if (result == null) {
            String safeID;
            try {
                safeID = URLEncoder.encode(id, Consts.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                safeID = id.replaceAll("\\s", "");
                this.logger.warn("Could not find the encoding: {}", (Object)Consts.UTF_8.name());
            }
            HttpGet method = new HttpGet(this.fetchServiceURL + "symbol/" + safeID);
            method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);){
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                JSONArray docs = responseJSON.getJSONObject(RESPONSE_KEY).getJSONArray(DATA_KEY);
                if (docs.size() == 1) {
                    result = new JSONOntologyTerm(docs.getJSONObject(0), this);
                    this.cache.set(id, (Object)result);
                } else {
                    this.cache.set(id, (Object)EMPTY_MARKER);
                }
            }
            catch (IOException | JSONException ex) {
                this.logger.warn("Failed to fetch gene definition: {}", (Object)ex.getMessage());
            }
        }
        return result == EMPTY_MARKER ? null : result;
    }

    public Set<VocabularyTerm> getTerms(Collection<String> ids) {
        LinkedHashSet<VocabularyTerm> result = new LinkedHashSet<VocabularyTerm>();
        for (String id : ids) {
            VocabularyTerm term = this.getTerm(id);
            if (term == null) continue;
            result.add(term);
        }
        return result;
    }

    public List<VocabularyTerm> search(Map<String, ?> fieldValues) {
        return this.search(fieldValues, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<VocabularyTerm> search(Map<String, ?> fieldValues, Map<String, String> queryOptions) {
        try {
            HttpGet method = new HttpGet(this.searchServiceURL + URLEncoder.encode(this.generateQuery(fieldValues), Consts.UTF_8.name()));
            method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);){
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                JSONArray docs = responseJSON.getJSONObject(RESPONSE_KEY).getJSONArray(DATA_KEY);
                if (docs.size() < 1) return Collections.emptyList();
                LinkedList<VocabularyTerm> result = new LinkedList<VocabularyTerm>();
                int start = 0;
                if (queryOptions.containsKey("start") && StringUtils.isNumeric((CharSequence)queryOptions.get("start"))) {
                    start = Math.max(0, Integer.parseInt(queryOptions.get("start")));
                }
                int end = docs.size();
                if (queryOptions.containsKey("rows") && StringUtils.isNumeric((CharSequence)queryOptions.get("rows"))) {
                    end = Math.min(end, start + Integer.parseInt(queryOptions.get("rows")));
                }
                for (int i = start; i < end; ++i) {
                    result.add(new JSONOntologyTerm(docs.getJSONObject(i), this));
                }
                LinkedList<VocabularyTerm> linkedList = result;
                return linkedList;
            }
            catch (IOException | JSONException ex) {
                this.logger.warn("Failed to search gene names: {}", (Object)ex.getMessage());
                return Collections.emptyList();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public List<VocabularyTerm> search(String input, int maxResults, String sort, String customFilter) {
        String formattedQuery = String.format("%s*", input);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        HashMap<String, String> rowsMap = new HashMap<String, String>();
        queryMap.put(LABEL_KEY, formattedQuery);
        queryMap.put("alias_symbol", formattedQuery);
        queryMap.put("prev_symbol", formattedQuery);
        fieldValues.put("status", "Approved");
        fieldValues.put(DEFAULT_OPERATOR, queryMap);
        rowsMap.put("rows", Integer.toString(maxResults));
        return this.search(fieldValues, rowsMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long count(Map<String, ?> fieldValues) {
        try {
            HttpGet method = new HttpGet(this.searchServiceURL + URLEncoder.encode(this.generateQuery(fieldValues), Consts.UTF_8.name()));
            method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);){
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                JSONArray docs = responseJSON.getJSONObject(RESPONSE_KEY).getJSONArray(DATA_KEY);
                long l = docs.size();
                return l;
            }
            catch (IOException | JSONException ex) {
                this.logger.warn("Failed to count matching gene names: {}", (Object)ex.getMessage());
                return -1L;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return -1L;
    }

    public long getDistance(String fromTermId, String toTermId) {
        return -1L;
    }

    public long getDistance(VocabularyTerm fromTerm, VocabularyTerm toTerm) {
        return -1L;
    }

    public Set<String> getAliases() {
        HashSet<String> result = new HashSet<String>();
        result.add("hgnc-remote");
        result.add("HGNC");
        return result;
    }

    public long size() {
        JSONObject info = this.getInfo();
        return info.isNullObject() ? -1L : info.getLong("numDoc");
    }

    public int reindex(String ontologyUrl) {
        this.cache.removeAll();
        return 0;
    }

    public String getDefaultSourceLocation() {
        return this.baseServiceURL;
    }

    public String getVersion() {
        JSONObject info = this.getInfo();
        return info.isNullObject() ? "" : info.getString("lastModified");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getInfo() {
        JSONObject info = (JSONObject)this.infoCache.get("");
        if (info != null) {
            return info;
        }
        HttpGet method = new HttpGet(this.infoServiceURL);
        method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);){
            String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
            JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
            this.infoCache.set("", (Object)responseJSON);
            JSONObject jSONObject = responseJSON;
            return jSONObject;
        }
        catch (IOException | JSONException ex) {
            this.logger.warn("Failed to get HGNC information: {}", (Object)ex.getMessage());
            return new JSONObject(true);
        }
    }

    private String generateQuery(Map<String, ?> fieldValues) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, ?> field : fieldValues.entrySet()) {
            this.processQueryPart(query, field, true);
        }
        return StringUtils.removeStart((String)query.toString().trim(), (String)DEFAULT_OPERATOR);
    }

    private StringBuilder processQueryPart(StringBuilder query, Map.Entry<String, ?> field, boolean includeOperator) {
        if (Collection.class.isInstance(field.getValue()) && ((Collection)field.getValue()).isEmpty()) {
            return query;
        }
        if (Map.class.isInstance(field.getValue())) {
            if (QUERY_OPERATORS.containsKey(field.getKey())) {
                Map.Entry<String, Map<String, ?>> subquery = field;
                return this.processSubquery(query, subquery);
            }
            this.logger.warn("Invalid subquery operator: {}", (Object)field.getKey());
            return query;
        }
        query.append(' ');
        if (includeOperator) {
            query.append(QUERY_OPERATORS.get(DEFAULT_OPERATOR));
        }
        query.append(ClientUtils.escapeQueryChars((String)field.getKey()));
        query.append(":(");
        if (Collection.class.isInstance(field.getValue())) {
            for (Object value : (Collection)((Object)field.getValue())) {
                String svalue = String.valueOf(value);
                svalue = svalue.endsWith(WILDCARD) ? ClientUtils.escapeQueryChars((String)StringUtils.removeEnd((String)svalue, (String)WILDCARD)) + WILDCARD : ClientUtils.escapeQueryChars((String)svalue);
                query.append(svalue);
                query.append(' ');
            }
        } else {
            String svalue = String.valueOf(field.getValue());
            svalue = svalue.endsWith(WILDCARD) ? ClientUtils.escapeQueryChars((String)StringUtils.removeEnd((String)svalue, (String)WILDCARD)) + WILDCARD : ClientUtils.escapeQueryChars((String)svalue);
            query.append(svalue);
        }
        query.append(')');
        return query;
    }

    private StringBuilder processSubquery(StringBuilder query, Map.Entry<String, Map<String, ?>> subquery) {
        query.append(' ').append(QUERY_OPERATORS.get(subquery.getKey())).append('(');
        for (Map.Entry<String, ?> field : subquery.getValue().entrySet()) {
            this.processQueryPart(query, field, false);
        }
        query.append(')');
        return query;
    }

    private static class JSONOntologyTerm
    implements VocabularyTerm {
        private JSONObject data;
        private Vocabulary ontology;

        public JSONOntologyTerm(JSONObject data, Vocabulary ontology) {
            this.data = data;
            this.ontology = ontology;
        }

        public String getId() {
            return this.data.getString(RemoteGeneNomenclature.LABEL_KEY);
        }

        public String getName() {
            return this.data.getString("name");
        }

        public String getDescription() {
            return "";
        }

        public Set<VocabularyTerm> getParents() {
            return Collections.emptySet();
        }

        public Set<VocabularyTerm> getAncestors() {
            return Collections.emptySet();
        }

        public Set<VocabularyTerm> getAncestorsAndSelf() {
            return Collections.singleton(this);
        }

        public long getDistanceTo(VocabularyTerm other) {
            return -1L;
        }

        public Object get(String name) {
            return this.data.get(name);
        }

        public Vocabulary getVocabulary() {
            return this.ontology;
        }

        public String toString() {
            return "HGNC:" + this.getId();
        }

        public JSON toJSON() {
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)this.getId());
            return json;
        }
    }
}

