/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.vocabulary.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.phenotips.vocabulary.Vocabulary;
import org.phenotips.vocabulary.VocabularyTerm;
import org.phenotips.vocabulary.internal.solr.AbstractCSVSolrVocabulary;
import org.phenotips.vocabulary.internal.solr.SolrVocabularyTerm;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Named(value="hgnc")
@Singleton
public class GeneNomenclature
extends AbstractCSVSolrVocabulary {
    private static final String ID_FIELD_NAME = "id";
    private static final String SYMBOL_FIELD_NAME = "symbol";
    private static final String PREV_SYMBOL_FIELD_NAME = "prev_symbol";
    private static final String ALIAS_SYMBOL_FIELD_NAME = "alias_symbol";
    private static final String ALTERNATIVE_ID_FIELD_NAME = "alt_id";
    private static final Map<String, String> COMMON_SEARCH_OPTIONS;
    private static final Map<String, String> DISMAX_SEARCH_OPTIONS;
    private static final Map<String, String> IDENTIFIER_SEARCH_OPTIONS;
    private static final Map<String, String> TEXT_SEARCH_OPTIONS;
    private static final Map<String, String> SPELLCHECKED_TEXT_SEARCH_OPTIONS;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;

    public String getDefaultSourceLocation() {
        return "ftp://ftp.ebi.ac.uk/pub/databases/genenames/new/tsv/hgnc_complete_set.txt";
    }

    protected int getSolrDocsPerBatch() {
        return 500000;
    }

    protected String getName() {
        return "hgnc";
    }

    public Set<String> getAliases() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getName());
        result.add("HGNC");
        return result;
    }

    public VocabularyTerm getTerm(String symbol) {
        String escapedSymbol = ClientUtils.escapeQueryChars((String)symbol);
        VocabularyTerm result = this.getTermById(escapedSymbol);
        if (result != null) {
            return result;
        }
        result = this.getTermBySymbolOrAlias(escapedSymbol);
        if (result != null) {
            return result;
        }
        result = this.getTermByAlternativeId(escapedSymbol);
        return result;
    }

    private VocabularyTerm getTermById(String id) {
        return this.requestTerm("id:" + id, null);
    }

    private VocabularyTerm getTermBySymbolOrAlias(String id) {
        return this.requestTerm(String.format("%2$s:%1$s %3$s:%1$s %4$s:%1$s", id, SYMBOL_FIELD_NAME, PREV_SYMBOL_FIELD_NAME, ALIAS_SYMBOL_FIELD_NAME), null);
    }

    private VocabularyTerm getTermByAlternativeId(String id) {
        return this.requestTerm("alt_id:" + id, null);
    }

    private SolrParams produceDynamicSolrParams(String originalQuery, Integer rows, String sort, String customFilter) {
        String escapedQuery = ClientUtils.escapeQueryChars((String)originalQuery.trim());
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{escapedQuery});
        params.add("rows", new String[]{rows.toString()});
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            params.add("sort", new String[]{sort});
        }
        params.add("fq", new String[]{(String)StringUtils.defaultIfBlank((CharSequence)customFilter, (CharSequence)"status:Approved")});
        return params;
    }

    public List<VocabularyTerm> search(String input, int maxResults, String sort, String customFilter) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return Collections.emptyList();
        }
        List<VocabularyTerm> result = this.searchIdentifiers(input, maxResults, sort, customFilter);
        if (result == null || result.isEmpty()) {
            result = this.searchText(input, maxResults, sort, customFilter);
        }
        if (result == null || result.isEmpty()) {
            result = this.searchTextSpellchecked(input, maxResults, sort, customFilter);
        }
        return result;
    }

    private List<VocabularyTerm> searchIdentifiers(String input, int maxResults, String sort, String customFilter) {
        SolrParams params = this.produceDynamicSolrParams(input, maxResults, sort, customFilter);
        LinkedList<VocabularyTerm> result = new LinkedList<VocabularyTerm>();
        for (SolrDocument doc : this.search(params, IDENTIFIER_SEARCH_OPTIONS)) {
            result.add((VocabularyTerm)new SolrVocabularyTerm(doc, (Vocabulary)this));
        }
        return result;
    }

    private List<VocabularyTerm> searchText(String input, int maxResults, String sort, String customFilter) {
        SolrParams params = this.produceDynamicSolrParams(input, maxResults, sort, customFilter);
        LinkedList<VocabularyTerm> result = new LinkedList<VocabularyTerm>();
        for (SolrDocument doc : this.search(params, TEXT_SEARCH_OPTIONS)) {
            result.add((VocabularyTerm)new SolrVocabularyTerm(doc, (Vocabulary)this));
        }
        return result;
    }

    private List<VocabularyTerm> searchTextSpellchecked(String input, int maxResults, String sort, String customFilter) {
        SolrParams params = this.produceDynamicSolrParams(input, maxResults, sort, customFilter);
        LinkedList<VocabularyTerm> result = new LinkedList<VocabularyTerm>();
        for (SolrDocument doc : this.search(params, SPELLCHECKED_TEXT_SEARCH_OPTIONS)) {
            result.add((VocabularyTerm)new SolrVocabularyTerm(doc, (Vocabulary)this));
        }
        return result;
    }

    public Set<VocabularyTerm> getTerms(Collection<String> symbols) {
        LinkedHashSet<VocabularyTerm> result = new LinkedHashSet<VocabularyTerm>();
        for (String symbol : symbols) {
            VocabularyTerm term = this.getTerm(symbol);
            if (term == null) continue;
            result.add(term);
        }
        return result;
    }

    public long getDistance(String fromTermId, String toTermId) {
        return -1L;
    }

    public long getDistance(VocabularyTerm fromTerm, VocabularyTerm toTerm) {
        return -1L;
    }

    protected Collection<SolrInputDocument> load(URL url) {
        try {
            HashSet<SolrInputDocument> solrDocuments = new HashSet<SolrInputDocument>();
            InputStreamReader in = new InputStreamReader(url.openConnection().getInputStream(), Charset.forName("UTF-8"));
            for (CSVRecord row : CSVFormat.TDF.withHeader(new String[0]).parse((Reader)in)) {
                SolrInputDocument crtTerm = new SolrInputDocument();
                for (Map.Entry item : row.toMap().entrySet()) {
                    if ("hgnc_id".equals(item.getKey())) {
                        crtTerm.addField(ID_FIELD_NAME, item.getValue());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)item.getValue()))) continue;
                    crtTerm.addField((String)item.getKey(), (Object)StringUtils.split((String)((String)item.getValue()), (String)"|"));
                }
                solrDocuments.add(crtTerm);
            }
            this.addMetaInfo(solrDocuments);
            return solrDocuments;
        }
        catch (IOException ex) {
            this.logger.warn("Failed to read/parse the HGNC source: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private void addMetaInfo(Collection<SolrInputDocument> data) {
        SolrInputDocument metaTerm = new SolrInputDocument();
        metaTerm.addField(ID_FIELD_NAME, (Object)"HEADER_INFO");
        metaTerm.addField("version", (Object)ISODateTimeFormat.dateTime().withZoneUTC().print((ReadableInstant)new DateTime()));
        data.add(metaTerm);
    }

    static {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("lowercaseOperators", Boolean.toString(false));
        options.put("defType", "edismax");
        COMMON_SEARCH_OPTIONS = Collections.unmodifiableMap(options);
        String spellcheck = "spellcheck";
        options = new HashMap();
        options.put("qf", "symbol^100 symbolStub^75 alt_id^60 alt_idStub^40 name^10 nameSpell^18 nameStub^5 synonym^6 synonymSpell^10 synonymStub^3 text^1 textSpell^2 textStub^0.5");
        options.put("pf", "name^20 nameSpell^36 nameExact^100 namePrefix^30 synonym^15 synonymSpell^25 synonymExact^70 synonymPrefix^20 text^3 textSpell^5");
        DISMAX_SEARCH_OPTIONS = Collections.unmodifiableMap(options);
        options = new HashMap();
        options.putAll(COMMON_SEARCH_OPTIONS);
        options.put(spellcheck, Boolean.toString(false));
        options.put("qf", "symbol^50 symbolStub^25 alt_id^20 alt_idStub^10");
        IDENTIFIER_SEARCH_OPTIONS = Collections.unmodifiableMap(options);
        options = new HashMap();
        options.putAll(COMMON_SEARCH_OPTIONS);
        options.put(spellcheck, Boolean.toString(false));
        options.putAll(DISMAX_SEARCH_OPTIONS);
        TEXT_SEARCH_OPTIONS = Collections.unmodifiableMap(options);
        options = new HashMap();
        options.putAll(COMMON_SEARCH_OPTIONS);
        options.put(spellcheck, Boolean.toString(true));
        options.put("spellcheck.collate", Boolean.toString(true));
        options.put("spellcheck.count", "100");
        options.put("spellcheck.maxCollationTries", "3");
        options.putAll(DISMAX_SEARCH_OPTIONS);
        SPELLCHECKED_TEXT_SEARCH_OPTIONS = Collections.unmodifiableMap(options);
    }
}

