/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.phenotips.data.Patient;
import org.phenotips.export.internal.DataCell;
import org.phenotips.export.internal.DataSection;
import org.phenotips.export.internal.DataToCellConverter;
import org.phenotips.export.internal.SheetAssembler;
import org.phenotips.export.internal.Styler;

public class SpreadsheetExporter {
    protected Workbook wBook;
    protected Map<String, Sheet> sheets = new HashMap<String, Sheet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String[] enabledFieldsArray, List<Patient> patients, OutputStream outputStream) throws Exception {
        if (enabledFieldsArray == null || outputStream == null) {
            return;
        }
        HashSet<String> enabledFields = new HashSet<String>(Arrays.asList(enabledFieldsArray));
        try {
            this.wBook = this.createNewWorkbook();
            this.processMainSheet(enabledFields, patients);
            this.wBook.write(outputStream);
            outputStream.flush();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Workbook createNewWorkbook() {
        return new XSSFWorkbook();
    }

    protected void processMainSheet(Set<String> enabledFields, List<Patient> patients) throws Exception {
        String sheetName = "main";
        Sheet sheet = this.wBook.createSheet("Patient Sheet");
        this.sheets.put(sheetName, sheet);
        SheetAssembler assembler = this.runAssembler(enabledFields, patients);
        this.commit(assembler.getAssembled(), sheet);
        this.freezeHeader(assembler.getHeaderHeight().shortValue(), sheet);
    }

    protected void freezeHeader(Short height, Sheet sheet) {
        sheet.createFreezePane(0, (int)height.shortValue());
    }

    protected SheetAssembler runAssembler(Set<String> enabledFields, List<Patient> patients) throws Exception {
        return new SheetAssembler(enabledFields, patients);
    }

    protected void commit(DataSection section, Sheet sheet) {
        DataCell[][] cells = section.getMatrix();
        Styler styler = new Styler();
        this.commitRows(section, sheet, styler);
        for (int col = 0; section.getMaxX() >= col; ++col) {
            sheet.autoSizeColumn(col);
            int correctWidth = DataToCellConverter.MAX_CHARACTERS_PER_LINE * 210;
            if (sheet.getColumnWidth(col) <= correctWidth) continue;
            sheet.setColumnWidth(col, correctWidth);
        }
        Integer y = 0;
        while (y <= section.getMaxY()) {
            Integer n;
            Integer x = 0;
            while (x <= section.getMaxX()) {
                DataCell dataCell = cells[x][y];
                if (dataCell != null && dataCell.getMergeX() != null) {
                    sheet.addMergedRegion(new CellRangeAddress(y.intValue(), y.intValue(), x.intValue(), x + dataCell.getMergeX()));
                }
                n = x;
                Integer n2 = x = Integer.valueOf(x + 1);
            }
            Integer n3 = y;
            n = y = Integer.valueOf(y + 1);
        }
    }

    protected void commitRows(DataSection section, Sheet sheet, Styler styler) {
        DataCell[][] cells = section.getMatrix();
        Integer y = 0;
        while (y <= section.getMaxY()) {
            Row row = sheet.createRow(y.intValue());
            Integer maxLines = 0;
            Integer x = 0;
            while (x <= section.getMaxX()) {
                DataCell dataCell = cells[x][y];
                if (dataCell != null) {
                    Cell cell = row.createCell(x.intValue());
                    cell.setCellValue(dataCell.getValue());
                    styler.style(dataCell, cell, this.wBook);
                    if (dataCell.getNumberOfLines() != null) {
                        maxLines = maxLines < dataCell.getNumberOfLines() ? dataCell.getNumberOfLines() : maxLines;
                    }
                }
                Integer n = x;
                Integer n2 = x = Integer.valueOf(x + 1);
            }
            if (maxLines > 1) {
                Integer height = maxLines * 400;
                row.setHeight(height.shortValue());
            }
            Integer n = y;
            Integer n3 = y = Integer.valueOf(y + 1);
        }
    }
}

