/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.data.Disorder;
import org.phenotips.data.Feature;
import org.phenotips.data.FeatureMetadatum;
import org.phenotips.data.Gene;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientData;
import org.phenotips.data.PhenoTipsDate;
import org.phenotips.data.internal.SolvedData;
import org.phenotips.export.internal.ConversionHelpers;
import org.phenotips.export.internal.DataCell;
import org.phenotips.export.internal.DataSection;
import org.phenotips.export.internal.StyleOption;
import org.phenotips.translation.TranslationManager;
import org.phenotips.vocabulary.internal.solr.SolrVocabularyTerm;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.model.reference.DocumentReference;

public class DataToCellConverter {
    public static final Integer MAX_CHARACTERS_PER_LINE = 100;
    private static final String ALLERGIES = "allergies";
    private Map<String, Set<String>> enabledHeaderIdsBySection = new HashMap<String, Set<String>>();
    private ConversionHelpers phenotypeHelper;
    private ConversionHelpers prenatalPhenotypeHelper;
    private TranslationManager translationManager;

    public DataToCellConverter() {
        try {
            this.translationManager = (TranslationManager)ComponentManagerRegistry.getContextComponentManager().getInstance(TranslationManager.class);
        }
        catch (ComponentLookupException ex) {
            LoggerFactory.getLogger(this.getClass()).warn("Failed to lookup TranslationManager component: [{}]", (Object)ex.getMessage());
        }
    }

    public void phenotypeSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "phenotype";
        String[] fieldIds = new String[]{"phenotype", "phenotype_meta"};
        String[][] headerIds = new String[][]{{"present", "name", "id"}, {"present", "name", "id", "meta.name", "meta.id"}};
        Set<String> present = this.addHeaders(fieldIds, headerIds, enabledFields);
        this.enabledHeaderIdsBySection.put(sectionName, present);
        this.phenotypeHelper = new ConversionHelpers();
        this.phenotypeHelper.featureSetUp(present.contains("type"));
    }

    public DataSection phenotypeHeader() throws Exception {
        String sectionName = "phenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int hX = 0;
        for (String headerId : present) {
            DataCell cell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.phenotype." + headerId, new Object[0]), hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
        }
        DataCell sectionHeader = new DataCell(this.translationManager.translate("phenotips.export.excel.label.phenotype", new Object[0]), 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection phenotypeBody(Patient patient) throws Exception {
        List<Feature> sortedFeatures;
        String sectionName = "phenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int y = 0;
        Set features = patient.getFeatures();
        boolean categoriesEnabled = present.contains("type");
        Map<Object, Object> sectionFeatureLookup = new HashMap();
        if (!categoriesEnabled) {
            sortedFeatures = this.phenotypeHelper.sortFeaturesSimple(features);
        } else {
            sortedFeatures = this.phenotypeHelper.sortFeaturesWithSections(features);
            sectionFeatureLookup = this.phenotypeHelper.getSectionFeatureTree();
        }
        Boolean lastStatus = null;
        String lastSection = "";
        for (Feature feature : sortedFeatures) {
            int x = 0;
            if (!Boolean.valueOf(feature.isPresent()).equals(lastStatus)) {
                lastSection = "";
                DataCell cell = new DataCell(feature.isPresent() ? this.translationManager.translate("yes", new Object[0]) : this.translationManager.translate("no", new Object[0]), x, y);
                if (lastStatus != null) {
                    cell.addStyle(StyleOption.YES_NO_SEPARATOR);
                }
                cell.addStyle((lastStatus = Boolean.valueOf(feature.isPresent())) != false ? StyleOption.YES : StyleOption.NO);
                section.addCell(cell);
            }
            if (categoriesEnabled) {
                ++x;
                String currentSection = (String)sectionFeatureLookup.get(feature.getId());
                if (!StringUtils.equals((CharSequence)currentSection, (CharSequence)lastSection)) {
                    DataCell cell = new DataCell(currentSection, x, y);
                    section.addCell(cell);
                    lastSection = currentSection;
                }
            }
            section.addCell(new DataCell(feature.getName(), ++x, y, StyleOption.FEATURE_SEPARATOR));
            section.addCell(new DataCell(feature.getId(), ++x, y, StyleOption.FEATURE_SEPARATOR));
            if (present.contains("meta.name")) {
                Collection featureMetadatum = feature.getMetadata().values();
                Boolean metaPresent = !featureMetadatum.isEmpty();
                for (FeatureMetadatum meta : featureMetadatum) {
                    section.addCell(new DataCell(meta.getName(), x + 1, y));
                    section.addCell(new DataCell(meta.getId(), x + 2, y));
                    ++y;
                }
                if (!metaPresent.booleanValue()) {
                    section.addCell(new DataCell("", x + 1, y));
                    section.addCell(new DataCell("", x + 2, y));
                } else {
                    --y;
                }
            }
            ++y;
        }
        if (sortedFeatures.isEmpty()) {
            for (int emptyX = 0; emptyX < present.size(); ++emptyX) {
                section.addCell(new DataCell("", emptyX, 0));
            }
        }
        return section;
    }

    public void genesSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "genes";
        if (!enabledFields.remove(sectionName)) {
            return;
        }
        this.enabledHeaderIdsBySection.put(sectionName, new LinkedHashSet<String>(Arrays.asList("gene", "status", "strategy", "comments")));
    }

    public DataSection genesHeader() throws Exception {
        String sectionName = "genes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        int hX = 0;
        DataSection section = new DataSection();
        for (String field : present) {
            section.addCell(new DataCell(this.translationManager.translate("PhenoTips.GeneClass_" + field, new Object[0]), hX++, 1, StyleOption.HEADER));
        }
        DataCell sectionHeader = new DataCell(this.translationManager.translate("phenotips.export.excel.label.genotype", new Object[0]), 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection genesBody(Patient patient) throws Exception {
        String sectionName = "genes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int y = 0;
        PatientData allGenes = patient.getData("genes");
        if (allGenes == null || !allGenes.isIndexed()) {
            for (int i = 0; i < present.size(); ++i) {
                DataCell cell = new DataCell("", i, y);
                section.addCell(cell);
            }
            return section;
        }
        List<String> strategyTranslates = Arrays.asList("sequencing", "deletion", "familial_mutation", "common_mutations");
        for (Gene gene : allGenes) {
            int x = 0;
            for (String field : present) {
                String value = "";
                switch (field) {
                    case "gene": {
                        value = gene.getName();
                        break;
                    }
                    case "strategy": {
                        value = this.getMultivalueField(gene.getStrategy(), strategyTranslates, "PhenoTips.GeneClass_strategy_");
                        break;
                    }
                    case "status": {
                        value = this.translationManager.translate("PhenoTips.GeneClass_status_" + gene.getStatus(), new Object[0]);
                        break;
                    }
                    case "comments": {
                        value = gene.getComment();
                        break;
                    }
                }
                section.addCell(new DataCell(value, x++, y));
            }
            ++y;
        }
        return section;
    }

    public void variantsSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "variants";
        Set<String> present = this.enabledHeaderIdsBySection.get("genes");
        if (present == null || present.isEmpty() || !enabledFields.remove(sectionName)) {
            return;
        }
        List<String> columns = Arrays.asList("gene", "cdna", "protein", "transcript", "dbsnp", "zygosity", "effect", "interpretation", "inheritance", "evidence", "segregation", "sanger", "chromosome", "start_position", "end_position", "reference_genome");
        this.enabledHeaderIdsBySection.put(sectionName, new LinkedHashSet<String>(columns));
    }

    public DataSection variantsHeader() throws Exception {
        String sectionName = "variants";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        int hX = 0;
        DataSection section = new DataSection();
        for (String field : present) {
            String head = this.translationManager.translate("PhenoTips.GeneVariantClass_" + field, new Object[0]);
            section.addCell(new DataCell(head, hX++, 1, StyleOption.HEADER));
        }
        DataCell sectionHeader = new DataCell(this.translationManager.translate("phenotips.export.excel.label.genotype.variant", new Object[0]), 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection variantsBody(Patient patient) throws Exception {
        String sectionName = "variants";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int y = 0;
        PatientData variants = patient.getData("variants");
        if (variants == null || !variants.isIndexed()) {
            for (int i = 0; i < present.size(); ++i) {
                DataCell cell = new DataCell("", i, y);
                section.addCell(cell);
            }
            return section;
        }
        List<String> translatables = Arrays.asList("zygosity", "effect", "interpretation", "inheritance", "segregation", "evidence", "sanger");
        List<String> evidenceTranslates = Arrays.asList("rare", "predicted", "reported");
        for (Map variant : variants) {
            int x = 0;
            for (String field : present) {
                String value = (String)variant.get(field);
                if ("evidence".equals(field)) {
                    value = this.parseMultivalueField(value, evidenceTranslates, "PhenoTips.GeneVariantClass_evidence_");
                } else if (translatables.contains(field)) {
                    value = this.translationManager.translate("PhenoTips.GeneVariantClass_" + field + "_" + value, new Object[0]);
                }
                section.addCell(new DataCell(value, x++, y));
            }
            ++y;
        }
        return section;
    }

    public DataSection geneticNotesHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "genetic_notes";
        if (!enabledFields.remove(sectionName)) {
            return null;
        }
        Set<String> present = Collections.singleton(sectionName);
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.exportPreferences.field.geneticNotes", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection geneticNotesBody(Patient patient) {
        String sectionName = "genetic_notes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData notes = patient.getData("notes");
        String comments = notes != null ? (String)notes.get("genetic_notes") : "";
        for (DataCell gcell : ConversionHelpers.preventOverflow(comments, 0, 0)) {
            gcell.setMultiline();
            bodySection.addCell(gcell);
        }
        return bodySection;
    }

    public DataSection idHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "id";
        HashSet<String> present = new HashSet<String>();
        if (enabledFields.remove("doc.name")) {
            present.add("id");
        }
        if (enabledFields.remove("external_id")) {
            present.add("external_id");
        }
        if (present.isEmpty()) {
            return null;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection section = new DataSection();
        DataCell topCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.identifiers", new Object[0]), 0, 0, StyleOption.HEADER);
        topCell.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(topCell);
        int hX = 0;
        if (present.contains("id")) {
            DataCell idCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.identifiers.internal", new Object[0]), hX, 1, StyleOption.HEADER);
            section.addCell(idCell);
            ++hX;
        }
        if (present.contains("external_id")) {
            DataCell externalIdCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.identifiers.external", new Object[0]), hX, 1, StyleOption.HEADER);
            section.addCell(externalIdCell);
        }
        return section;
    }

    public DataSection idBody(Patient patient) throws Exception {
        DataCell cell;
        String sectionName = "id";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int x = 0;
        if (present.contains("id")) {
            cell = new DataCell(patient.getId(), x, 0);
            section.addCell(cell);
            ++x;
        }
        if (present.contains("external_id")) {
            cell = new DataCell(patient.getExternalId(), x, 0);
            section.addCell(cell);
        }
        return section;
    }

    public DataSection documentInfoHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "documentInfo";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("referrer", "creationDate", "author", "date"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        DataSection headerSection = new DataSection();
        if (fields.isEmpty()) {
            return null;
        }
        int hX = 0;
        for (String fieldId : fields) {
            DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.exportPreferences.field." + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++hX;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.documentInfo", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection documentInfoBody(Patient patient) throws Exception {
        Integer n;
        Object cell;
        SimpleDateFormat format;
        Integer n2;
        DataCell cell2;
        XWikiDocument patientDoc = patient.getXDocument();
        String sectionName = "documentInfo";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Integer x = 0;
        if (present.contains("referrer")) {
            String creator = this.getUsername(patientDoc.getCreatorReference());
            cell2 = new DataCell(creator, x, 0);
            bodySection.addCell(cell2);
            Integer n3 = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("creationDate")) {
            format = new SimpleDateFormat("yyyy.MM.dd");
            Date creationDate = patientDoc.getCreationDate();
            cell = new DataCell(format.format(creationDate), x, 0);
            bodySection.addCell((DataCell)cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("author")) {
            String lastModifiedBy = this.getUsername(patientDoc.getAuthorReference());
            cell2 = new DataCell(lastModifiedBy, x, 0);
            bodySection.addCell(cell2);
            cell = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("date")) {
            format = new SimpleDateFormat("yyyy.MM.dd");
            Date modificationDate = patientDoc.getDate();
            cell = new DataCell(format.format(modificationDate), x, 0);
            bodySection.addCell((DataCell)cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection patientInfoHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "patientInfo";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("first_name", "last_name", "date_of_birth", "gender", "indication_for_referral"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        DataSection headerSection = new DataSection();
        if (fields.isEmpty()) {
            return null;
        }
        int hX = 0;
        for (String fieldId : fields) {
            DataCell headerCell = new DataCell(this.translationManager.translate("PhenoTips.PatientClass_" + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++hX;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.patientInformation", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection patientInfoBody(Patient patient) {
        DataCell cell;
        String sectionName = "patientInfo";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        int x = 0;
        if (present.contains("first_name")) {
            String firstName = (String)patient.getData("patientName").get("first_name");
            cell = new DataCell(firstName, x, 0);
            bodySection.addCell(cell);
            ++x;
        }
        if (present.contains("last_name")) {
            String lastName = (String)patient.getData("patientName").get("last_name");
            cell = new DataCell(lastName, x, 0);
            bodySection.addCell(cell);
            ++x;
        }
        if (present.contains("date_of_birth")) {
            PhenoTipsDate dob = (PhenoTipsDate)patient.getData("dates").get("date_of_birth");
            if (dob != null && dob.toEarliestPossibleISODate() != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
                cell = new DataCell(format.format(dob.toEarliestPossibleISODate()), x, 0);
            } else {
                cell = new DataCell("", x, 0);
            }
            bodySection.addCell(cell);
            ++x;
        }
        if (present.contains("gender")) {
            String sex = (String)patient.getData("sex").getValue();
            cell = new DataCell(sex, x, 0);
            bodySection.addCell(cell);
            ++x;
        }
        if (present.contains("indication_for_referral")) {
            String indicationForReferral = (String)patient.getData("notes").get("indication_for_referral");
            for (DataCell cell2 : ConversionHelpers.preventOverflow(indicationForReferral, x, 0)) {
                cell2.setMultiline();
                bodySection.addCell(cell2);
            }
            ++x;
        }
        return bodySection;
    }

    public DataSection familyHistoryHeader(Set<String> enabledFields) throws Exception {
        DataCell headerCell;
        String sectionName = "familyHistory";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("global_mode_of_inheritance", "miscarriages", "consanguinity", "family_history", "paternal_ethnicity", "maternal_ethnicity"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        if (fields.isEmpty()) {
            return null;
        }
        DataSection headerSection = new DataSection();
        int bottomY = 1;
        int ethnicityOffset = 0;
        if (fields.contains("maternal_ethnicity") || fields.contains("paternal_ethnicity")) {
            bottomY = 2;
            ethnicityOffset = fields.contains("maternal_ethnicity") && fields.contains("paternal_ethnicity") ? 2 : 1;
        }
        int x = 0;
        for (String fieldId : fields) {
            DataCell headerCell2 = new DataCell(this.translationManager.translate("phenotips.export.excel.label.familyHistory." + fieldId, new Object[0]), x, bottomY, StyleOption.HEADER);
            headerSection.addCell(headerCell2);
            ++x;
        }
        if (ethnicityOffset > 0) {
            headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.familyHistory.ethnicity", new Object[0]), x - ethnicityOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.familyHistory", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection familyHistoryBody(Patient patient) {
        DataCell cell;
        DataCell cell2;
        String sectionName = "familyHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData familyHistory = patient.getData("familyHistory");
        PatientData ethnicities = patient.getData("ethnicity");
        int x = 0;
        if (present.contains("global_mode_of_inheritance")) {
            PatientData globalControllers = patient.getData("global-qualifiers");
            List modeTermList = globalControllers != null ? (List)globalControllers.get("global_mode_of_inheritance") : null;
            int y = 0;
            if (modeTermList != null && !modeTermList.isEmpty()) {
                for (SolrVocabularyTerm term : modeTermList) {
                    String mode = term != null ? term.getName() : "";
                    DataCell cell3 = new DataCell(mode, x, y);
                    bodySection.addCell(cell3);
                    ++y;
                }
            } else {
                DataCell cell4 = new DataCell("", x, y);
                bodySection.addCell(cell4);
            }
            ++x;
        }
        if (present.contains("miscarriages")) {
            Integer miscarriages = (Integer)familyHistory.get("miscarriages");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(miscarriages), x, 0);
            bodySection.addCell(cell2);
            ++x;
        }
        if (present.contains("consanguinity")) {
            Integer consanguinity = (Integer)familyHistory.get("consanguinity");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(consanguinity), x, 0);
            bodySection.addCell(cell2);
            ++x;
        }
        if (present.contains("family_history")) {
            PatientData notes = patient.getData("notes");
            String familyConditions = notes != null ? (String)notes.get("family_history") : "";
            for (DataCell cell4 : ConversionHelpers.preventOverflow(familyConditions, x, 0)) {
                cell4.setMultiline();
                bodySection.addCell(cell4);
            }
            ++x;
        }
        if (present.contains("paternal_ethnicity")) {
            List paternalEthnicity = (List)ethnicities.get("paternal_ethnicity");
            int y = 0;
            if (paternalEthnicity != null && !paternalEthnicity.isEmpty()) {
                for (String pEthnicity : paternalEthnicity) {
                    cell = new DataCell(pEthnicity, x, y);
                    bodySection.addCell(cell);
                    ++y;
                }
            } else {
                DataCell cell5 = new DataCell("", x, y);
                bodySection.addCell(cell5);
            }
            ++x;
        }
        if (present.contains("maternal_ethnicity")) {
            List maternalEthnicity = (List)ethnicities.get("maternal_ethnicity");
            int y = 0;
            if (maternalEthnicity != null && !maternalEthnicity.isEmpty()) {
                for (String mEthnicity : maternalEthnicity) {
                    cell = new DataCell(mEthnicity, x, y);
                    bodySection.addCell(cell);
                    ++y;
                }
            } else {
                DataCell cell5 = new DataCell("", x, y);
                bodySection.addCell(cell5);
            }
            ++x;
        }
        return bodySection;
    }

    public DataSection prenatalPerinatalHistoryHeader(Set<String> enabledFields) throws Exception {
        DataCell headerCell;
        String sectionName = "prenatalPerinatalHistory";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("gestation", "prenatal_development", "parentalAge", "assistedReproduction_fertilityMeds", "assistedReproduction_iui", "ivf", "icsi", "assistedReproduction_surrogacy", "assistedReproduction_donoregg", "assistedReproduction_donorsperm", "obstetricHistory", "apgar1"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        if (fields.isEmpty()) {
            return null;
        }
        DataSection headerSection = new DataSection();
        ArrayList<String> assitedReproductionFields = new ArrayList<String>(Arrays.asList("assistedReproduction_fertilityMeds", "assistedReproduction_iui", "ivf", "icsi", "assistedReproduction_surrogacy", "assistedReproduction_donoregg", "assistedReproduction_donorsperm"));
        List<String> parentalFields = Arrays.asList("maternalAge", "paternalAge");
        List<String> obstetricFields = Arrays.asList("gravida", "para", "term", "preterm", "sab", "tab", "births");
        ArrayList<String> apgarFields = new ArrayList<String>(Arrays.asList("apgar1", "apgar5"));
        assitedReproductionFields.retainAll(fieldSet);
        int assistedReproductionOffset = assitedReproductionFields.size();
        int parentalOffset = fields.contains("parentalAge") ? parentalFields.size() : 0;
        int apgarOffset = fields.contains("apgar1") ? 2 : 0;
        int obstetricOffset = fields.contains("obstetricHistory") ? obstetricFields.size() : 0;
        int bottomY = apgarOffset > 0 || obstetricOffset > 0 || parentalOffset > 0 || assistedReproductionOffset > 0 ? 2 : 1;
        int hX = 0;
        for (String fieldId : fields) {
            DataCell headerCell2;
            if ("parentalAge".equals(fieldId)) {
                for (String field : parentalFields) {
                    headerCell2 = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory." + field, new Object[0]), hX, bottomY, StyleOption.HEADER);
                    headerSection.addCell(headerCell2);
                    ++hX;
                }
                continue;
            }
            if ("apgar1".equals(fieldId)) {
                for (String apgarId : apgarFields) {
                    headerCell2 = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory." + apgarId, new Object[0]), hX, bottomY, StyleOption.HEADER);
                    headerSection.addCell(headerCell2);
                    ++hX;
                }
                continue;
            }
            if ("obstetricHistory".equals(fieldId)) {
                for (String field : obstetricFields) {
                    headerCell2 = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory." + field, new Object[0]), hX, bottomY, StyleOption.HEADER);
                    headerSection.addCell(headerCell2);
                    ++hX;
                }
                continue;
            }
            DataCell headerCell3 = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory." + fieldId, new Object[0]), hX, bottomY, StyleOption.HEADER);
            headerSection.addCell(headerCell3);
            ++hX;
        }
        if (parentalOffset > 0) {
            headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory.parentalAge", new Object[0]), hX - obstetricOffset - apgarOffset - assistedReproductionOffset - parentalOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        if (assistedReproductionOffset > 0) {
            headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory.assistedReproduction", new Object[0]), hX - apgarOffset - assistedReproductionOffset - obstetricOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        if (obstetricOffset > 0) {
            headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory.obstetricHistory", new Object[0]), hX - obstetricOffset - apgarOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        if (apgarOffset > 0) {
            headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory.apgarScore", new Object[0]), hX - apgarOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPerinatalHistory", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection prenatalPerinatalHistoryBody(Patient patient) {
        DataCell cell;
        String cellValue;
        String sectionName = "prenatalPerinatalHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData history = patient.getData("prenatalPerinatalHistory");
        PatientData apgarScores = patient.getData("apgar");
        PatientData parentalAge = patient.getData("parentalAge");
        PatientData obstetricHistory = patient.getData("obstetric-history");
        int x = 0;
        if (present.contains("gestation")) {
            Integer gestation = (Integer)history.get("gestation");
            DataCell cell2 = new DataCell(gestation != null ? gestation.toString() : "", x, 0);
            bodySection.addCell(cell2);
            ++x;
        }
        if (present.contains("prenatal_development")) {
            PatientData notes = patient.getData("notes");
            Iterator<String> prenatalNotes = notes != null ? (String)notes.get("prenatal_development") : "";
            for (DataCell cell3 : ConversionHelpers.preventOverflow((String)((Object)prenatalNotes), x, 0)) {
                cell3.setMultiline();
                bodySection.addCell(cell3);
            }
            ++x;
        }
        if (present.contains("parentalAge")) {
            List<String> parentalFields = Arrays.asList("maternal_age", "paternal_age");
            for (String field : parentalFields) {
                Integer age = parentalAge != null ? (Integer)parentalAge.get(field) : null;
                String cellValue2 = age != null ? age.toString() : "";
                DataCell cell4 = new DataCell(cellValue2, x, 0);
                bodySection.addCell(cell4);
                ++x;
            }
        }
        List<String> fields = Arrays.asList("assistedReproduction_fertilityMeds", "assistedReproduction_iui", "ivf", "icsi", "assistedReproduction_surrogacy", "assistedReproduction_donoregg", "assistedReproduction_donorsperm");
        for (String field : fields) {
            if (!present.contains(field)) continue;
            Integer assisted = (Integer)history.get(field);
            DataCell cell5 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell5);
            ++x;
        }
        if (present.contains("obstetricHistory")) {
            List<String> obstetricFields = Arrays.asList("gravida", "para", "term", "preterm", "sab", "tab", "births");
            for (String field : obstetricFields) {
                Integer oData = obstetricHistory != null ? (Integer)obstetricHistory.get(field) : null;
                cellValue = oData != null ? oData.toString() : "";
                cell = new DataCell(cellValue, x, 0);
                bodySection.addCell(cell);
                ++x;
            }
        }
        if (present.contains("apgar1")) {
            List<String> apgarFields = Arrays.asList("apgar1", "apgar5");
            for (String aField : apgarFields) {
                Integer apgar = (Integer)apgarScores.get(aField);
                cellValue = apgar != null ? apgar.toString() : "";
                cell = new DataCell(cellValue, x, 0);
                bodySection.addCell(cell);
                ++x;
            }
        }
        return bodySection;
    }

    public void prenatalPhenotypeSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "prenatalPhenotype";
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        present.add("present");
        present.add("name");
        present.add("id");
        if (enabledFields.remove("prenatal_phenotype")) {
            this.enabledHeaderIdsBySection.put(sectionName, present);
        }
        this.prenatalPhenotypeHelper = new ConversionHelpers();
        this.prenatalPhenotypeHelper.featureSetUp(false);
    }

    public DataSection prenatalPhenotypeHeader() throws Exception {
        String sectionName = "prenatalPhenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int hX = 0;
        for (String headerId : present) {
            section.addCell(new DataCell(this.translationManager.translate("phenotips.export.excel.label.phenotype." + headerId, new Object[0]), hX, 1, StyleOption.HEADER));
            ++hX;
        }
        DataCell sectionHeader = new DataCell(this.translationManager.translate("phenotips.export.excel.label.prenatalPhenotype", new Object[0]), 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection prenatalPhenotypeBody(Patient patient) throws Exception {
        String sectionName = "prenatalPhenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int y = 0;
        Set<Feature> features = patient.getFeatures();
        features = this.prenatalPhenotypeHelper.filterFeaturesByPrenatal((Set<? extends Feature>)features, true);
        List<Feature> sortedFeatures = this.prenatalPhenotypeHelper.sortFeaturesSimple(features);
        Boolean lastStatus = null;
        for (Feature feature : sortedFeatures) {
            int x = 0;
            if (!Boolean.valueOf(feature.isPresent()).equals(lastStatus)) {
                DataCell cell = new DataCell(feature.isPresent() ? this.translationManager.translate("yes", new Object[0]) : this.translationManager.translate("no", new Object[0]), x, y);
                if (lastStatus != null) {
                    cell.addStyle(StyleOption.YES_NO_SEPARATOR);
                }
                cell.addStyle((lastStatus = Boolean.valueOf(feature.isPresent())) != false ? StyleOption.YES : StyleOption.NO);
                section.addCell(cell);
            }
            section.addCell(new DataCell(feature.getName(), ++x, y, StyleOption.FEATURE_SEPARATOR));
            section.addCell(new DataCell(feature.getId(), ++x, y, StyleOption.FEATURE_SEPARATOR));
            ++y;
        }
        if (sortedFeatures.isEmpty()) {
            for (int emptyX = 0; emptyX < present.size(); ++emptyX) {
                section.addCell(new DataCell("", emptyX, 0));
            }
        }
        return section;
    }

    public DataSection disordersHeaders(Set<String> enabledFields) throws Exception {
        String sectionName = "disorders";
        Set<String> present = Collections.singleton("omim_id");
        if (enabledFields.remove("omim_id")) {
            this.enabledHeaderIdsBySection.put(sectionName, present);
            DataSection headerSection = new DataSection();
            int hX = 0;
            for (String fieldId : Arrays.asList("name", "id")) {
                DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.disorders." + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
                headerSection.addCell(headerCell);
                ++hX;
            }
            DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.disorders", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
            headerCell.addStyle(StyleOption.HEADER);
            headerSection.addCell(headerCell);
            return headerSection;
        }
        return null;
    }

    public DataSection disordersBody(Patient patient) {
        String sectionName = "disorders";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Set disorders = patient.getDisorders();
        Integer y = 0;
        for (Disorder disorder : disorders) {
            bodySection.addCell(new DataCell(disorder.getName(), 0, y));
            bodySection.addCell(new DataCell(disorder.getId(), 1, y));
            Integer n = y;
            Integer n2 = y = Integer.valueOf(y + 1);
        }
        if (disorders.isEmpty()) {
            bodySection.addCell(new DataCell("", 0, y));
            bodySection.addCell(new DataCell("", 1, y));
        }
        return bodySection;
    }

    public DataSection clinicalDiagnosisHeaders(Set<String> enabledFields) throws Exception {
        String sectionName = "clinicalDiagnosis";
        Set<String> present = Collections.singleton("clinical_diagnosis");
        if (enabledFields.remove("clinical_diagnosis")) {
            this.enabledHeaderIdsBySection.put(sectionName, present);
            DataSection headerSection = new DataSection();
            int hX = 0;
            for (String fieldId : Arrays.asList("name", "id")) {
                DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.clinicalDiagnosis." + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
                headerSection.addCell(headerCell);
                ++hX;
            }
            DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.clinicalDiagnosis", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
            headerCell.addStyle(StyleOption.HEADER);
            headerSection.addCell(headerCell);
            return headerSection;
        }
        return null;
    }

    public DataSection clinicalDiagnosisBody(Patient patient) {
        String sectionName = "clinicalDiagnosis";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        int y = 0;
        DataSection bodySection = new DataSection();
        PatientData clinicalDisorders = patient.getData("clinical-diagnosis");
        if (clinicalDisorders == null || clinicalDisorders.size() == 0) {
            bodySection.addCell(new DataCell("", 0, y));
            bodySection.addCell(new DataCell("", 1, y));
            return bodySection;
        }
        for (Disorder disorder : clinicalDisorders) {
            bodySection.addCell(new DataCell(disorder.getName(), 0, y));
            bodySection.addCell(new DataCell(disorder.getId(), 1, y));
            ++y;
        }
        return bodySection;
    }

    public DataSection diagnosisNotesHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "diagnosis_notes";
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        if (enabledFields.remove(sectionName)) {
            present.add(sectionName);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.diagnosisNotes", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection diagnosisNotesBody(Patient patient) {
        String sectionName = "diagnosis_notes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData notes = patient.getData("notes");
        String comments = notes != null ? (String)notes.get("diagnosis_notes") : "";
        for (DataCell gcell : ConversionHelpers.preventOverflow(comments, 0, 0)) {
            gcell.setMultiline();
            bodySection.addCell(gcell);
        }
        return bodySection;
    }

    public DataSection medicalHistoryHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "medicalHistory";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(ALLERGIES, "global_age_of_onset", "medical_history"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        DataSection headerSection = new DataSection();
        if (fields.isEmpty()) {
            return null;
        }
        int hX = 0;
        for (String fieldId : fields) {
            DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.medicalHistory." + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++hX;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.medicalHistory", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection medicalHistoryBody(Patient patient) {
        String sectionName = "medicalHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Integer x = 0;
        if (present.contains(ALLERGIES)) {
            PatientData allergiesData = patient.getData(ALLERGIES);
            int y = 0;
            if (allergiesData != null && allergiesData.isIndexed()) {
                for (String n2 : allergiesData) {
                    DataCell cell = new DataCell(n2, x, y);
                    if ("NKDA".equals(n2)) {
                        cell.addStyle(StyleOption.YES);
                    }
                    bodySection.addCell(cell);
                    ++y;
                }
            }
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("global_age_of_onset")) {
            PatientData qualifiers = patient.getData("global-qualifiers");
            List ageOfOnsetList = qualifiers != null ? (List)qualifiers.get("global_age_of_onset") : null;
            int y = 0;
            if (ageOfOnsetList != null && !ageOfOnsetList.isEmpty()) {
                for (SolrVocabularyTerm term : ageOfOnsetList) {
                    String onset = term != null ? term.getName() : "";
                    DataCell cell2 = new DataCell(onset, x, y);
                    bodySection.addCell(cell2);
                    ++y;
                }
            } else {
                DataCell dataCell = new DataCell("", x, y);
                bodySection.addCell(dataCell);
            }
            Integer n = x;
            Integer n3 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("medical_history")) {
            PatientData notes = patient.getData("notes");
            String medicalNotes = notes != null ? (String)notes.get("medical_history") : "";
            for (DataCell dataCell : ConversionHelpers.preventOverflow(medicalNotes, x, 0)) {
                dataCell.setMultiline();
                bodySection.addCell(dataCell);
            }
            Integer n = x;
            Integer n4 = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection isNormalHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "isNormal";
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        if (enabledFields.remove("unaffected")) {
            present.add("unaffected");
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.unaffected", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection isNormalBody(Patient patient) {
        String sectionName = "isNormal";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        if (present.contains("unaffected")) {
            PatientData isNormal = patient.getData("clinicalStatus");
            String isNormalString = isNormal != null ? (String)isNormal.getValue() : "unaffected";
            Integer isNormalValue = "unaffected".equals(isNormalString) ? 1 : 0;
            DataCell cell = new DataCell(ConversionHelpers.integerToStrBool(isNormalValue), 0, 0);
            bodySection.addCell(cell);
        }
        return bodySection;
    }

    public DataSection isSolvedHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "isSolved";
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("solved", "solved__pubmed_id", "solved__notes"));
        fields.retainAll(enabledFields);
        HashSet<String> fieldSet = new HashSet<String>(fields);
        this.enabledHeaderIdsBySection.put(sectionName, fieldSet);
        DataSection headerSection = new DataSection();
        if (fields.isEmpty()) {
            return null;
        }
        int hX = 0;
        for (String fieldId : fields) {
            DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.solvedStatus." + fieldId, new Object[0]), hX, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++hX;
        }
        DataCell headerCell = new DataCell(this.translationManager.translate("phenotips.export.excel.label.solvedStatus", new Object[0]), 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection isSolvedBody(Patient patient) {
        String sectionName = "isSolved";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData patientData = patient.getData("solved");
        SolvedData data = patientData != null ? (SolvedData)patientData.getValue() : null;
        int x = 0;
        if (present.contains("solved")) {
            String solved = data != null ? data.getStatus() : null;
            DataCell cell = new DataCell(solved != null ? ConversionHelpers.strIntegerToStrBool(solved) : "", x, 0);
            bodySection.addCell(cell);
            ++x;
        }
        if (present.contains("solved__pubmed_id")) {
            List pubmedIds;
            List list = pubmedIds = data != null ? data.getPubmedIds() : Collections.emptyList();
            if (!pubmedIds.isEmpty()) {
                int y = 0;
                for (String id : pubmedIds) {
                    DataCell cell = new DataCell(StringUtils.isBlank((CharSequence)id) ? "" : id, x, y);
                    bodySection.addCell(cell);
                    ++y;
                }
                ++x;
            }
        }
        if (present.contains("solved__notes")) {
            String solvedNotes = data != null ? data.getNotes() : null;
            for (DataCell cell : ConversionHelpers.preventOverflow(solvedNotes, x, 0)) {
                cell.setMultiline();
                bodySection.addCell(cell);
            }
            ++x;
        }
        return bodySection;
    }

    private String getUsername(DocumentReference reference) {
        if (reference == null) {
            return this.translationManager.translate("phenotips.export.excel.label.unknownUser", new Object[0]);
        }
        return reference.getName();
    }

    private Set<String> addHeaders(String[] fieldIds, String[][] headerIds, Set<String> enabledFields) {
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        int counter = 0;
        for (String fieldId : fieldIds) {
            if (enabledFields.remove(fieldId)) {
                for (String headerId : headerIds[counter]) {
                    present.add(headerId);
                }
            }
            ++counter;
        }
        return present;
    }

    private String parseMultivalueField(String value, List<String> valueTranslates, String className) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        String field = "";
        for (String property : valueTranslates) {
            if (!value.contains(property)) continue;
            if (field.length() != 0) {
                field = field + "; ";
            }
            field = field + this.translationManager.translate(className + property, new Object[0]);
        }
        return field;
    }

    private String getMultivalueField(Collection<String> value, List<String> valueTranslates, String className) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        String field = "";
        for (String property : valueTranslates) {
            if (!value.contains(property)) continue;
            if (field.length() != 0) {
                field = field + "; ";
            }
            field = field + this.translationManager.translate(className + property, new Object[0]);
        }
        return field;
    }
}

