/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.phenotips.export.internal.DataCell;
import org.phenotips.export.internal.DataSection;
import org.phenotips.export.internal.StyleOption;

public class Styler {
    private static final String NO_MATRIX_ERR_MSG = "The section has not been converted to a matrix";
    private Map<Set<StyleOption>, CellStyle> styleCache = new HashMap<Set<StyleOption>, CellStyle>();
    private Font defaultFont;

    public static void disallowBodyStyles(DataSection section) throws Exception {
        DataCell[][] cellMatrix = section.getMatrix();
        if (cellMatrix == null) {
            throw new Exception(NO_MATRIX_ERR_MSG);
        }
        List<StyleOption> disallowedStyles = Arrays.asList(StyleOption.FEATURE_SEPARATOR, StyleOption.YES_NO_SEPARATOR);
        for (int x = 0; x <= section.getMaxX(); ++x) {
            DataCell cell = cellMatrix[x][0];
            if (cell == null) continue;
            cell.removeStyles(disallowedStyles);
        }
    }

    public static void styleSectionBottom(DataSection section, StyleOption style) throws Exception {
        DataCell[][] cellMatrix = section.getMatrix();
        if (cellMatrix == null) {
            throw new Exception(NO_MATRIX_ERR_MSG);
        }
        for (int x = 0; x <= section.getMaxX(); ++x) {
            DataCell cell = cellMatrix[x][section.getMaxY()];
            if (cell == null) {
                cell = new DataCell("", x, section.getMaxY());
                section.addCell(cell);
            }
            cell.addStyle(style);
        }
    }

    public static void styleSectionBorder(DataSection section, StyleOption styleLeft, StyleOption styleRight) throws Exception {
        DataCell[][] cellMatrix = section.getMatrix();
        if (cellMatrix == null) {
            throw new Exception(NO_MATRIX_ERR_MSG);
        }
        for (int y = 0; y <= section.getMaxY(); ++y) {
            DataCell cellLeft = cellMatrix[0][y];
            DataCell cellRight = cellMatrix[section.getMaxX()][y];
            if (cellLeft == null) {
                cellLeft = new DataCell("", 0, y);
                section.addCell(cellLeft);
            }
            if (cellRight == null) {
                cellRight = new DataCell("", section.getMaxX(), y);
                section.addCell(cellRight);
            }
            cellLeft.addStyle(styleLeft);
            cellRight.addStyle(styleRight);
        }
    }

    public static void extendStyleHorizontally(DataSection section, StyleOption ... styles) throws Exception {
        DataCell[][] cellMatrix = section.getMatrix();
        if (cellMatrix == null) {
            throw new Exception(NO_MATRIX_ERR_MSG);
        }
        for (int y = 0; y <= section.getMaxY(); ++y) {
            DataCell cell;
            int x;
            HashSet<StyleOption> toExtend = new HashSet<StyleOption>();
            Integer startingX = 0;
            Boolean found = false;
            for (x = 0; x <= section.getMaxX(); ++x) {
                found = false;
                cell = cellMatrix[x][y];
                if (cell == null) continue;
                for (StyleOption style : styles) {
                    if (cell.getStyles() == null || !cell.getStyles().contains((Object)style)) continue;
                    toExtend.add(style);
                    found = true;
                }
                if (!found.booleanValue()) continue;
                startingX = x;
                break;
            }
            if (!found.booleanValue()) continue;
            for (x = startingX + 1; x <= section.getMaxX(); ++x) {
                cell = cellMatrix[x][y];
                if (cell == null) {
                    cell = new DataCell("", x, y);
                    section.addCell(cell);
                }
                cell.addStyles(toExtend);
            }
        }
    }

    public static void extendStyleVertically(DataSection section, StyleOption ... styles) throws Exception {
        DataCell[][] cellMatrix = section.getMatrix();
        if (cellMatrix == null) {
            throw new Exception(NO_MATRIX_ERR_MSG);
        }
        for (int x = 0; x <= section.getMaxX(); ++x) {
            DataCell cell;
            int y;
            HashSet<StyleOption> toExtend = new HashSet<StyleOption>();
            Boolean found = false;
            for (y = 0; y <= section.getMaxY(); ++y) {
                found = false;
                cell = cellMatrix[x][y];
                if (cell == null) continue;
                for (StyleOption style : styles) {
                    if (cell.isChild().booleanValue() || cell.getStyles() == null || !cell.getStyles().contains((Object)style)) continue;
                    toExtend.add(style);
                    found = true;
                }
                if (found.booleanValue()) break;
            }
            if (!found.booleanValue()) continue;
            for (y = 0; y <= section.getMaxY(); ++y) {
                cell = cellMatrix[x][y];
                if (cell == null) {
                    cell = new DataCell("", x, y);
                    section.addCell(cell);
                }
                cell.addStyles(toExtend);
            }
        }
    }

    public void style(DataCell dataCell, Cell cell, Workbook wBook) {
        Set<StyleOption> styles = dataCell.getStyles();
        CellStyle cellStyle = wBook.createCellStyle();
        cellStyle.setWrapText(true);
        if (this.defaultFont == null) {
            this.defaultFont = this.createDefaultFont(wBook);
        }
        cellStyle.setFont(this.defaultFont);
        cellStyle.setVerticalAlignment((short)0);
        if (this.setDefaultStyle(styles, cell, cellStyle)) {
            return;
        }
        if (this.styleCache.containsKey(styles)) {
            cell.setCellStyle(this.styleCache.get(styles));
            return;
        }
        this.setFontStyles(styles, cell, cellStyle, wBook);
        this.setBorderStyles(styles, cell, cellStyle, wBook);
        this.styleCache.put(styles, cellStyle);
    }

    private boolean setDefaultStyle(Set<StyleOption> styles, Cell cell, CellStyle cellStyle) {
        if (styles == null) {
            if (this.styleCache.containsKey(Collections.emptySet())) {
                cell.setCellStyle(this.styleCache.get(Collections.emptySet()));
                return true;
            }
            cell.setCellStyle(cellStyle);
            this.styleCache.put(Collections.emptySet(), cellStyle);
            return true;
        }
        return false;
    }

    private void setFontStyles(Set<StyleOption> styles, Cell cell, CellStyle cellStyle, Workbook wBook) {
        Font font;
        Font headerFont = null;
        if (styles.contains((Object)StyleOption.HEADER)) {
            headerFont = wBook.createFont();
            headerFont.setBoldweight((short)700);
            cellStyle.setFont(headerFont);
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.LARGE_HEADER)) {
            if (headerFont == null) {
                headerFont = wBook.createFont();
                headerFont.setBoldweight((short)700);
            }
            headerFont.setFontHeightInPoints((short)12);
            cellStyle.setFont(headerFont);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.YES)) {
            font = this.createDefaultFont(wBook);
            font.setColor((short)17);
            cellStyle.setFont(font);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.NO)) {
            font = this.createDefaultFont(wBook);
            font.setColor((short)16);
            font.setBoldweight((short)700);
            cellStyle.setFont(font);
            cell.setCellStyle(cellStyle);
        }
    }

    private void setBorderStyles(Set<StyleOption> styles, Cell cell, CellStyle cellStyle, Workbook wBook) {
        if (styles.contains((Object)StyleOption.HEADER_BOTTOM)) {
            cellStyle.setBorderBottom((short)2);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.SECTION_BORDER_LEFT)) {
            cellStyle.setBorderLeft((short)2);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.SECTION_BORDER_RIGHT)) {
            cellStyle.setBorderRight((short)2);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.PATIENT_BORDER)) {
            cellStyle.setBorderBottom((short)1);
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.FEATURE_SEPARATOR)) {
            cellStyle.setBorderTop((short)1);
            cellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cell.setCellStyle(cellStyle);
        }
        if (styles.contains((Object)StyleOption.YES_NO_SEPARATOR)) {
            cellStyle.setBorderTop((short)3);
            cellStyle.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
            cell.setCellStyle(cellStyle);
        }
    }

    private Font createDefaultFont(Workbook wBook) {
        Font font = wBook.createFont();
        font.setFontHeightInPoints((short)9);
        font.setFontName("Calibri");
        return font;
    }
}

