/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.script;

import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientRepository;
import org.phenotips.export.internal.SpreadsheetExporter;
import org.phenotips.security.authorization.AuthorizationService;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;
import org.xwiki.users.UserManager;

@Unstable
@Component
@Named(value="spreadsheetexport")
@Singleton
public class SpreadsheetExportService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private PatientRepository patientRepository;
    @Inject
    private UserManager userManager;
    @Inject
    private AuthorizationService access;

    public void export(List<String> patientIds, String[] enabledFields, OutputStream outputStream) {
        SpreadsheetExporter exporter = new SpreadsheetExporter();
        try {
            LinkedList<Patient> patients = new LinkedList<Patient>();
            for (String patientId : patientIds) {
                Patient patient = (Patient)this.patientRepository.get(patientId);
                if (patient == null || !this.access.hasAccess(this.userManager.getCurrentUser(), Right.VIEW, (EntityReference)patient.getDocumentReference())) continue;
                patients.add(patient);
            }
            exporter.export(enabledFields, patients, outputStream);
        }
        catch (Exception ex) {
            this.logger.error("Error caught while generating an export spreadsheet", (Throwable)ex);
        }
    }
}

