/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.phenotips.data.Patient;
import org.phenotips.export.internal.DataCell;
import org.phenotips.export.internal.DataSection;
import org.phenotips.export.internal.DataToCellConverter;
import org.phenotips.export.internal.StyleOption;
import org.phenotips.export.internal.Styler;

public class SheetAssembler {
    private DataSection oneSection = new DataSection();
    private Integer headerHeight = 0;

    public SheetAssembler(Set<String> enabledFields, List<Patient> patients) throws Exception {
        DataToCellConverter converter = new DataToCellConverter();
        converter.phenotypeSetup(enabledFields);
        converter.prenatalPhenotypeSetup(enabledFields);
        converter.genesSetup(enabledFields);
        converter.variantsSetup(enabledFields);
        List<DataSection> headers = this.generateHeader(converter, enabledFields);
        List<List<DataSection>> bodySections = this.generateBody(converter, patients);
        LinkedList<DataSection> patientsCombined = new LinkedList<DataSection>();
        for (List<DataSection> patientSections : bodySections) {
            for (DataSection section : patientSections) {
                section.finalizeToMatrix();
                Styler.disallowBodyStyles(section);
                Styler.extendStyleHorizontally(section, StyleOption.FEATURE_SEPARATOR, StyleOption.YES_NO_SEPARATOR);
                Styler.styleSectionBorder(section, StyleOption.SECTION_BORDER_LEFT, StyleOption.SECTION_BORDER_RIGHT);
            }
            DataSection assembled = this.assembleSectionsX(patientSections, true);
            Styler.styleSectionBottom(assembled, StyleOption.PATIENT_BORDER);
            patientsCombined.add(assembled);
        }
        for (DataSection header : headers) {
            header.finalizeToMatrix();
            header.mergeX();
            Styler.styleSectionBorder(header, StyleOption.SECTION_BORDER_LEFT, StyleOption.SECTION_BORDER_RIGHT);
        }
        DataSection bodyCombined = this.assembleSectionsY(patientsCombined, false);
        DataSection headerCombined = this.assembleSectionsX(headers, true);
        Styler.styleSectionBottom(headerCombined, StyleOption.HEADER_BOTTOM);
        this.headerHeight = headerCombined.getMaxY() + 1;
        this.oneSection = this.assembleSectionsY(Arrays.asList(headerCombined, bodyCombined), true);
        Styler.extendStyleVertically(this.oneSection, StyleOption.SECTION_BORDER_LEFT, StyleOption.SECTION_BORDER_RIGHT);
    }

    private List<List<DataSection>> generateBody(DataToCellConverter converter, List<Patient> patients) throws Exception {
        LinkedList<List<DataSection>> allSections = new LinkedList<List<DataSection>>();
        for (Patient patient : patients) {
            if (patient == null) continue;
            LinkedList<DataSection> patientSections = new LinkedList<DataSection>();
            patientSections.add(converter.idBody(patient));
            patientSections.add(converter.documentInfoBody(patient));
            patientSections.add(converter.patientInfoBody(patient));
            patientSections.add(converter.familyHistoryBody(patient));
            patientSections.add(converter.prenatalPerinatalHistoryBody(patient));
            patientSections.add(converter.prenatalPhenotypeBody(patient));
            patientSections.add(converter.medicalHistoryBody(patient));
            patientSections.add(converter.isNormalBody(patient));
            patientSections.add(converter.phenotypeBody(patient));
            patientSections.add(converter.genesBody(patient));
            patientSections.add(converter.variantsBody(patient));
            patientSections.add(converter.geneticNotesBody(patient));
            patientSections.add(converter.clinicalDiagnosisBody(patient));
            patientSections.add(converter.disordersBody(patient));
            patientSections.add(converter.diagnosisNotesBody(patient));
            patientSections.add(converter.isSolvedBody(patient));
            Iterator it = patientSections.iterator();
            while (it.hasNext()) {
                DataSection i = (DataSection)it.next();
                if (i != null) continue;
                it.remove();
            }
            allSections.add(patientSections);
        }
        return allSections;
    }

    private List<DataSection> generateHeader(DataToCellConverter converter, Set<String> enabledFields) throws Exception {
        LinkedList<DataSection> headerSections = new LinkedList<DataSection>();
        headerSections.add(converter.idHeader(enabledFields));
        headerSections.add(converter.documentInfoHeader(enabledFields));
        headerSections.add(converter.patientInfoHeader(enabledFields));
        headerSections.add(converter.familyHistoryHeader(enabledFields));
        headerSections.add(converter.prenatalPerinatalHistoryHeader(enabledFields));
        headerSections.add(converter.prenatalPhenotypeHeader());
        headerSections.add(converter.medicalHistoryHeader(enabledFields));
        headerSections.add(converter.isNormalHeader(enabledFields));
        headerSections.add(converter.phenotypeHeader());
        headerSections.add(converter.genesHeader());
        headerSections.add(converter.variantsHeader());
        headerSections.add(converter.geneticNotesHeader(enabledFields));
        headerSections.add(converter.clinicalDiagnosisHeaders(enabledFields));
        headerSections.add(converter.disordersHeaders(enabledFields));
        headerSections.add(converter.diagnosisNotesHeader(enabledFields));
        headerSections.add(converter.isSolvedHeader(enabledFields));
        Iterator it = headerSections.iterator();
        while (it.hasNext()) {
            DataSection i = (DataSection)it.next();
            if (i != null) continue;
            it.remove();
        }
        return headerSections;
    }

    private DataSection assembleSectionsX(List<DataSection> sections, Boolean finalize) throws Exception {
        DataSection combinedSection = new DataSection();
        Integer offset = 0;
        for (DataSection section : sections) {
            Set<DataCell> cells = section.getCellList();
            for (DataCell cell : cells) {
                cell.setX(cell.getX() + offset);
                combinedSection.addCell(cell);
            }
            offset = offset + section.getMaxX() + 1;
        }
        if (finalize.booleanValue()) {
            combinedSection.finalizeToMatrix();
        }
        return combinedSection;
    }

    private DataSection assembleSectionsY(List<DataSection> sections, Boolean finalize) throws Exception {
        DataSection combinedSection = new DataSection();
        Integer offset = 0;
        for (DataSection section : sections) {
            Set<DataCell> cells = section.getCellList();
            for (DataCell cell : cells) {
                cell.setY(cell.getY() + offset);
                combinedSection.addCell(cell);
            }
            offset = offset + (section.getMaxY() + 1);
        }
        if (finalize.booleanValue()) {
            combinedSection.finalizeToMatrix();
        }
        return combinedSection;
    }

    public DataSection getAssembled() {
        return this.oneSection;
    }

    public Integer getHeaderHeight() {
        return this.headerHeight;
    }
}

