/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.script;

import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.phenotips.data.Patient;
import org.phenotips.export.internal.SpreadsheetExporter;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Unstable
@Component
@Named(value="spreadsheetexport")
@Singleton
public class SpreadsheetExportService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> referenceResolver;

    public void export(List<Patient> patients, String[] enabledFields, OutputStream outputStream) {
        SpreadsheetExporter exporter = new SpreadsheetExporter();
        try {
            exporter.export(enabledFields, patients, outputStream);
        }
        catch (Exception ex) {
            this.logger.error("Error caught while generating an export spreadsheet", (Throwable)ex);
        }
    }
}

