/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.phenotips.export.internal.DataCell;

public class DataSection {
    private Set<DataCell> cellList = new LinkedHashSet<DataCell>();
    private DataCell[][] matrix;
    private Integer matrixX = 0;
    private Integer matrixY = 0;
    private Integer maxX = 0;
    private Integer maxY = 0;

    public void addCell(DataCell cell) {
        if (this.matrix != null && cell.getX() < this.matrixX && cell.getY() < this.matrixY && this.matrix[cell.getX()][cell.getY()] == null) {
            this.matrix[cell.getX().intValue()][cell.getY().intValue()] = cell;
        }
        if (cell.getX() > this.maxX) {
            this.maxX = cell.getX();
        }
        if (cell.getY() > this.maxY) {
            this.maxY = cell.getY();
        }
        this.cellList.add(cell);
    }

    public void finalizeToMatrix() throws Exception {
        if (this.maxX == null || this.maxY == null) {
            throw new Exception("The maximum values should be initialized");
        }
        this.matrixX = this.maxX + 1;
        this.matrixY = this.maxY + 1;
        this.matrix = new DataCell[this.matrixX.intValue()][this.matrixY.intValue()];
        Iterator<DataCell> i$ = this.cellList.iterator();
        while (i$.hasNext()) {
            DataCell cell;
            this.matrix[cell.getX().intValue()][cell.getY().intValue()] = cell = i$.next();
            Iterator<DataCell> i$2 = cell.generateMergedCells().iterator();
            while (i$2.hasNext()) {
                DataCell emptyCell;
                this.matrix[emptyCell.getX().intValue()][emptyCell.getY().intValue()] = emptyCell = i$2.next();
            }
        }
    }

    public void mergeX() throws Exception {
        if (this.matrix == null) {
            throw new Exception("The section has not been converted to a matrix");
        }
        Integer y = 0;
        while (y <= this.getMaxY()) {
            Integer n;
            Integer x = 0;
            while (x <= this.getMaxX()) {
                DataCell cell = this.matrix[x][y];
                if (cell != null) {
                    Integer nextX = x + 1;
                    while (nextX <= this.getMaxX() && this.matrix[nextX][y] == null) {
                        cell.addMergeX();
                        Integer n2 = nextX;
                        Integer n3 = nextX = Integer.valueOf(nextX + 1);
                    }
                }
                n = x;
                Integer n4 = x = Integer.valueOf(x + 1);
            }
            Integer n5 = y;
            n = y = Integer.valueOf(y + 1);
        }
    }

    public Set<DataCell> getCellList() {
        return this.cellList;
    }

    public DataCell[][] getMatrix() {
        return this.matrix;
    }

    public Integer getMaxX() {
        return this.maxX;
    }

    public Integer getMaxY() {
        return this.maxY;
    }
}

