/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.data.Feature;
import org.phenotips.export.internal.DataCell;
import org.phenotips.tools.PhenotypeMappingService;
import org.phenotips.vocabulary.Vocabulary;
import org.phenotips.vocabulary.VocabularyTerm;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.script.service.ScriptService;

public class ConversionHelpers {
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String NA = "N/A";
    private Boolean positive;
    private Boolean negative;
    private Vocabulary ontologyService;
    private Map<String, List<String>> categoryMapping;
    private Map<String, String> sectionFeatureTree;

    public void newPatient() {
        this.sectionFeatureTree = new HashMap<String, String>();
    }

    public void featureSetUp(Boolean positive, Boolean negative, Boolean mapCategories) throws Exception {
        this.positive = positive;
        this.negative = negative;
        if (!mapCategories.booleanValue()) {
            return;
        }
        ComponentManager cm = this.getComponentManager();
        this.ontologyService = (Vocabulary)cm.getInstance(Vocabulary.class, "hpo");
        PhenotypeMappingService mappingService = (PhenotypeMappingService)cm.getInstance(ScriptService.class, "phenotypeMapping");
        Object mappingObject = mappingService.get("phenotype");
        if (mappingObject instanceof List) {
            List mapping = (List)mappingObject;
            this.categoryMapping = new LinkedHashMap<String, List<String>>();
            for (Map categoryEntry : mapping) {
                this.categoryMapping.put(((List)categoryEntry.get("title")).toString(), (List<String>)categoryEntry.get("categories"));
            }
        } else {
            throw new Exception("The phenotype category list is not available");
        }
    }

    protected ComponentManager getComponentManager() {
        return ComponentManagerRegistry.getContextComponentManager();
    }

    private List<Feature> filterFeaturesByPresentStatus(Set<? extends Feature> features, Boolean status) {
        LinkedList<Feature> filteredFeatures = new LinkedList<Feature>();
        boolean include = status != false ? this.positive : this.negative;
        if (include) {
            for (Feature feature : features) {
                if (feature.isPresent() != status.booleanValue()) continue;
                filteredFeatures.add(0, feature);
            }
        }
        return filteredFeatures;
    }

    public List<Feature> sortFeaturesSimple(Set<? extends Feature> features) {
        List<Feature> positiveList = this.filterFeaturesByPresentStatus(features, true);
        List<Feature> negativeList = this.filterFeaturesByPresentStatus(features, false);
        positiveList.addAll(negativeList);
        return positiveList;
    }

    public List<Feature> sortFeaturesWithSections(Set<? extends Feature> features) {
        List<Feature> positiveList = this.sortFeaturesBySection(this.filterFeaturesByPresentStatus(features, true));
        List<Feature> negativeList = this.sortFeaturesBySection(this.filterFeaturesByPresentStatus(features, false));
        positiveList.addAll(negativeList);
        return positiveList;
    }

    private List<Feature> sortFeaturesBySection(List<Feature> features) {
        LinkedList<Feature> sortedFeatures = new LinkedList<Feature>();
        Map<String, List<String>> mapping = this.getCategoryMapping();
        for (String section : mapping.keySet()) {
            if (features.isEmpty()) break;
            for (String category : mapping.get(section)) {
                HashSet<Feature> toRemove = new HashSet<Feature>();
                for (Feature feature : features) {
                    if (!this.getCategoriesFromOntology(feature.getId()).contains(category) && !StringUtils.equals((CharSequence)feature.getId(), (CharSequence)category)) continue;
                    this.sectionFeatureTree.put(feature.getId(), section);
                    sortedFeatures.add(feature);
                    toRemove.add(feature);
                }
                for (Feature feature : toRemove) {
                    features.remove(feature);
                }
            }
        }
        for (Feature feature : features) {
            this.sectionFeatureTree.put(feature.getId(), "No category");
        }
        sortedFeatures.addAll(features);
        return sortedFeatures;
    }

    public Set<Feature> filterFeaturesByPrenatal(Set<? extends Feature> features, Boolean prenatal) {
        HashSet<Feature> filtered = new HashSet<Feature>();
        for (Feature feature : features) {
            if (StringUtils.equals((CharSequence)feature.getType(), (CharSequence)"prenatal_phenotype") != prenatal) continue;
            filtered.add(feature);
        }
        return filtered;
    }

    private List<String> getCategoriesFromOntology(String value) {
        if (!value.startsWith("HP:")) {
            return Collections.emptyList();
        }
        VocabularyTerm termObj = this.ontologyService.getTerm(value);
        if (termObj != null && termObj.get("term_category") != null && List.class.isAssignableFrom(termObj.get("term_category").getClass())) {
            return (List)termObj.get("term_category");
        }
        return new LinkedList<String>();
    }

    public Map<String, List<String>> getCategoryMapping() {
        return this.categoryMapping;
    }

    public Map<String, String> getSectionFeatureTree() {
        return this.sectionFeatureTree;
    }

    public static String strIntegerToStrBool(String strInt) {
        if (StringUtils.equals((CharSequence)"0", (CharSequence)strInt)) {
            return NO;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)strInt)) {
            return YES;
        }
        if (StringUtils.equals((CharSequence)"", (CharSequence)strInt)) {
            return "";
        }
        return NA;
    }

    public static String integerToStrBool(Integer integer) {
        if (integer == null) {
            return "";
        }
        if (integer == 0) {
            return NO;
        }
        if (integer == 1) {
            return YES;
        }
        return NA;
    }

    public static List<DataCell> preventOverflow(String value, int x, int y) {
        int maxSize = 32000;
        LinkedList<DataCell> processed = new LinkedList<DataCell>();
        if (value == null || value.length() < 32000) {
            processed.add(new DataCell(value, x, y));
        } else {
            int iY = y;
            LinkedList<String> chunks = new LinkedList<String>();
            ConversionHelpers.determineSplit(value, 32000, chunks);
            for (String chunk : chunks) {
                processed.add(new DataCell(chunk, x, iY));
                ++iY;
            }
        }
        return processed;
    }

    private static void determineSplit(String value, int chunkSizeLimit, List<String> holder) {
        int tailSize = 1000;
        String newline = "\n";
        String period = ".";
        int chunkEndIndex = -1;
        boolean foundBreakIndex = false;
        String chunkTail = value.substring(chunkSizeLimit - 1000, chunkSizeLimit);
        if (chunkTail.contains("\n")) {
            chunkEndIndex = chunkTail.lastIndexOf("\n");
            foundBreakIndex = chunkEndIndex >= 0;
            chunkEndIndex += "\n".length();
        } else if (chunkTail.contains(".")) {
            chunkEndIndex = chunkTail.lastIndexOf(".");
            foundBreakIndex = chunkEndIndex >= 0;
            chunkEndIndex += ".".length();
        } else {
            chunkEndIndex = chunkTail.lastIndexOf(" ");
            foundBreakIndex = chunkEndIndex >= 0;
            ++chunkEndIndex;
        }
        chunkEndIndex = foundBreakIndex ? chunkEndIndex : 1000;
        int chunkSize = chunkSizeLimit - 1000 + chunkEndIndex;
        String chunk = value.substring(0, chunkSize);
        String chunkOverflow = value.substring(chunkSize);
        holder.add(chunk.trim());
        if (chunkOverflow.length() > chunkSizeLimit) {
            ConversionHelpers.determineSplit(chunkOverflow, chunkSizeLimit, holder);
        } else {
            holder.add(chunkOverflow.trim());
        }
    }
}

