/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.phenotips.data.Disorder;
import org.phenotips.data.Feature;
import org.phenotips.data.FeatureMetadatum;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientData;
import org.phenotips.export.internal.ConversionHelpers;
import org.phenotips.export.internal.DataCell;
import org.phenotips.export.internal.DataSection;
import org.phenotips.export.internal.StyleOption;
import org.phenotips.vocabulary.internal.solr.SolrVocabularyTerm;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.model.reference.DocumentReference;

public class DataToCellConverter {
    private static final String ALLERGIES = "allergies";
    private Map<String, Set<String>> enabledHeaderIdsBySection = new HashMap<String, Set<String>>();
    private ConversionHelpers phenotypeHelper;
    private ConversionHelpers prenatalPhenotypeHelper;
    public static final Integer charactersPerLine = 100;

    public void phenotypeSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "phenotype";
        String[] fieldIds = new String[]{"phenotype", "phenotype_code", "phenotype_combined", "phenotype_code_meta", "phenotype_meta", "negative_phenotype", "negative_phenotype_code", "negative_phenotype_combined", "phenotype_by_section"};
        String[][] headerIds = new String[][]{{"phenotype", "positive"}, {"code", "positive"}, {"phenotype", "code", "positive"}, {"meta_code", "phenotype", "positive"}, {"meta", "phenotype", "positive"}, {"negative", "phenotype"}, {"negative", "code"}, {"negative", "code", "phenotype"}, {"category"}};
        HashSet<String> present = new HashSet<String>();
        int counter = 0;
        for (String fieldId : fieldIds) {
            if (enabledFields.remove(fieldId)) {
                for (String headerId : headerIds[counter]) {
                    present.add(headerId);
                }
            }
            ++counter;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        this.phenotypeHelper = new ConversionHelpers();
        this.phenotypeHelper.featureSetUp(present.contains("positive"), present.contains("negative"), present.contains("category"));
    }

    public DataSection phenotypeHeader() throws Exception {
        String sectionName = "phenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        LinkedList<String> orderedHeaderIds = new LinkedList<String>();
        orderedHeaderIds.add("category");
        orderedHeaderIds.add("phenotype");
        orderedHeaderIds.add("code");
        orderedHeaderIds.add("meta");
        orderedHeaderIds.add("meta_code");
        LinkedList<String> orderedHeaderNames = new LinkedList<String>();
        orderedHeaderNames.add("Category");
        orderedHeaderNames.add("Label");
        orderedHeaderNames.add("ID");
        orderedHeaderNames.add("Meta");
        orderedHeaderNames.add("ID");
        int counter = 0;
        int hX = 0;
        if (present.contains("positive") && present.contains("negative")) {
            DataCell cell = new DataCell("Present", hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
        }
        for (String headerId : orderedHeaderIds) {
            if (!present.contains(headerId)) {
                ++counter;
                continue;
            }
            DataCell cell = new DataCell((String)orderedHeaderNames.get(counter), hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
            ++counter;
        }
        DataCell sectionHeader = new DataCell("Phenotype", 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection phenotypeBody(Patient patient) throws Exception {
        DataCell cell;
        List<Feature> sortedFeatures;
        String sectionName = "phenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        Boolean bothTypes = present.contains("positive") && present.contains("negative");
        DataSection section = new DataSection();
        int y = 0;
        Set features = patient.getFeatures();
        this.phenotypeHelper.newPatient();
        Boolean categoriesEnabled = present.contains("category");
        Map<Object, Object> sectionFeatureLookup = new HashMap();
        if (!categoriesEnabled.booleanValue()) {
            sortedFeatures = this.phenotypeHelper.sortFeaturesSimple(features);
        } else {
            sortedFeatures = this.phenotypeHelper.sortFeaturesWithSections(features);
            sectionFeatureLookup = this.phenotypeHelper.getSectionFeatureTree();
        }
        Boolean lastStatus = false;
        String lastSection = "";
        for (Feature feature : sortedFeatures) {
            DataCell cell2;
            int x = 0;
            if (bothTypes.booleanValue() && lastStatus.booleanValue() != feature.isPresent()) {
                lastStatus = feature.isPresent();
                lastSection = "";
                cell2 = new DataCell(lastStatus != false ? "Yes" : "No", x, y);
                if (!lastStatus.booleanValue()) {
                    cell2.addStyle(StyleOption.YES_NO_SEPARATOR);
                }
                cell2.addStyle(lastStatus != false ? StyleOption.YES : StyleOption.NO);
                section.addCell(cell2);
            }
            if (bothTypes.booleanValue()) {
                ++x;
            }
            if (categoriesEnabled.booleanValue()) {
                String currentSection = (String)sectionFeatureLookup.get(feature.getId());
                if (!StringUtils.equals((CharSequence)currentSection, (CharSequence)lastSection)) {
                    cell = new DataCell(currentSection, x, y);
                    section.addCell(cell);
                    lastSection = currentSection;
                }
                ++x;
            }
            if (present.contains("phenotype")) {
                cell2 = new DataCell(feature.getName(), x, y, StyleOption.FEATURE_SEPARATOR);
                section.addCell(cell2);
                ++x;
            }
            if (present.contains("code")) {
                cell2 = new DataCell(feature.getId(), x, y, StyleOption.FEATURE_SEPARATOR);
                section.addCell(cell2);
                ++x;
            }
            if (present.contains("meta") || present.contains("meta_code")) {
                int mX = x;
                Collection featureMetadatum = feature.getMetadata().values();
                Boolean metaPresent = featureMetadatum.size() > 0;
                int offset = 0;
                for (FeatureMetadatum meta : featureMetadatum) {
                    DataCell cell3;
                    offset = 0;
                    if (present.contains("meta")) {
                        cell3 = new DataCell(meta.getName(), mX + offset, y);
                        section.addCell(cell3);
                        ++offset;
                    }
                    if (present.contains("meta_code")) {
                        cell3 = new DataCell(meta.getId(), mX + offset, y);
                        section.addCell(cell3);
                        ++offset;
                    }
                    ++y;
                }
                offset = 0;
                if (!metaPresent.booleanValue()) {
                    DataCell cell4;
                    if (present.contains("meta")) {
                        cell4 = new DataCell("", mX + offset, y);
                        section.addCell(cell4);
                        ++offset;
                    }
                    if (present.contains("meta_code")) {
                        cell4 = new DataCell("", mX + offset, y);
                        section.addCell(cell4);
                        ++offset;
                    }
                }
                if (metaPresent.booleanValue()) {
                    --y;
                }
            }
            ++y;
        }
        if (sortedFeatures.size() == 0) {
            int offset = bothTypes != false ? 1 : 0;
            Integer emptyX = 0;
            for (int i = 0; i < present.size() - offset; ++i) {
                cell = new DataCell("", emptyX, 0);
                section.addCell(cell);
                Integer n = emptyX;
                Integer n2 = emptyX = Integer.valueOf(emptyX + 1);
            }
        }
        return section;
    }

    public void genesSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "genes";
        String[] fieldIds = new String[]{"genes", "genes_comments", "rejectedGenes", "rejectedGenes_comments"};
        String[][] headerIds = new String[][]{{"candidate"}, {"comments", "candidate"}, {"rejected"}, {"rejected_comments", "rejected"}};
        HashSet<String> present = new HashSet<String>();
        int counter = 0;
        for (String fieldId : fieldIds) {
            if (enabledFields.remove(fieldId)) {
                for (String headerId : headerIds[counter]) {
                    present.add(headerId);
                }
            }
            ++counter;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
    }

    public DataSection genesHeader() throws Exception {
        String sectionName = "genes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int hX = 0;
        DataCell cell = new DataCell("Status", hX, 1, StyleOption.HEADER);
        section.addCell(cell);
        cell = new DataCell("Gene Name", ++hX, 1, StyleOption.HEADER);
        section.addCell(cell);
        ++hX;
        if (present.contains("comments") || present.contains("rejected_comments")) {
            cell = new DataCell("Comments", hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
        }
        DataCell sectionHeader = new DataCell("Genotype", 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection genesBody(Patient patient) throws Exception {
        PatientData rejectedGenes;
        String comment;
        String geneName;
        DataCell cell;
        PatientData candidateGenes;
        String sectionName = "genes";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        boolean hasGenes = false;
        DataSection section = new DataSection();
        int y = 0;
        if (present.contains("candidate") && (candidateGenes = patient.getData("genes")) != null && candidateGenes.isIndexed()) {
            cell = new DataCell("Candidate", 0, y);
            section.addCell(cell);
            for (Map candidateGene : candidateGenes) {
                hasGenes = true;
                geneName = (String)candidateGene.get("gene");
                cell = new DataCell(geneName, 1, y);
                section.addCell(cell);
                if (present.contains("comments")) {
                    comment = (String)candidateGene.get("comments");
                    cell = new DataCell(comment, 2, y);
                    section.addCell(cell);
                }
                ++y;
            }
        }
        if (present.contains("rejected") && (rejectedGenes = patient.getData("rejectedGenes")) != null && rejectedGenes.isIndexed()) {
            cell = new DataCell("Previously tested", 0, y, StyleOption.YES_NO_SEPARATOR);
            cell.addStyle(StyleOption.NO);
            section.addCell(cell);
            for (Map rejectedGene : rejectedGenes) {
                hasGenes = true;
                geneName = (String)rejectedGene.get("gene");
                cell = new DataCell(geneName, 1, y);
                section.addCell(cell);
                if (present.contains("rejected_comments")) {
                    comment = (String)rejectedGene.get("comments");
                    cell = new DataCell(comment, 2, y);
                    section.addCell(cell);
                }
                ++y;
            }
        }
        if (!hasGenes) {
            int columns = present.contains("comments") || present.contains("rejected_comments") ? 3 : 2;
            Integer emptyX = 0;
            for (int i = 0; i < columns; ++i) {
                DataCell cell2 = new DataCell("", emptyX, 0);
                section.addCell(cell2);
                Integer n = emptyX;
                Integer n2 = emptyX = Integer.valueOf(emptyX + 1);
            }
        }
        return section;
    }

    public DataSection idHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "id";
        HashSet<String> present = new HashSet<String>();
        if (enabledFields.remove("doc.name")) {
            present.add("id");
        }
        if (enabledFields.remove("external_id")) {
            present.add("external_id");
        }
        if (present.size() == 0) {
            return null;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection section = new DataSection();
        DataCell topCell = new DataCell("Identifiers", 0, 0, StyleOption.HEADER);
        topCell.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(topCell);
        int x = 0;
        if (present.contains("id")) {
            DataCell idCell = new DataCell("Report ID", x, 1, StyleOption.HEADER);
            section.addCell(idCell);
            ++x;
        }
        if (present.contains("external_id")) {
            DataCell externalIdCell = new DataCell("Patient Identifier", x, 1, StyleOption.HEADER);
            section.addCell(externalIdCell);
        }
        return section;
    }

    public DataSection idBody(Patient patient) throws Exception {
        DataCell cell;
        String sectionName = "id";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        int x = 0;
        if (present.contains("id")) {
            cell = new DataCell(patient.getId(), x, 0);
            section.addCell(cell);
            ++x;
        }
        if (present.contains("external_id")) {
            cell = new DataCell(patient.getExternalId(), x, 0);
            section.addCell(cell);
        }
        return section;
    }

    public DataSection documentInfoHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "documentInfo";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("referrer", "Referrer");
        fieldToHeaderMap.put("creationDate", "Creation date");
        fieldToHeaderMap.put("author", "Last modified by");
        fieldToHeaderMap.put("date", "Last modification date");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell = new DataCell((String)fieldToHeaderMap.get(fieldId), x, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        DataCell headerCell = new DataCell("Report Information", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection documentInfoBody(Patient patient) throws Exception {
        Integer n;
        Object cell;
        SimpleDateFormat format;
        Integer n2;
        DataCell cell2;
        DocumentAccessBridge dab = (DocumentAccessBridge)Utils.getComponent(DocumentAccessBridge.class);
        XWikiDocument patientDoc = (XWikiDocument)dab.getDocument(patient.getDocument());
        String sectionName = "documentInfo";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Integer x = 0;
        if (present.contains("referrer")) {
            String creator = this.getUsername(patientDoc.getCreatorReference());
            cell2 = new DataCell(creator, x, 0);
            bodySection.addCell(cell2);
            Integer n3 = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("creationDate")) {
            format = new SimpleDateFormat("yyyy.MM.dd");
            Date creationDate = patientDoc.getCreationDate();
            cell = new DataCell(format.format(creationDate), x, 0);
            bodySection.addCell((DataCell)cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("author")) {
            String lastModifiedBy = this.getUsername(patientDoc.getAuthorReference());
            cell2 = new DataCell(lastModifiedBy, x, 0);
            bodySection.addCell(cell2);
            cell = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("date")) {
            format = new SimpleDateFormat("yyyy.MM.dd");
            Date modificationDate = patientDoc.getDate();
            cell = new DataCell(format.format(modificationDate), x, 0);
            bodySection.addCell((DataCell)cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection patientInfoHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "patientInfo";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("first_name", "First Name");
        fieldToHeaderMap.put("last_name", "Last Name");
        fieldToHeaderMap.put("date_of_birth", "Date of birth");
        fieldToHeaderMap.put("gender", "Sex");
        fieldToHeaderMap.put("indication_for_referral", "Indication for referral");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell = new DataCell((String)fieldToHeaderMap.get(fieldId), x, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        DataCell headerCell = new DataCell("Patient Information", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection patientInfoBody(Patient patient) {
        Serializable format;
        Integer n;
        Integer n2;
        DataCell cell;
        String sectionName = "patientInfo";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Integer x = 0;
        if (present.contains("first_name")) {
            String firstName = (String)patient.getData("patientName").get("first_name");
            cell = new DataCell(firstName, x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("last_name")) {
            String lastName = (String)patient.getData("patientName").get("last_name");
            cell = new DataCell(lastName, x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("date_of_birth")) {
            Date dob = (Date)patient.getData("dates").get("date_of_birth");
            if (dob != null) {
                format = new SimpleDateFormat("yyyy.MM.dd");
                cell = new DataCell(format.format(dob), x, 0);
            } else {
                cell = new DataCell("", x, 0);
            }
            bodySection.addCell(cell);
            format = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("gender")) {
            String sex = (String)patient.getData("sex").getValue();
            cell = new DataCell(sex, x, 0);
            bodySection.addCell(cell);
            format = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("indication_for_referral")) {
            String indicationForReferral = (String)patient.getData("notes").get("indication_for_referral");
            for (DataCell cell2 : ConversionHelpers.preventOverflow(indicationForReferral, x, 0)) {
                cell2.setMultiline();
                bodySection.addCell(cell2);
            }
            Integer n3 = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection familyHistoryHeader(Set<String> enabledFields) throws Exception {
        DataCell headerCell;
        String sectionName = "familyHistory";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("global_mode_of_inheritance", "Mode of inheritance");
        fieldToHeaderMap.put("miscarriages", "3+ miscarriages");
        fieldToHeaderMap.put("consanguinity", "Consanguinity");
        fieldToHeaderMap.put("family_history", "Family conditions");
        fieldToHeaderMap.put("maternal_ethnicity", "Maternal");
        fieldToHeaderMap.put("paternal_ethnicity", "Paternal");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        if (present.isEmpty()) {
            return null;
        }
        DataSection headerSection = new DataSection();
        int bottomY = 1;
        int ethnicityOffset = 0;
        if (present.contains("maternal_ethnicity") || present.contains("paternal_ethnicity")) {
            bottomY = 2;
            ethnicityOffset = fieldToHeaderMap.containsKey("maternal_ethnicity") && fieldToHeaderMap.containsKey("paternal_ethnicity") ? 2 : 1;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell2 = new DataCell((String)fieldToHeaderMap.get(fieldId), x, bottomY, StyleOption.HEADER);
            headerSection.addCell(headerCell2);
            ++x;
        }
        if (ethnicityOffset > 0) {
            headerCell = new DataCell("Ethnicity", x - ethnicityOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        headerCell = new DataCell("Family History", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection familyHistoryBody(Patient patient) {
        DataCell cell;
        String sectionName = "familyHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData familyHistory = patient.getData("familyHistory");
        PatientData ethnicities = patient.getData("ethnicity");
        Integer x = 0;
        if (present.contains("global_mode_of_inheritance")) {
            Object term22;
            PatientData globalControllers = patient.getData("global-qualifiers");
            List modeTermList = globalControllers != null ? (List)globalControllers.get("global_mode_of_inheritance") : null;
            int y = 0;
            if (modeTermList != null && !modeTermList.isEmpty()) {
                for (Object term22 : modeTermList) {
                    String mode = term22 != null ? term22.getName() : "";
                    DataCell cell4 = new DataCell(mode, x, y);
                    bodySection.addCell(cell4);
                    ++y;
                }
            } else {
                DataCell dataCell = new DataCell("", x, y);
                bodySection.addCell(dataCell);
            }
            Integer n = x;
            x = x + 1;
            term22 = x;
        }
        if (present.contains("miscarriages")) {
            Integer miscarriages = (Integer)familyHistory.get("miscarriages");
            DataCell cell2 = new DataCell(ConversionHelpers.integerToStrBool(miscarriages), x, 0);
            bodySection.addCell(cell2);
            Integer y = x;
            Integer n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("consanguinity")) {
            Integer consanguinity = (Integer)familyHistory.get("consanguinity");
            DataCell cell2 = new DataCell(ConversionHelpers.integerToStrBool(consanguinity), x, 0);
            bodySection.addCell(cell2);
            Integer y = x;
            Integer n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("family_history")) {
            PatientData notes = patient.getData("notes");
            String familyConditions = notes != null ? (String)notes.get("family_history") : "";
            for (DataCell dataCell : ConversionHelpers.preventOverflow(familyConditions, x, 0)) {
                dataCell.setMultiline();
                bodySection.addCell(dataCell);
            }
            Integer i$ = x;
            Integer n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("maternal_ethnicity")) {
            Object cell5;
            List maternalEthnicity = (List)ethnicities.get("maternal_ethnicity");
            int y = 0;
            if (maternalEthnicity != null && !maternalEthnicity.isEmpty()) {
                for (String string : maternalEthnicity) {
                    cell = new DataCell(string, x, y);
                    bodySection.addCell(cell);
                    ++y;
                }
            } else {
                cell5 = new DataCell("", x, y);
                bodySection.addCell((DataCell)cell5);
            }
            cell5 = x;
            Integer n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("paternal_ethnicity")) {
            List paternalEthnicity = (List)ethnicities.get("paternal_ethnicity");
            int y = 0;
            if (paternalEthnicity != null && !paternalEthnicity.isEmpty()) {
                for (String string : paternalEthnicity) {
                    cell = new DataCell(string, x, y);
                    bodySection.addCell(cell);
                    ++y;
                }
            } else {
                DataCell cell6 = new DataCell("", x, y);
                bodySection.addCell(cell6);
            }
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection prenatalPerinatalHistoryHeader(Set<String> enabledFields) throws Exception {
        DataCell headerCell;
        String sectionName = "prenatalPerinatalHistory";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("gestation", "Gestation at delivery");
        fieldToHeaderMap.put("prenatal_development", "Notes");
        fieldToHeaderMap.put("assistedReproduction_fertilityMeds", "Fertility medication");
        fieldToHeaderMap.put("ivf", "In vitro fertilization");
        fieldToHeaderMap.put("icsi", "Intra-cytoplasmic sperm injection");
        fieldToHeaderMap.put("assistedReproduction_surrogacy", "Surrogacy");
        fieldToHeaderMap.put("assistedReproduction_donorsperm", "Donor sperm");
        fieldToHeaderMap.put("assistedReproduction_donoregg", "Donor egg");
        fieldToHeaderMap.put("apgar1", "1 min");
        fieldToHeaderMap.put("apgar5", "5 min");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        if (present.isEmpty()) {
            return null;
        }
        DataSection headerSection = new DataSection();
        LinkedList<String> apgarFields = new LinkedList<String>(Arrays.asList("apgar1", "apgar2"));
        LinkedList<String> assitedReproductionFields = new LinkedList<String>(Arrays.asList("ivf", "icsi", "assistedReproduction_surrogacy", "assistedReproduction_fertilityMeds", "assistedReproduction_donoregg", "assistedReproduction_donorsperm"));
        apgarFields.retainAll(present);
        assitedReproductionFields.retainAll(present);
        int apgarOffset = apgarFields.size();
        int assistedReproductionOffset = apgarOffset + assitedReproductionFields.size();
        int bottomY = apgarOffset > 0 || assistedReproductionOffset > 0 ? 2 : 1;
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell2 = new DataCell((String)fieldToHeaderMap.get(fieldId), x, bottomY, StyleOption.HEADER);
            headerSection.addCell(headerCell2);
            ++x;
        }
        if (apgarOffset > 0) {
            headerCell = new DataCell("APGAR Score", x - apgarOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        if (assistedReproductionOffset > 0) {
            headerCell = new DataCell("Assisted Reproduction", x - assistedReproductionOffset, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
        }
        headerCell = new DataCell("Prenatal and Perinatal History", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection prenatalPerinatalHistoryBody(Patient patient) {
        Integer n;
        DataCell cell;
        String cellValue;
        Object apgar;
        Integer assisted;
        Object i$;
        Integer n2;
        DataCell cell2;
        String sectionName = "prenatalPerinatalHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData history = patient.getData("prenatalPerinatalHistory");
        PatientData apgarScores = patient.getData("apgar");
        Integer x = 0;
        if (present.contains("gestation")) {
            Integer gestation = (Integer)history.get("gestation");
            cell2 = new DataCell(gestation != null ? gestation.toString() : "", x, 0);
            bodySection.addCell(cell2);
            Integer n3 = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("prenatal_development")) {
            PatientData notes = patient.getData("notes");
            String prenatalNotes = notes != null ? (String)notes.get("prenatal_development") : "";
            for (DataCell cell3 : ConversionHelpers.preventOverflow(prenatalNotes, x, 0)) {
                cell3.setMultiline();
                bodySection.addCell(cell3);
            }
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("assistedReproduction_fertilityMeds")) {
            assisted = (Integer)history.get("assistedReproduction_fertilityMeds");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("ivf")) {
            assisted = (Integer)history.get("ivf");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("icsi")) {
            assisted = (Integer)history.get("icsi");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("assistedReproduction_surrogacy")) {
            assisted = (Integer)history.get("assistedReproduction_surrogacy");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("assistedReproduction_donoregg")) {
            assisted = (Integer)history.get("assistedReproduction_donoregg");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("assistedReproduction_donorsperm")) {
            assisted = (Integer)history.get("assistedReproduction_donorsperm");
            cell2 = new DataCell(ConversionHelpers.integerToStrBool(assisted), x, 0);
            bodySection.addCell(cell2);
            i$ = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("apgar1")) {
            apgar = apgarScores.get("apgar1");
            cellValue = apgar != null ? apgar.toString() : "";
            cell = new DataCell(cellValue, x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("apgar5")) {
            apgar = apgarScores.get("apgar5");
            cellValue = apgar != null ? apgar.toString() : "";
            cell = new DataCell(cellValue, x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public void prenatalPhenotypeSetup(Set<String> enabledFields) throws Exception {
        String sectionName = "prenatalPhenotype";
        String[] fieldIds = new String[]{"prenatal_phenotype", "prenatal_phenotype_code", "prenatal_phenotype_combined", "negative_prenatal_phenotype", "prenatal_phenotype_by_section"};
        String[][] headerIds = new String[][]{{"phenotype"}, {"code"}, {"phenotype", "code"}, {"negative"}, {"category"}};
        HashSet<String> present = new HashSet<String>();
        int counter = 0;
        for (String fieldId : fieldIds) {
            if (enabledFields.remove(fieldId)) {
                for (String headerId : headerIds[counter]) {
                    present.add(headerId);
                }
            }
            ++counter;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        this.prenatalPhenotypeHelper = new ConversionHelpers();
        this.prenatalPhenotypeHelper.featureSetUp(present.contains("phenotype"), present.contains("negative"), present.contains("category"));
    }

    public DataSection prenatalPhenotypeHeader() throws Exception {
        String sectionName = "prenatalPhenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present.isEmpty()) {
            return null;
        }
        DataSection section = new DataSection();
        LinkedList<String> orderedHeaderIds = new LinkedList<String>();
        orderedHeaderIds.add("category");
        orderedHeaderIds.add("phenotype");
        orderedHeaderIds.add("code");
        orderedHeaderIds.add("meta");
        orderedHeaderIds.add("meta_code");
        LinkedList<String> orderedHeaderNames = new LinkedList<String>();
        orderedHeaderNames.add("Category");
        orderedHeaderNames.add("Label");
        orderedHeaderNames.add("ID");
        orderedHeaderNames.add("Meta");
        orderedHeaderNames.add("ID");
        int counter = 0;
        int hX = 0;
        if (present.contains("phenotype") && present.contains("negative")) {
            DataCell cell = new DataCell("Present", hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
        }
        for (String headerId : orderedHeaderIds) {
            if (!present.contains(headerId)) {
                ++counter;
                continue;
            }
            DataCell cell = new DataCell((String)orderedHeaderNames.get(counter), hX, 1, StyleOption.HEADER);
            section.addCell(cell);
            ++hX;
            ++counter;
        }
        DataCell sectionHeader = new DataCell("Prenatal Phenotype", 0, 0, StyleOption.HEADER);
        sectionHeader.addStyle(StyleOption.LARGE_HEADER);
        section.addCell(sectionHeader);
        return section;
    }

    public DataSection prenatalPhenotypeBody(Patient patient) throws Exception {
        List<Feature> sortedFeatures;
        String sectionName = "prenatalPhenotype";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        Boolean bothTypes = present.contains("phenotype") && present.contains("negative");
        DataSection section = new DataSection();
        int y = 0;
        Set<Feature> features = patient.getFeatures();
        this.prenatalPhenotypeHelper.newPatient();
        features = this.prenatalPhenotypeHelper.filterFeaturesByPrenatal((Set<? extends Feature>)features, true);
        Boolean categoriesEnabled = present.contains("category");
        Map<Object, Object> sectionFeatureLookup = new HashMap();
        if (!categoriesEnabled.booleanValue()) {
            sortedFeatures = this.prenatalPhenotypeHelper.sortFeaturesSimple(features);
        } else {
            sortedFeatures = this.prenatalPhenotypeHelper.sortFeaturesWithSections(features);
            sectionFeatureLookup = this.prenatalPhenotypeHelper.getSectionFeatureTree();
        }
        Boolean lastStatus = false;
        String lastSection = "";
        for (Feature feature : sortedFeatures) {
            DataCell cell;
            int x = 0;
            if (bothTypes.booleanValue() && lastStatus.booleanValue() != feature.isPresent()) {
                lastStatus = feature.isPresent();
                lastSection = "";
                cell = new DataCell(lastStatus != false ? "Yes" : "No", x, y);
                if (!lastStatus.booleanValue()) {
                    cell.addStyle(StyleOption.YES_NO_SEPARATOR);
                }
                cell.addStyle(lastStatus != false ? StyleOption.YES : StyleOption.NO);
                section.addCell(cell);
            }
            if (bothTypes.booleanValue()) {
                ++x;
            }
            if (categoriesEnabled.booleanValue()) {
                String currentSection = (String)sectionFeatureLookup.get(feature.getId());
                if (!StringUtils.equals((CharSequence)currentSection, (CharSequence)lastSection)) {
                    DataCell cell2 = new DataCell(currentSection, x, y);
                    section.addCell(cell2);
                    lastSection = currentSection;
                }
                ++x;
            }
            if (present.contains("phenotype")) {
                cell = new DataCell(feature.getName(), x, y, StyleOption.FEATURE_SEPARATOR);
                section.addCell(cell);
                ++x;
            }
            if (present.contains("code")) {
                cell = new DataCell(feature.getId(), x, y, StyleOption.FEATURE_SEPARATOR);
                section.addCell(cell);
                ++x;
            }
            ++y;
        }
        if (sortedFeatures.size() == 0) {
            for (int i = 0; i < present.size(); ++i) {
                DataCell cell = new DataCell("", i, 0);
                section.addCell(cell);
            }
        }
        return section;
    }

    public DataSection disordersHeaders(Set<String> enabledFields) throws Exception {
        String sectionName = "disorders";
        String[] fieldIds = new String[]{"omim_id", "omim_id_code", "omim_id_combined", "diagnosis_notes"};
        String[][] headerIds = new String[][]{{"disorder"}, {"code"}, {"disorder", "code"}, {"notes"}};
        HashSet<String> present = new HashSet<String>();
        int counter = 0;
        for (String fieldId : fieldIds) {
            if (enabledFields.remove(fieldId)) {
                for (String headerId : headerIds[counter]) {
                    present.add(headerId);
                }
            }
            ++counter;
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("disorder", "Label");
        fieldToHeaderMap.put("code", "ID");
        fieldToHeaderMap.put("notes", "Notes");
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell = new DataCell((String)fieldToHeaderMap.get(fieldId), x, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        DataCell headerCell = new DataCell("Disorders", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection disordersBody(Patient patient) {
        Integer x;
        String sectionName = "disorders";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Set disorders = patient.getDisorders();
        Integer y = 0;
        for (Disorder disorder : disorders) {
            Integer n;
            Integer n2;
            x = 0;
            if (present.contains("disorder")) {
                DataCell dataCell = new DataCell(disorder.getName(), x, y);
                dataCell.setMultiline();
                bodySection.addCell(dataCell);
                n2 = x;
                n = x = Integer.valueOf(x + 1);
            }
            if (present.contains("code")) {
                DataCell dataCell = new DataCell(disorder.getId(), x, y);
                bodySection.addCell(dataCell);
                n2 = x;
                n = x = Integer.valueOf(x + 1);
            }
            Integer n3 = y;
            n2 = y = Integer.valueOf(y + 1);
        }
        if (disorders.size() == 0) {
            Integer x2 = 0;
            if (present.contains("disorder")) {
                DataCell cell2 = new DataCell("", x2, y);
                bodySection.addCell(cell2);
                x = x2;
                Integer n = x2 = Integer.valueOf(x2 + 1);
            }
            if (present.contains("code")) {
                DataCell cell = new DataCell("", x2, y);
                bodySection.addCell(cell);
                x = x2;
                Integer n = x2 = Integer.valueOf(x2 + 1);
            }
        }
        if (present.contains("notes")) {
            PatientData notes = patient.getData("notes");
            String diagnosisNotes = notes != null ? (String)notes.get("diagnosis_notes") : "";
            for (DataCell dataCell : ConversionHelpers.preventOverflow(diagnosisNotes, bodySection.getMaxX() + 1, 0)) {
                dataCell.setMultiline();
                bodySection.addCell(dataCell);
            }
        }
        return bodySection;
    }

    public DataSection medicalHistoryHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "medicalHistory";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put(ALLERGIES, "Allergies");
        fieldToHeaderMap.put("global_age_of_onset", "Age of onset");
        fieldToHeaderMap.put("medical_history", "Notes");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell = new DataCell((String)fieldToHeaderMap.get(fieldId), x, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        DataCell headerCell = new DataCell("Medical History", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection medicalHistoryBody(Patient patient) {
        String sectionName = "medicalHistory";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        Integer x = 0;
        if (present.contains(ALLERGIES)) {
            PatientData allergiesData = patient.getData(ALLERGIES);
            int y = 0;
            if (allergiesData != null && allergiesData.isIndexed()) {
                for (String n2 : allergiesData) {
                    DataCell cell = new DataCell(n2, x, y);
                    if ("NKDA".equals(n2)) {
                        cell.addStyle(StyleOption.YES);
                    }
                    bodySection.addCell(cell);
                    ++y;
                }
            }
            Integer i$ = x;
            Integer n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("global_age_of_onset")) {
            PatientData qualifiers = patient.getData("global-qualifiers");
            List ageOfOnsetList = qualifiers != null ? (List)qualifiers.get("global_age_of_onset") : null;
            int y = 0;
            if (ageOfOnsetList != null && !ageOfOnsetList.isEmpty()) {
                for (SolrVocabularyTerm term : ageOfOnsetList) {
                    String onset = term != null ? term.getName() : "";
                    DataCell cell2 = new DataCell(onset, x, y);
                    bodySection.addCell(cell2);
                    ++y;
                }
            } else {
                DataCell dataCell = new DataCell("", x, y);
                bodySection.addCell(dataCell);
            }
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
        }
        if (present.contains("medical_history")) {
            PatientData notes = patient.getData("notes");
            String medicalNotes = notes != null ? (String)notes.get("medical_history") : "";
            for (DataCell dataCell : ConversionHelpers.preventOverflow(medicalNotes, x, 0)) {
                dataCell.setMultiline();
                bodySection.addCell(dataCell);
            }
            Integer n = x;
            Integer n3 = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    public DataSection isNormalHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "isNormal";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("unaffected", "Clinically normal");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        DataCell headerCell = new DataCell("Clinically Normal", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection isNormalBody(Patient patient) {
        String sectionName = "isNormal";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        if (present.contains("unaffected")) {
            PatientData isNormal = patient.getData("isClinicallyNormal");
            Integer isNormalValue = isNormal != null ? (Integer)isNormal.get("unaffected") : 0;
            DataCell cell = new DataCell(ConversionHelpers.integerToStrBool(isNormalValue), 0, 0);
            bodySection.addCell(cell);
        }
        return bodySection;
    }

    public DataSection isSolvedHeader(Set<String> enabledFields) throws Exception {
        String sectionName = "isSolved";
        LinkedHashMap<String, String> fieldToHeaderMap = new LinkedHashMap<String, String>();
        fieldToHeaderMap.put("solved", "Solved");
        fieldToHeaderMap.put("solved__pubmed_id", "PubMed ID");
        fieldToHeaderMap.put("solved__gene_id", "Gene ID");
        fieldToHeaderMap.put("solved__notes", "Notes");
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (String fieldId : fieldToHeaderMap.keySet()) {
            if (!enabledFields.remove(fieldId)) continue;
            present.add(fieldId);
        }
        this.enabledHeaderIdsBySection.put(sectionName, present);
        DataSection headerSection = new DataSection();
        if (present.isEmpty()) {
            return null;
        }
        int x = 0;
        for (String fieldId : present) {
            DataCell headerCell = new DataCell((String)fieldToHeaderMap.get(fieldId), x, 1, StyleOption.HEADER);
            headerSection.addCell(headerCell);
            ++x;
        }
        DataCell headerCell = new DataCell("Solved Status", 0, 0, StyleOption.LARGE_HEADER);
        headerCell.addStyle(StyleOption.HEADER);
        headerSection.addCell(headerCell);
        return headerSection;
    }

    public DataSection isSolvedBody(Patient patient) {
        Integer n;
        Integer n2;
        DataCell cell;
        String sectionName = "isSolved";
        Set<String> present = this.enabledHeaderIdsBySection.get(sectionName);
        if (present == null || present.isEmpty()) {
            return null;
        }
        DataSection bodySection = new DataSection();
        PatientData patientData = patient.getData("solved");
        Integer x = 0;
        if (present.contains("solved")) {
            String solved = patientData != null ? (String)patientData.get("solved") : null;
            cell = new DataCell(solved != null ? ConversionHelpers.strIntegerToStrBool(solved) : "", x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("solved__pubmed_id")) {
            String pubmedId = patientData != null ? (String)patientData.get("solved__pubmed_id") : null;
            cell = new DataCell(pubmedId != null ? pubmedId : "", x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("solved__gene_id")) {
            String geneId = patientData != null ? (String)patientData.get("solved__gene_id") : null;
            cell = new DataCell(geneId != null ? geneId : "", x, 0);
            bodySection.addCell(cell);
            n2 = x;
            n = x = Integer.valueOf(x + 1);
        }
        if (present.contains("solved__notes")) {
            String solvedNotes = patientData != null ? (String)patientData.get("solved__notes") : null;
            for (DataCell cell2 : ConversionHelpers.preventOverflow(solvedNotes, x, 0)) {
                cell2.setMultiline();
                bodySection.addCell(cell2);
            }
            Integer n3 = x;
            n2 = x = Integer.valueOf(x + 1);
        }
        return bodySection;
    }

    private String getUsername(DocumentReference reference) {
        if (reference == null) {
            return "Unknown user";
        }
        return reference.getName();
    }
}

