/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.export.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.phenotips.export.internal.StyleOption;

public class DataCell {
    private String value;
    private Set<StyleOption> styles;
    private Integer x;
    private Integer y;
    private Integer mergeX;
    private Boolean isChild;
    private Set<DataCell> generated;
    private Integer numberOfLines;

    public DataCell(String value, Integer x, Integer y) {
        this.value = value != null ? value : "";
        this.x = x;
        this.y = y;
    }

    public DataCell(String value, Integer x, Integer y, StyleOption style) {
        this.value = value != null ? value : "";
        this.x = x;
        this.y = y;
        this.addStyle(style);
    }

    public void addStyle(StyleOption style) {
        if (this.styles == null) {
            this.styles = new HashSet<StyleOption>();
        }
        this.styles.add(style);
        if (this.generated != null) {
            for (DataCell child : this.generated) {
                child.addStyle(style);
            }
        }
    }

    public void addStyles(Collection<StyleOption> styles) {
        if (styles == null) {
            return;
        }
        if (this.styles == null) {
            this.styles = new HashSet<StyleOption>();
        }
        this.styles.addAll(styles);
        if (this.generated != null) {
            for (DataCell child : this.generated) {
                child.addStyles(styles);
            }
        }
    }

    public void removeStyles(Collection<StyleOption> styles) {
        if (this.styles != null) {
            this.styles.removeAll(styles);
        }
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getMergeX() {
        return this.mergeX;
    }

    public void addMergeX() {
        if (this.mergeX == null) {
            this.mergeX = 0;
        }
        DataCell dataCell = this;
        Integer n = dataCell.mergeX;
        Integer n2 = dataCell.mergeX = Integer.valueOf(dataCell.mergeX + 1);
    }

    public Set<DataCell> generateMergedCells() {
        if (this.mergeX == null) {
            return Collections.emptySet();
        }
        if (this.generated != null) {
            return this.generated;
        }
        this.generated = new HashSet<DataCell>();
        for (int gx = 1; gx <= this.mergeX; ++gx) {
            DataCell cell = new DataCell("", this.x + gx, this.getY());
            cell.setIsChild(true);
            cell.addStyles(this.styles);
            this.generated.add(cell);
        }
        return this.generated;
    }

    public Set<StyleOption> getStyles() {
        return this.styles;
    }

    public Boolean isChild() {
        if (this.isChild == null || !this.isChild.booleanValue()) {
            return false;
        }
        return true;
    }

    public void setIsChild(Boolean isChild) {
        this.isChild = isChild;
    }

    public void setMultiline() {
        this.numberOfLines = this.value.split("\n").length;
    }

    public Integer getNumberOfLines() {
        return this.numberOfLines;
    }
}

