/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.receive.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.XWikiRequest;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.phenotips.configuration.RecordConfigurationManager;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientRepository;
import org.phenotips.data.internal.PhenoTipsPatient;
import org.phenotips.data.permissions.PermissionsManager;
import org.phenotips.data.receive.ReceivePatientData;
import org.phenotips.data.securestorage.LocalLoginToken;
import org.phenotips.data.securestorage.SecureStorageManager;
import org.phenotips.groups.Group;
import org.phenotips.groups.GroupManager;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.users.User;
import org.xwiki.users.UserManager;

@Component
@Singleton
public class DefaultReceivePatientData
implements ReceivePatientData {
    private static final int DEFAULT_USER_TOKEN_LIFETIME = 7;
    private static final boolean DEFAULT_USER_TOKENS_ENABLED = true;
    private static final String MAIN_CONFIG_ALLOW_ANY_SOURCE_PROPERTY_NAME = "AllowPushesFromNonListedServers";
    private static final String SERVER_CONFIG_IP_PROPERTY_NAME = "ip";
    private static final String SERVER_CONFIG_SERVER_NAME_PROPERTY_NAME = "name";
    private static final String SERVER_CONFIG_USER_TOKEN_EXPIRE_PROPERTY_NAME = "user_token_life_in_days";
    private SecureRandom secureRandomGenerator = new SecureRandom();
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private PatientRepository patientRepository;
    @Inject
    private RecordConfigurationManager configurationManager;
    @Inject
    private GroupManager groupManager;
    @Inject
    private UserManager userManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> stringResolver;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private SecureStorageManager storageManager;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    @Inject
    private PermissionsManager permisionManager;

    @Override
    public boolean isServerTrusted() {
        XWikiContext context = this.getXContext();
        BaseObject mainConfig = this.getMainConfiguration(context);
        if (mainConfig == null) {
            this.logger.error("Receive configuration not found");
            return false;
        }
        if (mainConfig.getIntValue(MAIN_CONFIG_ALLOW_ANY_SOURCE_PROPERTY_NAME) == 1) {
            return true;
        }
        BaseObject serverConfig = this.getSourceServerConfiguration(context.getRequest().getRemoteAddr(), context);
        if (serverConfig == null) {
            this.logger.error("Connection from an untrusted server {}", (Object)context.getRequest().getRemoteAddr());
            return false;
        }
        return true;
    }

    @Override
    public JSONObject untrustedServerResponse() {
        return this.generateFailedLoginResponse("unauthorized_server");
    }

    @Override
    public JSONObject unsupportedeActionResponse() {
        return this.generateFailedActionResponse("unsupported_action");
    }

    protected JSONObject generateFailedLoginResponse() {
        return this.generateFailedLoginResponse(null);
    }

    protected JSONObject generateFailedLoginResponse(String jsonKeyToSet) {
        JSONObject response = this.generateFailureResponse();
        response.element("login_failed", true);
        if (jsonKeyToSet != null) {
            response.element(jsonKeyToSet, true);
        }
        return response;
    }

    protected JSONObject generateFailedCredentialsResponse() {
        return this.generateFailedCredentialsResponse(null);
    }

    protected JSONObject generateFailedCredentialsResponse(String jsonKeyToSet) {
        JSONObject response = this.generateFailedLoginResponse("incorrect_credentials");
        if (jsonKeyToSet != null) {
            response.element(jsonKeyToSet, true);
        }
        return response;
    }

    protected JSONObject generateFailedActionResponse() {
        return this.generateFailedActionResponse(null);
    }

    protected JSONObject generateFailedActionResponse(String jsonKeyToSet) {
        JSONObject response = this.generateFailureResponse();
        response.element("action_failed", true);
        if (jsonKeyToSet != null) {
            response.element(jsonKeyToSet, true);
        }
        return response;
    }

    protected XWikiDocument getPatientDocument(Patient patient) throws Exception {
        return (XWikiDocument)this.bridge.getDocument(patient.getDocument());
    }

    protected String getPatientGUID(Patient patient) {
        try {
            XWikiDocument doc = this.getPatientDocument(patient);
            String guid = doc.getXObject(Patient.CLASS_REFERENCE).getGuid();
            return guid;
        }
        catch (Exception ex) {
            this.logger.error("Failed to get patient GUID: [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    protected String getPatientURL(Patient patient, XWikiContext context) {
        try {
            XWikiDocument doc = this.getPatientDocument(patient);
            String url = doc.getURL("view", context);
            return url;
        }
        catch (Exception ex) {
            this.logger.error("Failed to get patient URL: [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    protected JSONObject generateSuccessfulResponseWithPatientIDs(Patient patient, XWikiContext context) {
        try {
            String guid = this.getPatientGUID(patient);
            String url = this.getPatientURL(patient, context);
            String id = patient.getDocument().getName();
            JSONObject response = this.generateSuccessfulResponse();
            response.element("patient_guid", (Object)guid);
            response.element("patient_id", (Object)id);
            response.element("patient_url", (Object)url);
            return response;
        }
        catch (Exception ex) {
            this.logger.error("Failed to get patient GUID/ID/URL: [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return this.generateFailedActionResponse();
        }
    }

    protected JSONObject generateSuccessfulResponse() {
        JSONObject response = this.generateEmptyResponse();
        response.element("success", true);
        return response;
    }

    protected JSONObject generateFailureResponse() {
        JSONObject response = this.generateEmptyResponse();
        response.element("success", false);
        return response;
    }

    protected JSONObject generateEmptyResponse() {
        JSONObject response = new JSONObject();
        response.element("response_protocol_version", (Object)"1");
        return response;
    }

    protected boolean isValidUserGroup(String userName, String groupName) {
        Set userGroups = this.groupManager.getGroupsForUser(this.userManager.getUser(userName));
        for (Group group : userGroups) {
            if (!group.getReference().getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    protected String generateNewToken(String userName) {
        this.logger.warn("generating new token for user {}", (Object)userName);
        return new BigInteger(256, this.secureRandomGenerator).toString(32);
    }

    protected TokenStatus checkUserToken(String userName, String serverName, String token, long tokenLifeTimeInDays) {
        if (token == null) {
            return TokenStatus.INVALID;
        }
        LocalLoginToken storedToken = this.storageManager.getLocalLoginToken(userName, serverName);
        if (storedToken == null) {
            return TokenStatus.INVALID;
        }
        if (!token.equals(storedToken.getLoginToken())) {
            this.logger.warn("Stored token does not match provided token");
            return TokenStatus.INVALID;
        }
        if (tokenLifeTimeInDays != 0L && storedToken.getTokenAgeInDays() > tokenLifeTimeInDays) {
            this.logger.warn("Stored token has expired");
            return TokenStatus.EXPIRED;
        }
        return TokenStatus.VALID;
    }

    protected String getRemoteServerName(BaseObject serverConfig, XWikiRequest request) {
        if (serverConfig == null) {
            return request.getRemoteAddr();
        }
        return serverConfig.getStringValue(SERVER_CONFIG_SERVER_NAME_PROPERTY_NAME);
    }

    protected long getUserTokenLifetime(BaseObject serverConfig) {
        if (serverConfig == null) {
            return 7L;
        }
        return serverConfig.getLongValue(SERVER_CONFIG_USER_TOKEN_EXPIRE_PROPERTY_NAME);
    }

    protected boolean userTokensEnabled(BaseObject serverConfig) {
        return true;
    }

    protected JSONObject validateLogin(XWikiRequest request, XWikiContext context) {
        try {
            String userName = request.getParameter("username");
            String token = request.getParameter("user_login_token");
            if (userName == null) {
                return this.generateFailedCredentialsResponse();
            }
            if (token == null) {
                String password = request.getParameter("password");
                if (context.getWiki().getAuthService().authenticate(userName, password, context) == null) {
                    return this.generateFailedCredentialsResponse();
                }
            } else {
                long tokenLifeTime;
                BaseObject serverConfig = this.getSourceServerConfiguration(request.getRemoteAddr(), context);
                if (!this.userTokensEnabled(serverConfig)) {
                    this.logger.warn("user token provided by [{}] but tokens are disabled", (Object)userName);
                    return this.generateFailedCredentialsResponse("user_tokens_not_supported");
                }
                String serverName = this.getRemoteServerName(serverConfig, request);
                TokenStatus tokenStatus = this.checkUserToken(userName, serverName, token, tokenLifeTime = this.getUserTokenLifetime(serverConfig));
                if (tokenStatus == TokenStatus.INVALID) {
                    return this.generateFailedCredentialsResponse();
                }
                if (tokenStatus == TokenStatus.EXPIRED) {
                    return this.generateFailedCredentialsResponse("user_token_expired");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error during remote login [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return this.generateFailedLoginResponse();
        }
        return null;
    }

    @Override
    public JSONObject receivePatient() {
        try {
            Patient affectedPatient;
            XWikiContext context = this.getXContext();
            XWikiRequest request = context.getRequest();
            this.logger.warn("Push patient request from remote [{}]", (Object)request.getRemoteAddr());
            JSONObject loginError = this.validateLogin(request, context);
            if (loginError != null) {
                return loginError;
            }
            String userName = request.getParameter("username");
            String groupName = request.getParameter("groupname");
            if (groupName != null && !this.isValidUserGroup(userName, groupName)) {
                this.logger.warn("Incorrect group");
                return this.generateFailedActionResponse("incorrect_user_group");
            }
            String patientJSONRaw = context.getRequest().getParameter("patient_json");
            if (patientJSONRaw == null) {
                this.logger.error("No patient data provided by {})", (Object)request.getRemoteAddr());
                return this.generateFailedActionResponse();
            }
            String patientJSON = URLDecoder.decode(patientJSONRaw, "UTF-8");
            String guid = request.getParameter("patient_guid");
            if (guid != null) {
                affectedPatient = this.getPatientByGUID(guid);
                if (affectedPatient == null) {
                    return this.generateFailedActionResponse("incorrect_guid");
                }
                if (!this.userCanAccessPatient(userName, affectedPatient)) {
                    return this.generateFailedActionResponse("guid_access_denied");
                }
                this.logger.warn("Loaded existing patient [{}] successfully", (Object)affectedPatient.getDocument().getName());
            } else {
                User user = this.userManager.getUser(userName);
                affectedPatient = this.patientRepository.createNewPatient(user.getProfileDocument());
                XWikiDocument doc = this.getPatientDocument(affectedPatient);
                doc.setAuthorReference(user.getProfileDocument());
                if (groupName != null) {
                    Group group = this.groupManager.getGroup(groupName);
                    this.permisionManager.getPatientAccess(affectedPatient).setOwner((EntityReference)group.getReference());
                    this.permisionManager.getPatientAccess(affectedPatient).addCollaborator((EntityReference)user.getProfileDocument(), this.permisionManager.resolveAccessLevel("manage"));
                } else {
                    this.permisionManager.getPatientAccess(affectedPatient).setOwner((EntityReference)user.getProfileDocument());
                }
                if (affectedPatient == null) {
                    this.logger.error("Can not create new patient");
                    return this.generateFailedActionResponse();
                }
                this.logger.warn("Created new patient successfully");
            }
            JSONObject patientData = JSONObject.fromObject((Object)patientJSON);
            affectedPatient.updateFromJSON(patientData);
            this.logger.warn("Updated patient successfully");
            BaseObject serverConfig = this.getSourceServerConfiguration(request.getRemoteAddr(), context);
            String sourceServerName = this.getRemoteServerName(serverConfig, request);
            String patientGUID = this.getPatientGUID(affectedPatient);
            this.storageManager.storePatientSourceServerInfo(patientGUID, sourceServerName);
            return this.generateSuccessfulResponseWithPatientIDs(affectedPatient, context);
        }
        catch (Exception ex) {
            this.logger.error("Error importing patient [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return this.generateFailedActionResponse();
        }
    }

    @Override
    public JSONObject getConfiguration() {
        try {
            XWikiContext context = this.getXContext();
            XWikiRequest request = context.getRequest();
            this.logger.warn("Get config request from remote [{}]", (Object)request.getRemoteAddr());
            JSONObject loginError = this.validateLogin(request, context);
            if (loginError != null) {
                return loginError;
            }
            String userName = request.getParameter("username");
            Set userGroups = this.groupManager.getGroupsForUser(this.userManager.getUser(userName));
            JSONArray groupList = new JSONArray();
            for (Group g : userGroups) {
                groupList.add((Object)g.getReference().getName());
            }
            List acceptedFields = this.configurationManager.getActiveConfiguration().getEnabledNonIdentifiableFieldNames();
            JSONObject response = this.generateSuccessfulResponse();
            response.element("user_groups", (Collection)groupList);
            response.element("accepted_fields", (Collection)acceptedFields);
            response.element("updates_enabled", true);
            BaseObject serverConfig = this.getSourceServerConfiguration(request.getRemoteAddr(), context);
            if (this.userTokensEnabled(serverConfig)) {
                String token = request.getParameter("user_login_token");
                if (token == null) {
                    token = this.generateNewToken(userName);
                }
                String serverName = this.getRemoteServerName(serverConfig, request);
                this.logger.warn("Remote server name: [{}]", (Object)serverName);
                this.storageManager.storeLocalLoginToken(userName, serverName, token);
                response.element("user_login_token", (Object)token);
            }
            return response;
        }
        catch (Exception ex) {
            this.logger.error("Unable to perform getConfig [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return this.generateFailedActionResponse();
        }
    }

    @Override
    public JSONObject getPatientURL() {
        try {
            XWikiContext context = this.getXContext();
            XWikiRequest request = context.getRequest();
            this.logger.warn("Get patient URL request from remote [{}]", (Object)request.getRemoteAddr());
            JSONObject loginError = this.validateLogin(request, context);
            if (loginError != null) {
                return loginError;
            }
            String userName = request.getParameter("username");
            String guid = request.getParameter("patient_guid");
            if (userName == null || guid == null) {
                return this.generateFailedActionResponse();
            }
            Patient patient = this.getPatientByGUID(guid);
            if (patient == null) {
                return this.generateFailedActionResponse("incorrect_guid");
            }
            if (!this.userCanAccessPatient(userName, patient)) {
                return this.generateFailedActionResponse("guid_access_denied");
            }
            return this.generateSuccessfulResponseWithPatientIDs(patient, context);
        }
        catch (Exception ex) {
            this.logger.error("Unable to process URL request [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return this.generateFailedActionResponse();
        }
    }

    protected Patient getPatientByGUID(String guid) {
        try {
            Query q = this.queryManager.createQuery("from doc.object(PhenoTips.PatientClass) as o where o.guid = :guid", "xwql").bindValue("guid", (Object)guid);
            List results = q.execute();
            if (results.size() == 1) {
                DocumentReference reference = this.stringResolver.resolve(results.get(0), new Object[]{Patient.DEFAULT_DATA_SPACE});
                return new PhenoTipsPatient((XWikiDocument)this.bridge.getDocument(reference));
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get patient with GUID [{}]: [{}] {}", new Object[]{guid, ex.getMessage(), ex});
        }
        return null;
    }

    private boolean userCanAccessPatient(String userName, Patient patient) {
        try {
            XWikiDocument doc = (XWikiDocument)this.bridge.getDocument(patient.getDocument());
            if (!(doc.getCreatorReference() != null && doc.getCreatorReference().getName().equals(userName) || doc.getAuthorReference() != null && doc.getAuthorReference().getName().equals(userName))) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private BaseObject getSourceServerConfiguration(String serverIP, XWikiContext context) {
        try {
            XWiki xwiki = context.getWiki();
            XWikiDocument prefsDoc = xwiki.getDocument(new DocumentReference(context.getDatabase(), "XWiki", "XWikiPreferences"), context);
            BaseObject result = prefsDoc.getXObject(new DocumentReference(context.getDatabase(), "PhenoTips", "ReceivePatientServer"), SERVER_CONFIG_IP_PROPERTY_NAME, serverIP);
            if (result != null) {
                return result;
            }
            String domainName = InetAddress.getByName(serverIP).getHostName();
            return prefsDoc.getXObject(new DocumentReference(context.getDatabase(), "PhenoTips", "ReceivePatientServer"), SERVER_CONFIG_IP_PROPERTY_NAME, domainName);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get server info: [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    private BaseObject getMainConfiguration(XWikiContext context) {
        try {
            XWiki xwiki = context.getWiki();
            XWikiDocument prefsDoc = xwiki.getDocument(new DocumentReference(context.getDatabase(), "XWiki", "XWikiPreferences"), context);
            BaseObject result = prefsDoc.getXObject(new DocumentReference(context.getDatabase(), "PhenoTips", "ReceivePatientSettings"));
            if (result != null) {
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get server info: [{}] {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    protected static enum TokenStatus {
        VALID,
        EXPIRED,
        INVALID;

    }
}

