/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.phenotips.data.Patient;
import org.phenotips.data.push.PushPatientService;
import org.phenotips.security.audit.AuditEvent;
import org.phenotips.security.audit.spi.AuditEventProcessor;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="push-info")
@Singleton
public class PushAuditEventProcessor
implements AuditEventProcessor {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private PushPatientService pushService;

    public AuditEvent process(AuditEvent event) {
        DocumentReference originalEntity = event.getEntity();
        XWikiRequest request = ((XWikiContext)this.xcontextProvider.get()).getRequest();
        if ("PushPatientService".equals(originalEntity.getName()) && "PhenoTips".equals(originalEntity.getParent().getName()) && "push".equals(request.getParameter("do"))) {
            String pushedEntityName = request.getParameter("patientid");
            DocumentReference pushedEntity = this.resolver.resolve((Object)pushedEntityName, new Object[]{Patient.DEFAULT_DATA_SPACE});
            JSONObject extraInfo = new JSONObject();
            String serverId = request.getParameter("serverid");
            extraInfo.put("server", (Object)serverId);
            extraInfo.put("group", (Object)request.getParameter("groupname"));
            extraInfo.put("fields", (Object)request.getParameter("fields"));
            String remoteUser = request.getParameter("usr");
            if (StringUtils.isEmpty((CharSequence)remoteUser)) {
                remoteUser = this.pushService.getRemoteUsername(serverId);
            }
            extraInfo.put("remoteUser", (Object)remoteUser);
            return new AuditEvent(event.getUser(), event.getIp(), "push", extraInfo.toString(), pushedEntity, event.getTime());
        }
        return event;
    }
}

