/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.configuration.RecordConfiguration;
import org.phenotips.configuration.RecordConfigurationManager;
import org.phenotips.data.push.PushServerConfigurationResponse;
import org.phenotips.data.push.internal.DefaultPushServerResponse;
import org.phenotips.data.shareprotocol.ShareProtocol;

public class DefaultPushServerConfigurationResponse
extends DefaultPushServerResponse
implements PushServerConfigurationResponse {
    private static final String PATIENT_LABEL = "patient";

    DefaultPushServerConfigurationResponse(JSONObject serverResponse) {
        super(serverResponse);
    }

    protected Set<String> getSetFromJSONList(String key) {
        JSONArray stringList = this.response.optJSONArray(key);
        if (stringList == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (Object field : stringList) {
            result.add(field.toString());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<String> getRemoteUserGroups() {
        return this.getSetFromJSONList("user_groups");
    }

    @Override
    public Set<String> getRemoteAcceptedPatientFields() {
        return this.getRemoteAcceptedPatientFields(null);
    }

    @Override
    public Set<String> getRemoteAcceptedPatientFields(String groupName) {
        Set<String> remoteAcceptedPatientFields = this.getSetFromJSONList("accepted_fields");
        String serverProtocolVersion = this.getServerProtocolVersion();
        if (remoteAcceptedPatientFields != null && !remoteAcceptedPatientFields.contains("variants") && ShareProtocol.INCOMPATIBILITIES_IN_OLD_PROTOCOL_VERSIONS.containsKey(serverProtocolVersion) && ((List)ShareProtocol.INCOMPATIBILITIES_IN_OLD_PROTOCOL_VERSIONS.get(serverProtocolVersion)).contains(ShareProtocol.GENE_STATUS_INCOMPAT) && remoteAcceptedPatientFields.contains("genes")) {
            TreeSet<String> result = new TreeSet<String>(remoteAcceptedPatientFields);
            result.add("variants");
            return Collections.unmodifiableSet(result);
        }
        return remoteAcceptedPatientFields;
    }

    @Override
    public Set<String> getPushableFields() {
        return this.getPushableFields(null);
    }

    @Override
    public Set<String> getPushableFields(String groupName) {
        try {
            Set<String> remoteAcceptedFields = this.getRemoteAcceptedPatientFields(groupName);
            if (remoteAcceptedFields == null) {
                return Collections.emptySet();
            }
            RecordConfigurationManager configurationManager = (RecordConfigurationManager)ComponentManagerRegistry.getContextComponentManager().getInstance(RecordConfigurationManager.class);
            RecordConfiguration patientConfig = configurationManager.getConfiguration(PATIENT_LABEL);
            TreeSet<String> commonFields = new TreeSet<String>(patientConfig.getEnabledFieldNames());
            commonFields.retainAll(remoteAcceptedFields);
            return commonFields;
        }
        catch (Exception ex) {
            return Collections.emptySet();
        }
    }

    @Override
    public boolean remoteUpdatesEnabled() {
        return this.hasKeySetToTrue("updates_enabled");
    }

    @Override
    public String getRemoteUserToken() {
        return this.valueOrNull("user_login_token");
    }

    @Override
    public JSONArray getConsents() {
        return this.response.optJSONArray("consents");
    }
}

