/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.phenotips.data.Patient;
import org.phenotips.data.internal.controller.VersionsController;
import org.phenotips.data.push.PushPatientData;
import org.phenotips.data.push.PushServerConfigurationResponse;
import org.phenotips.data.push.PushServerGetPatientIDResponse;
import org.phenotips.data.push.PushServerSendPatientResponse;
import org.phenotips.data.push.internal.DefaultPushServerConfigurationResponse;
import org.phenotips.data.push.internal.DefaultPushServerGetPatientIDResponse;
import org.phenotips.data.push.internal.DefaultPushServerSendPatientResponse;
import org.phenotips.data.push.internal.UnsupportedOldServerProtocolResponse;
import org.phenotips.data.shareprotocol.ShareProtocol;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultPushPatientData
implements PushPatientData {
    public static final String PUSH_SERVER_CONFIG_ID_PROPERTY_NAME = "name";
    public static final String PUSH_SERVER_CONFIG_URL_PROPERTY_NAME = "url";
    public static final String PUSH_SERVER_CONFIG_REGISTRATION_URL_PROPERTY_NAME = "registration_url";
    public static final String PUSH_SERVER_CONFIG_DESC_PROPERTY_NAME = "description";
    private static final String PATIENT_DATA_SHARING_PAGE = "/bin/receivePatientData";
    private static final String XWIKI_RAW_OUTPUT_KEY = "xpage";
    private static final String XWIKI_RAW_OUTPUT_VALUE = "plain";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private final CloseableHttpClient client = HttpClients.createSystem();
    private Map<String, String> protocolVersionsCache = new HashMap<String, String>();

    private String getBaseURL(BaseObject serverConfiguration) {
        if (serverConfiguration != null) {
            String result = serverConfiguration.getStringValue(PUSH_SERVER_CONFIG_URL_PROPERTY_NAME);
            if (StringUtils.isBlank((CharSequence)result)) {
                return null;
            }
            if (!result.startsWith("http")) {
                result = "http://" + result;
            }
            return StringUtils.stripEnd((String)result, (String)"/") + PATIENT_DATA_SHARING_PAGE;
        }
        return null;
    }

    private HttpPost generateRequest(String remoteServerIdentifier, List<NameValuePair> data) {
        BaseObject serverConfiguration = this.getPushServerConfiguration(remoteServerIdentifier);
        String submitURL = this.getBaseURL(serverConfiguration);
        if (submitURL == null) {
            return null;
        }
        this.logger.trace("POST URL: {}", (Object)submitURL);
        HttpPost method = new HttpPost(submitURL);
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(data, Consts.UTF_8));
        return method;
    }

    private List<NameValuePair> generateRequestData(String actionName, String userName, String password, String userToken, String protocolVersion) {
        LinkedList<NameValuePair> result = new LinkedList<NameValuePair>();
        result.add((NameValuePair)new BasicNameValuePair(XWIKI_RAW_OUTPUT_KEY, XWIKI_RAW_OUTPUT_VALUE));
        result.add((NameValuePair)new BasicNameValuePair("push_protocol_version", protocolVersion));
        result.add((NameValuePair)new BasicNameValuePair("action", actionName));
        result.add((NameValuePair)new BasicNameValuePair("username", userName));
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            result.add((NameValuePair)new BasicNameValuePair("user_login_token", userToken));
        } else {
            result.add((NameValuePair)new BasicNameValuePair("password", password));
        }
        return result;
    }

    private BaseObject getPushServerConfiguration(String serverName) {
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = context.getWiki();
            XWikiDocument prefsDoc = xwiki.getDocument(new DocumentReference(context.getWikiId(), "XWiki", "XWikiPreferences"), context);
            return prefsDoc.getXObject(new DocumentReference(context.getWikiId(), "PhenoTips", "PushPatientServer"), PUSH_SERVER_CONFIG_ID_PROPERTY_NAME, serverName);
        }
        catch (XWikiException ex) {
            this.logger.warn("Failed to get server info: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    @Override
    public PushServerConfigurationResponse getRemoteConfiguration(String remoteServerIdentifier, String userName, String password, String userToken) {
        PushServerConfigurationResponse serverResponse = this.sendRemoteConfigurationRequest(remoteServerIdentifier, userName, password, userToken, "1.4");
        if (serverResponse == null) {
            return null;
        }
        String serverProtocolVersion = serverResponse.getServerProtocolVersion();
        if (serverProtocolVersion == null || ShareProtocol.OLD_INCOMPATIBLE_VERSIONS.contains(serverProtocolVersion)) {
            return new UnsupportedOldServerProtocolResponse();
        }
        if (serverResponse.isServerDoesNotAcceptClientProtocolVersion() && ShareProtocol.COMPATIBLE_OLD_SERVER_PROTOCOL_VERSIONS.contains(serverProtocolVersion)) {
            serverResponse = this.sendRemoteConfigurationRequest(remoteServerIdentifier, userName, password, userToken, serverProtocolVersion);
        }
        this.protocolVersionsCache.put(remoteServerIdentifier, serverProtocolVersion);
        return serverResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PushServerConfigurationResponse sendRemoteConfigurationRequest(String remoteServerIdentifier, String userName, String password, String userToken, String useProtocolVersion) {
        this.logger.debug("===> Getting server configuration for: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerConfigurationResponse defaultPushServerConfigurationResponse;
            String response;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block32: {
                block33: {
                    block29: {
                        PushServerConfigurationResponse pushServerConfigurationResponse;
                        block30: {
                            block31: {
                                method = this.generateRequest(remoteServerIdentifier, this.generateRequestData("get_server_info", userName, password, userToken, useProtocolVersion));
                                if (method == null) {
                                    PushServerConfigurationResponse pushServerConfigurationResponse2 = null;
                                    return pushServerConfigurationResponse2;
                                }
                                httpResponse = this.client.execute((HttpUriRequest)method);
                                throwable = null;
                                int returnCode = httpResponse.getStatusLine().getStatusCode();
                                this.logger.trace("GetConfig HTTP return code: {}", (Object)returnCode);
                                response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                                this.logger.debug("===> Push server response: [{}]", (Object)response);
                                if (response.length() >= 2) break block29;
                                pushServerConfigurationResponse = null;
                                if (httpResponse == null) break block30;
                                if (throwable == null) break block31;
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block30;
                            }
                            httpResponse.close();
                        }
                        return pushServerConfigurationResponse;
                    }
                    JSONObject responseJSON = new JSONObject(response);
                    defaultPushServerConfigurationResponse = new DefaultPushServerConfigurationResponse(responseJSON);
                    if (httpResponse == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block32;
                }
                httpResponse.close();
            }
            return defaultPushServerConfigurationResponse;
            catch (Exception ex) {
                PushServerConfigurationResponse pushServerConfigurationResponse;
                block36: {
                    block34: {
                        block35: {
                            this.logger.error("Received invalid JSON reply from remote server: {}...", (Object)response.substring(0, 50));
                            pushServerConfigurationResponse = null;
                            if (httpResponse == null) break block34;
                            if (throwable == null) break block35;
                            try {
                                httpResponse.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            break block34;
                        }
                        httpResponse.close();
                    }
                    if (method == null) break block36;
                    method.releaseConnection();
                }
                return pushServerConfigurationResponse;
                {
                    catch (Throwable throwable5) {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (httpResponse != null) {
                                    if (throwable != null) {
                                        try {
                                            httpResponse.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        httpResponse.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Exception ex2) {
                            this.logger.error("Failed to login: {}", (Object)ex2.getMessage(), (Object)ex2);
                        }
                    }
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PushServerSendPatientResponse sendPatient(Patient patient, Set<String> exportFields, JSONObject patientState, String groupName, String remoteGUID, String remoteServerIdentifier, String userName, String password, String userToken) {
        this.logger.info("Pushing data to server: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerSendPatientResponse defaultPushServerSendPatientResponse;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block25: {
                block26: {
                    String serverProtocolVersion = this.getProtocolVersionForPushingToServer(remoteServerIdentifier);
                    List<NameValuePair> data = this.generateRequestData("push", userName, password, userToken, serverProtocolVersion);
                    if (exportFields != null) {
                        exportFields.add(VersionsController.getEnablingFieldName());
                    }
                    if (this.protocolVersionsCache.containsKey(remoteServerIdentifier) && ShareProtocol.INCOMPATIBILITIES_IN_OLD_PROTOCOL_VERSIONS.containsKey(serverProtocolVersion)) {
                        this.logger.warn("Using old serializers for protocol version [{}] to push data to server [{}]", (Object)serverProtocolVersion, (Object)remoteServerIdentifier);
                        List incompatibilitiesList = (List)ShareProtocol.INCOMPATIBILITIES_IN_OLD_PROTOCOL_VERSIONS.get(serverProtocolVersion);
                        for (ShareProtocol.Incompatibility incompat : incompatibilitiesList) {
                            if (!exportFields.contains(incompat.getCurrentFieldName())) continue;
                            exportFields.remove(incompat.getCurrentFieldName());
                            if (StringUtils.isEmpty((CharSequence)incompat.getDeprecatedFieldName())) continue;
                            exportFields.add(incompat.getDeprecatedFieldName());
                        }
                    }
                    String patientJSON = patient.toJSON(exportFields).toString();
                    this.logger.debug("Sending patient JSON: [{}]", (Object)patientJSON);
                    data.add((NameValuePair)new BasicNameValuePair("patient_json", URLEncoder.encode(patientJSON, "UTF-8")));
                    data.add((NameValuePair)new BasicNameValuePair("patient_state", URLEncoder.encode(patientState.toString(), "UTF-8")));
                    if (groupName != null) {
                        data.add((NameValuePair)new BasicNameValuePair("groupname", groupName));
                    }
                    if (remoteGUID != null) {
                        data.add((NameValuePair)new BasicNameValuePair("patient_guid", remoteGUID));
                    }
                    if ((method = this.generateRequest(remoteServerIdentifier, data)) == null) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    int returnCode = httpResponse.getStatusLine().getStatusCode();
                    this.logger.trace("Push HTTP return code: {}", (Object)returnCode);
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    this.logger.trace("RESPONSE FROM SERVER: {}", (Object)response);
                    JSONObject responseJSON = new JSONObject(response);
                    defaultPushServerSendPatientResponse = new DefaultPushServerSendPatientResponse(responseJSON);
                    if (httpResponse == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                httpResponse.close();
            }
            return defaultPushServerSendPatientResponse;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to push patient: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PushServerGetPatientIDResponse getPatientURL(String remoteServerIdentifier, String remoteGUID, String userName, String password, String userToken) {
        this.logger.debug("===> Contacting server: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerGetPatientIDResponse defaultPushServerGetPatientIDResponse;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block20: {
                block21: {
                    List<NameValuePair> data = this.generateRequestData("get_patient_id", userName, password, userToken, this.getProtocolVersionForPushingToServer(remoteServerIdentifier));
                    data.add((NameValuePair)new BasicNameValuePair("patient_guid", remoteGUID));
                    method = this.generateRequest(remoteServerIdentifier, data);
                    if (method == null) {
                        PushServerGetPatientIDResponse pushServerGetPatientIDResponse = null;
                        return pushServerGetPatientIDResponse;
                    }
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    int returnCode = httpResponse.getStatusLine().getStatusCode();
                    this.logger.trace("Push HTTP return code: {}", (Object)returnCode);
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    this.logger.trace("RESPONSE FROM SERVER: {}", (Object)response);
                    JSONObject responseJSON = new JSONObject(response);
                    defaultPushServerGetPatientIDResponse = new DefaultPushServerGetPatientIDResponse(responseJSON);
                    if (httpResponse == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                httpResponse.close();
            }
            return defaultPushServerGetPatientIDResponse;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to get patient URL: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    private String getProtocolVersionForPushingToServer(String remoteServerIdentifier) {
        return this.protocolVersionsCache.containsKey(remoteServerIdentifier) ? this.protocolVersionsCache.get(remoteServerIdentifier) : "1.4";
    }
}

