/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import net.sf.json.JSONObject;
import org.phenotips.data.push.PushServerResponse;

public class DefaultPushServerResponse
implements PushServerResponse {
    protected final JSONObject response;

    DefaultPushServerResponse(JSONObject serverResponse) {
        this.response = serverResponse;
    }

    public static JSONObject generateIncorrectCredentialsJSON() {
        JSONObject response = new JSONObject();
        response.element("success", false);
        response.element("login_failed", true);
        response.element("incorrect_credentials", true);
        return response;
    }

    public static JSONObject generateActionFailedJSON() {
        JSONObject response = new JSONObject();
        response.element("success", false);
        response.element("action_failed", true);
        return response;
    }

    protected boolean hasKeySetToTrue(String key) {
        return this.response.containsKey((Object)key) && this.response.getBoolean(key);
    }

    protected String valueOrNull(String key) {
        if (!this.response.containsKey((Object)key)) {
            return null;
        }
        return this.response.getString(key);
    }

    @Override
    public boolean isSuccessful() {
        return this.hasKeySetToTrue("success");
    }

    @Override
    public boolean isIncorrectProtocolVersion() {
        return this.hasKeySetToTrue("unsupported_post_protocol_version") || !this.response.containsKey((Object)"response_protocol_version");
    }

    @Override
    public boolean isLoginFailed() {
        return this.hasKeySetToTrue("login_failed");
    }

    @Override
    public boolean isActionFailed() {
        return this.hasKeySetToTrue("action_failed");
    }

    @Override
    public boolean isLoginFailed_knownReason() {
        return this.isLoginFailed_UnauthorizedServer() || this.isLoginFailed_IncorrectCredentials() || this.isLoginFailed_TokensNotSuported() || this.isLoginFailed_UserTokenExpired();
    }

    @Override
    public boolean isLoginFailed_UnauthorizedServer() {
        return this.isLoginFailed() && this.hasKeySetToTrue("unauthorized_server");
    }

    @Override
    public boolean isLoginFailed_IncorrectCredentials() {
        return this.isLoginFailed() && this.hasKeySetToTrue("incorrect_credentials");
    }

    @Override
    public boolean isLoginFailed_UserTokenExpired() {
        return this.isLoginFailed() && this.hasKeySetToTrue("user_token_expired");
    }

    @Override
    public boolean isLoginFailed_TokensNotSuported() {
        return this.isLoginFailed() && this.hasKeySetToTrue("user_tokens_not_supported");
    }

    @Override
    public boolean isActionFailed_knownReason() {
        return this.isActionFailed_isUnknownAction();
    }

    @Override
    public boolean isActionFailed_isUnknownAction() {
        return this.isActionFailed() && this.hasKeySetToTrue("unsupported_action");
    }
}

