/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.phenotips.data.Patient;
import org.phenotips.data.internal.controller.VersionsController;
import org.phenotips.data.push.PushPatientData;
import org.phenotips.data.push.PushServerConfigurationResponse;
import org.phenotips.data.push.PushServerGetPatientIDResponse;
import org.phenotips.data.push.PushServerSendPatientResponse;
import org.phenotips.data.push.internal.DefaultPushServerConfigurationResponse;
import org.phenotips.data.push.internal.DefaultPushServerGetPatientIDResponse;
import org.phenotips.data.push.internal.DefaultPushServerSendPatientResponse;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultPushPatientData
implements PushPatientData {
    public static final String PUSH_SERVER_CONFIG_ID_PROPERTY_NAME = "name";
    public static final String PUSH_SERVER_CONFIG_URL_PROPERTY_NAME = "url";
    public static final String PUSH_SERVER_CONFIG_DESC_PROPERTY_NAME = "description";
    private static final String PATIENT_DATA_SHARING_PAGE = "/bin/receivePatientData";
    private static final String XWIKI_RAW_OUTPUT_KEY = "xpage";
    private static final String XWIKI_RAW_OUTPUT_VALUE = "plain";
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    private final CloseableHttpClient client = HttpClients.createSystem();

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String getBaseURL(BaseObject serverConfiguration) {
        if (serverConfiguration != null) {
            String result = serverConfiguration.getStringValue(PUSH_SERVER_CONFIG_URL_PROPERTY_NAME);
            if (StringUtils.isBlank((CharSequence)result)) {
                return null;
            }
            if (!result.startsWith("http")) {
                result = "http://" + result;
            }
            return StringUtils.stripEnd((String)result, (String)"/") + PATIENT_DATA_SHARING_PAGE;
        }
        return null;
    }

    private HttpPost generateRequest(String remoteServerIdentifier, List<NameValuePair> data) {
        BaseObject serverConfiguration = this.getPushServerConfiguration(remoteServerIdentifier);
        String submitURL = this.getBaseURL(serverConfiguration);
        if (submitURL == null) {
            return null;
        }
        this.logger.trace("POST URL: {}", (Object)submitURL);
        HttpPost method = new HttpPost(submitURL);
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(data, Consts.UTF_8));
        return method;
    }

    private List<NameValuePair> generateRequestData(String actionName, String userName, String password, String userToken) {
        LinkedList<NameValuePair> result = new LinkedList<NameValuePair>();
        result.add((NameValuePair)new BasicNameValuePair(XWIKI_RAW_OUTPUT_KEY, XWIKI_RAW_OUTPUT_VALUE));
        result.add((NameValuePair)new BasicNameValuePair("push_protocol_version", "1"));
        result.add((NameValuePair)new BasicNameValuePair("action", actionName));
        result.add((NameValuePair)new BasicNameValuePair("username", userName));
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            result.add((NameValuePair)new BasicNameValuePair("user_login_token", userToken));
        } else {
            result.add((NameValuePair)new BasicNameValuePair("password", password));
        }
        return result;
    }

    private BaseObject getPushServerConfiguration(String serverName) {
        try {
            XWikiContext context = this.getXContext();
            XWiki xwiki = context.getWiki();
            XWikiDocument prefsDoc = xwiki.getDocument(new DocumentReference(context.getWikiId(), "XWiki", "XWikiPreferences"), context);
            return prefsDoc.getXObject(new DocumentReference(context.getWikiId(), "PhenoTips", "PushPatientServer"), PUSH_SERVER_CONFIG_ID_PROPERTY_NAME, serverName);
        }
        catch (XWikiException ex) {
            this.logger.warn("Failed to get server info: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PushServerConfigurationResponse getRemoteConfiguration(String remoteServerIdentifier, String userName, String password, String userToken) {
        this.logger.debug("===> Getting server configuration for: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerConfigurationResponse defaultPushServerConfigurationResponse;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block27: {
                block28: {
                    String response;
                    block24: {
                        PushServerConfigurationResponse pushServerConfigurationResponse;
                        block25: {
                            block26: {
                                method = this.generateRequest(remoteServerIdentifier, this.generateRequestData("get_server_info", userName, password, userToken));
                                if (method == null) {
                                    PushServerConfigurationResponse pushServerConfigurationResponse2 = null;
                                    return pushServerConfigurationResponse2;
                                }
                                httpResponse = this.client.execute((HttpUriRequest)method);
                                throwable = null;
                                int returnCode = httpResponse.getStatusLine().getStatusCode();
                                this.logger.trace("GetConfig HTTP return code: {}", (Object)returnCode);
                                response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                                if (response.length() >= 2) break block24;
                                pushServerConfigurationResponse = null;
                                if (httpResponse == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                break block25;
                            }
                            httpResponse.close();
                        }
                        return pushServerConfigurationResponse;
                    }
                    JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                    defaultPushServerConfigurationResponse = new DefaultPushServerConfigurationResponse(responseJSON);
                    if (httpResponse == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block27;
                }
                httpResponse.close();
            }
            return defaultPushServerConfigurationResponse;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to login: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PushServerSendPatientResponse sendPatient(Patient patient, Set<String> exportFields, String groupName, String remoteGUID, String remoteServerIdentifier, String userName, String password, String userToken) {
        this.logger.debug("===> Sending to server: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerSendPatientResponse defaultPushServerSendPatientResponse;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block23: {
                block24: {
                    List<NameValuePair> data = this.generateRequestData("push", userName, password, userToken);
                    if (exportFields != null) {
                        exportFields.add(VersionsController.getEnablingFieldName());
                    }
                    String patientJSON = patient.toJSON(exportFields).toString();
                    data.add((NameValuePair)new BasicNameValuePair("patient_json", URLEncoder.encode(patientJSON, "UTF-8")));
                    if (groupName != null) {
                        data.add((NameValuePair)new BasicNameValuePair("groupname", groupName));
                    }
                    if (remoteGUID != null) {
                        data.add((NameValuePair)new BasicNameValuePair("patient_guid", remoteGUID));
                    }
                    if ((method = this.generateRequest(remoteServerIdentifier, data)) == null) {
                        PushServerSendPatientResponse pushServerSendPatientResponse = null;
                        return pushServerSendPatientResponse;
                    }
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    int returnCode = httpResponse.getStatusLine().getStatusCode();
                    this.logger.trace("Push HTTP return code: {}", (Object)returnCode);
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    this.logger.trace("RESPONSE FROM SERVER: {}", (Object)response);
                    JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                    defaultPushServerSendPatientResponse = new DefaultPushServerSendPatientResponse(responseJSON);
                    if (httpResponse == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block23;
                }
                httpResponse.close();
            }
            return defaultPushServerSendPatientResponse;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to push patient: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PushServerGetPatientIDResponse getPatientURL(String remoteServerIdentifier, String remoteGUID, String userName, String password, String userToken) {
        this.logger.debug("===> Contacting server: [{}]", (Object)remoteServerIdentifier);
        HttpPost method = null;
        try {
            DefaultPushServerGetPatientIDResponse defaultPushServerGetPatientIDResponse;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block20: {
                block21: {
                    List<NameValuePair> data = this.generateRequestData("get_patient_id", userName, password, userToken);
                    data.add((NameValuePair)new BasicNameValuePair("patient_guid", remoteGUID));
                    method = this.generateRequest(remoteServerIdentifier, data);
                    if (method == null) {
                        PushServerGetPatientIDResponse pushServerGetPatientIDResponse = null;
                        return pushServerGetPatientIDResponse;
                    }
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    int returnCode = httpResponse.getStatusLine().getStatusCode();
                    this.logger.trace("Push HTTP return code: {}", (Object)returnCode);
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    this.logger.trace("RESPONSE FROM SERVER: {}", (Object)response);
                    JSONObject responseJSON = (JSONObject)JSONSerializer.toJSON((Object)response);
                    defaultPushServerGetPatientIDResponse = new DefaultPushServerGetPatientIDResponse(responseJSON);
                    if (httpResponse == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block20;
                }
                httpResponse.close();
            }
            return defaultPushServerGetPatientIDResponse;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to get patient URL: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }
}

