/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.configuration.RecordConfiguration;
import org.phenotips.configuration.RecordConfigurationManager;
import org.phenotips.data.push.PushServerConfigurationResponse;
import org.phenotips.data.push.internal.DefaultPushServerResponse;

public class DefaultPushServerConfigurationResponse
extends DefaultPushServerResponse
implements PushServerConfigurationResponse {
    DefaultPushServerConfigurationResponse(JSONObject serverResponse) {
        super(serverResponse);
    }

    protected Set<String> getSetFromJSONList(String key) {
        JSONArray stringList = this.response.optJSONArray(key);
        if (stringList == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (Object field : stringList) {
            result.add(field.toString());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<String> getRemoteUserGroups() {
        return this.getSetFromJSONList("user_groups");
    }

    @Override
    public Set<String> getRemoteAcceptedPatientFields() {
        return this.getRemoteAcceptedPatientFields(null);
    }

    @Override
    public Set<String> getRemoteAcceptedPatientFields(String groupName) {
        return this.getSetFromJSONList("accepted_fields");
    }

    @Override
    public Set<String> getPushableFields() {
        return this.getPushableFields(null);
    }

    @Override
    public Set<String> getPushableFields(String groupName) {
        try {
            Set<String> remoteAcceptedFields = this.getRemoteAcceptedPatientFields(groupName);
            if (remoteAcceptedFields == null) {
                return Collections.emptySet();
            }
            RecordConfigurationManager configurationManager = (RecordConfigurationManager)ComponentManagerRegistry.getContextComponentManager().getInstance(RecordConfigurationManager.class);
            RecordConfiguration patientConfig = configurationManager.getActiveConfiguration();
            TreeSet<String> commonFields = new TreeSet<String>(patientConfig.getEnabledNonIdentifiableFieldNames());
            commonFields.retainAll(remoteAcceptedFields);
            return commonFields;
        }
        catch (Exception ex) {
            return Collections.emptySet();
        }
    }

    @Override
    public boolean remoteUpdatesEnabled() {
        return this.hasKeySetToTrue("updates_enabled");
    }

    @Override
    public String getRemoteUserToken() {
        return this.valueOrNull("user_login_token");
    }
}

