/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import java.sql.Timestamp;
import org.phenotips.data.push.PatientPushHistory;
import org.phenotips.data.securestorage.PatientPushedToInfo;

public class DefaultPatientPushHistory
implements PatientPushHistory {
    private final Timestamp lastTimePushed;
    private final String remotePatientID;
    private final String remotePatientURL;
    private final String remotePatientGUID;

    public DefaultPatientPushHistory(PatientPushedToInfo pushInfo) {
        this.lastTimePushed = pushInfo.getLastPushTime();
        this.remotePatientGUID = pushInfo.getRemotePatientGUID();
        this.remotePatientID = pushInfo.getRemotePatientID();
        this.remotePatientURL = pushInfo.getRemotePatientURL();
    }

    public DefaultPatientPushHistory(Timestamp lastTimePushed, String remotePatientGUID, String remotePatientID, String remotePatientURL) {
        this.lastTimePushed = lastTimePushed;
        this.remotePatientGUID = remotePatientGUID;
        this.remotePatientID = remotePatientID;
        this.remotePatientURL = remotePatientURL;
    }

    @Override
    public Timestamp getLastPushTime() {
        return this.lastTimePushed;
    }

    @Override
    public long getLastPushAgeInDays() {
        long diffInMilliseconds = System.currentTimeMillis() - this.getLastPushTime().getTime();
        return diffInMilliseconds / 86400000L;
    }

    @Override
    public long getLastPushAgeInHours() {
        long diffInMilliseconds = System.currentTimeMillis() - this.getLastPushTime().getTime();
        return diffInMilliseconds / 3600000L;
    }

    @Override
    public String getRemotePatientGUID() {
        return this.remotePatientGUID;
    }

    @Override
    public String getRemotePatientID() {
        return this.remotePatientID;
    }

    @Override
    public String getRemotePatientURL() {
        return this.remotePatientURL;
    }
}

