/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.integration.medsavant.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientData;
import org.phenotips.integration.medsavant.MedSavantServer;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Singleton
public class JsonMedSavantServer
implements MedSavantServer,
Initializable {
    private static final ContentType REQUEST_CONTENT_TYPE = ContentType.create((String)ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), (Charset)Consts.UTF_8);
    private static final String ENCODING = "UTF-8";
    private static final double POLIPHEN_THRESHOLD = 0.2;
    private static final double QUALITY_THRESHOLD = 30.0;
    private static final double THOUSAND_GENOMES_THRESHOLD = 0.01;
    private static final String PROJECT_MANAGER = "ProjectManager";
    private static final String VARIANT_MANAGER = "VariantManager";
    private static final String REQUEST_PARAMETER = "json=";
    private static final List<String> IGNORED_EFFECTS = Arrays.asList("ncRNA_INTRONIC", "UPSTREAM", "DOWNSTREAM", "INTERGENIC", "UTR3", "UTR5", "SYNONYMOUS", "INTRONIC");
    @Inject
    private Logger logger;
    private final CloseableHttpClient client = HttpClients.createSystem();
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    private Integer projectID;
    private Collection<Integer> referenceIDs;
    private Map<String, String> annotationColumns = new HashMap<String, String>();

    public void initialize() throws InitializationException {
        this.projectID = this.getProjectID();
        if (this.projectID == null) {
            throw new InitializationException("Invalid project configured, please make sure MedSavant is properly running and the right project name is specified in xwiki.properties under phenotips.medsavant.projectName");
        }
        this.referenceIDs = this.getReferenceIDs();
        if (this.referenceIDs == null || this.referenceIDs.isEmpty()) {
            throw new InitializationException("Invalid project configured, no reference genomes are loaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasVCF(Patient patient) {
        HttpPost method = null;
        try {
            PatientData identifiers = patient.getData("identifiers");
            String eid = (String)identifiers.get("external_id");
            String url = this.getMethodURL(VARIANT_MANAGER, "getVariantCountForDNAIDs");
            method = new HttpPost(url);
            JSONArray parameters = new JSONArray();
            parameters.add((Object)this.projectID);
            parameters.add((Object)0);
            parameters.add((Object)new JSONArray());
            JSONArray ids = new JSONArray();
            ids.add((Object)eid);
            parameters.add((Object)ids);
            for (Integer refID : this.referenceIDs) {
                parameters.set(1, (Object)refID);
                String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
                method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
                CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);
                Throwable throwable = null;
                try {
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    Integer count = Integer.valueOf(response);
                    if (count <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (httpResponse == null) continue;
                    if (throwable != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    httpResponse.close();
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get the number of variants for patient [{}]: {}", new Object[]{patient.getDocument(), ex.getMessage(), ex});
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadVCF(Patient patient) {
        HttpPost method = null;
        try {
            MultipartEntityBuilder data = MultipartEntityBuilder.create();
            PatientData identifiers = patient.getData("identifiers");
            String url = this.getMethodURL("UploadManager", "upload");
            String eid = (String)identifiers.get("external_id");
            XWikiContext context = Utils.getContext();
            XWikiDocument doc = context.getWiki().getDocument(patient.getDocument(), context);
            method = new HttpPost(url);
            boolean hasData = false;
            for (XWikiAttachment attachment : doc.getAttachmentList()) {
                if (!StringUtils.endsWithIgnoreCase((CharSequence)attachment.getFilename(), (CharSequence)".vcf") || !this.isCorrectVCF(attachment, eid, context)) continue;
                data.addBinaryBody(patient.getId() + ".vcf", attachment.getContentInputStream(context));
                hasData = true;
            }
            if (hasData) {
                method.setEntity(data.build());
                this.client.execute((HttpUriRequest)method).close();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to upload VCF for patient [{}]: {}", new Object[]{patient.getDocument(), ex.getMessage(), ex});
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JSONArray> getPatientVariants(Patient patient) {
        HttpPost method = null;
        LinkedList<JSONArray> result = new LinkedList<JSONArray>();
        try {
            PatientData identifiers = patient.getData("identifiers");
            String eid = (String)identifiers.get("external_id");
            String url = this.getMethodURL(VARIANT_MANAGER, "getVariants");
            method = new HttpPost(url);
            JSONArray parameters = new JSONArray();
            parameters.add((Object)this.projectID);
            parameters.add((Object)0);
            JSONArray conditions = new JSONArray();
            JSONArray dnaIDConditions = new JSONArray();
            dnaIDConditions.add((Object)this.makeCondition(0, "BinaryCondition", "equalTo", "dna_id", eid));
            conditions.add((Object)dnaIDConditions);
            parameters.add((Object)conditions);
            parameters.add((Object)-1);
            parameters.add((Object)-1);
            for (Integer refID : this.referenceIDs) {
                parameters.set(1, (Object)refID);
                parameters.getJSONArray(2).getJSONArray(0).getJSONObject(0).put((Object)"refId", (Object)refID);
                String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
                method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
                CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);
                Throwable throwable = null;
                try {
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    JSONArray results = (JSONArray)JSONSerializer.toJSON((Object)response);
                    result.addAll((Collection<JSONArray>)results);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (httpResponse == null) continue;
                    if (throwable != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    httpResponse.close();
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get variants for patient [{}]: {}", new Object[]{patient.getDocument(), ex.getMessage(), ex});
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JSONArray> getFilteredVariants(Patient patient) {
        HttpPost method = null;
        LinkedList<JSONArray> result = new LinkedList<JSONArray>();
        try {
            for (Integer refID : this.referenceIDs) {
                PatientData identifiers = patient.getData("identifiers");
                String eid = (String)identifiers.get("external_id");
                String url = this.getMethodURL(VARIANT_MANAGER, "getVariants");
                method = new HttpPost(url);
                JSONArray parameters = new JSONArray();
                parameters.add((Object)this.projectID);
                parameters.add((Object)refID);
                parameters.add((Object)this.getFilteredVariantsConditions(refID, eid));
                parameters.add((Object)-1);
                parameters.add((Object)-1);
                String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
                method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
                CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);
                Throwable throwable = null;
                try {
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    JSONArray results = (JSONArray)JSONSerializer.toJSON((Object)response);
                    result.addAll((Collection<JSONArray>)results);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (httpResponse == null) continue;
                    if (throwable != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    httpResponse.close();
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get filtered variants for patient [{}]: {}", new Object[]{patient.getDocument(), ex.getMessage(), ex});
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    private String getMethodURL(String service, String method) {
        String result = (String)this.configuration.getProperty("phenotips.medsavant.baseUrl", (Object)"http://localhost:8080/medsavant-json-client/");
        return result + service + "/" + method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Integer getProjectID() {
        HttpPost method = null;
        String projectName = (String)this.configuration.getProperty("phenotips.medsavant.projectName", (Object)"pc");
        try {
            Integer n;
            Throwable throwable;
            CloseableHttpResponse httpResponse;
            block18: {
                block19: {
                    String url = this.getMethodURL(PROJECT_MANAGER, "getProjectID");
                    method = new HttpPost(url);
                    JSONArray parameters = new JSONArray();
                    parameters.add((Object)projectName);
                    String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
                    method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    Integer id = Integer.valueOf(response);
                    Integer n2 = n = id >= 0 ? id : null;
                    if (httpResponse == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block18;
                }
                httpResponse.close();
            }
            return n;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (httpResponse != null) {
                            if (throwable != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                httpResponse.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Failed to get the ID of the project [{}]: {}", new Object[]{projectName, ex.getMessage(), ex});
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Collection<Integer> getReferenceIDs() {
        Collection collection;
        Throwable throwable;
        CloseableHttpResponse httpResponse;
        HttpPost method;
        block20: {
            block18: {
                block19: {
                    method = null;
                    String url = this.getMethodURL(PROJECT_MANAGER, "getReferenceIDsForProject");
                    method = new HttpPost(url);
                    JSONArray parameters = new JSONArray();
                    parameters.add((Object)this.projectID);
                    String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
                    method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
                    httpResponse = this.client.execute((HttpUriRequest)method);
                    throwable = null;
                    String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                    JSONArray ids = (JSONArray)JSONSerializer.toJSON((Object)response);
                    JsonConfig config = new JsonConfig();
                    config.setCollectionType(Set.class);
                    collection = JSONArray.toCollection((JSONArray)ids, (JsonConfig)config);
                    if (httpResponse == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block18;
                }
                httpResponse.close();
            }
            if (method == null) break block20;
            method.releaseConnection();
        }
        return collection;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (httpResponse != null) {
                                if (throwable != null) {
                                    try {
                                        httpResponse.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    httpResponse.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn("Failed to get the reference IDs: {}", (Object)ex.getMessage(), (Object)ex);
                        if (method != null) {
                            method.releaseConnection();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (method != null) {
                        method.releaseConnection();
                    }
                    throw throwable4;
                }
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAnnotationColumnName(Integer refID, String programName, String subtype) {
        String alias = programName + ", " + subtype;
        if (this.annotationColumns.containsKey(alias)) {
            return this.annotationColumns.get(alias);
        }
        HttpPost method = null;
        try {
            String url = this.getMethodURL("AnnotationManager", "getAnnotationFormats");
            method = new HttpPost(url);
            JSONArray parameters = new JSONArray();
            parameters.add((Object)this.projectID);
            parameters.add((Object)refID);
            String body = REQUEST_PARAMETER + URLEncoder.encode(parameters.toString(), ENCODING);
            method.setEntity((HttpEntity)new StringEntity(body, REQUEST_CONTENT_TYPE));
            try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)method);){
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8);
                JSONArray annotations = (JSONArray)JSONSerializer.toJSON((Object)response);
                for (int i = 0; i < annotations.size(); ++i) {
                    JSONObject annotation = annotations.getJSONObject(i);
                    String program = annotation.getString("program");
                    if (!program.startsWith(programName + " ")) continue;
                    JSONArray fields = annotation.getJSONArray("fields");
                    for (int j = 0; j < fields.size(); ++j) {
                        String currentAlias = fields.getJSONObject(j).getString("alias");
                        if (!StringUtils.equals((CharSequence)currentAlias, (CharSequence)alias)) continue;
                        String name = fields.getJSONObject(j).getString("name");
                        this.annotationColumns.put(alias, name);
                        String string = name;
                        return string;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to get the annotation column for [{}]: {}", new Object[]{programName, ex.getMessage(), ex});
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return "";
    }

    private JSONArray getFilteredVariantsConditions(Integer refID, String patientId) {
        String thousandGColumn = this.getAnnotationColumnName(refID, "1000g2012apr_all", "Score");
        LinkedList<JSONObject> thousandGConditions = new LinkedList<JSONObject>();
        thousandGConditions.add(this.makeCondition(refID, "BinaryCondition", "lessThan", thousandGColumn, 0.01, true));
        thousandGConditions.add(this.makeCondition(refID, "UnaryCondition", "isNull", thousandGColumn));
        String poliphenColumn = this.getAnnotationColumnName(refID, "ljb2_pp2hvar", "Score");
        LinkedList<JSONObject> poliphenConditions = new LinkedList<JSONObject>();
        poliphenConditions.add(this.makeCondition(refID, "BinaryCondition", "greaterThan", poliphenColumn, 0.2, true));
        poliphenConditions.add(this.makeCondition(refID, "UnaryCondition", "isNull", poliphenColumn));
        JSONArray conditions = new JSONArray();
        for (JSONObject thousandGCondition : thousandGConditions) {
            for (JSONObject poliphenCondition : poliphenConditions) {
                JSONArray conditionsRow = new JSONArray();
                conditionsRow.add((Object)this.makeCondition(refID, "BinaryCondition", "equalTo", "dna_id", patientId));
                conditionsRow.add((Object)this.makeCondition(refID, "BinaryCondition", "greaterThan", "qual", 30.0, true));
                for (String effect : IGNORED_EFFECTS) {
                    conditionsRow.add((Object)this.makeCondition(refID, "BinaryCondition", "notEqualTo", "effect", effect));
                }
                conditionsRow.add((Object)thousandGCondition);
                conditionsRow.add((Object)poliphenCondition);
                conditions.add((Object)conditionsRow);
            }
        }
        return conditions;
    }

    private JSONObject makeCondition(Integer refID, String type, String method, Object ... args) {
        JSONObject result = new JSONObject();
        result.put((Object)"projectId", (Object)this.projectID);
        result.put((Object)"refId", (Object)refID);
        result.put((Object)"type", (Object)type);
        result.put((Object)"method", (Object)method);
        JSONArray values = new JSONArray();
        for (Object arg : args) {
            values.add(arg);
        }
        result.put((Object)"args", (Object)values);
        return result;
    }

    private boolean isCorrectVCF(XWikiAttachment attachment, String eid, XWikiContext context) throws XWikiException, IOException {
        String line;
        BufferedReader in = IOUtils.toBufferedReader((Reader)new InputStreamReader(attachment.getContentInputStream(context), ENCODING));
        while ((line = in.readLine()) != null) {
            String[] fields;
            if (line.startsWith("##")) continue;
            if (!line.startsWith("#CHROM") || (fields = line.split("\t")).length != 10 || !StringUtils.equals((CharSequence)eid, (CharSequence)fields[9])) break;
            return true;
        }
        return false;
    }
}

