/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.tools.jetty.listener;

import java.awt.Desktop;
import java.awt.HeadlessException;
import java.net.URI;
import java.util.ResourceBundle;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenBrowserListener
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private static final Logger LOGGER = Log.getLogger(OpenBrowserListener.class);
    private static final ResourceBundle TRANSLATION = ResourceBundle.getBundle(OpenBrowserListener.class.getCanonicalName());

    public void lifeCycleStarted(LifeCycle event) {
        boolean success;
        block8: {
            success = false;
            String serverUrl = "http://localhost:" + System.getProperty("jetty.port", "8080") + "/";
            LOGGER.info(TRANSLATION.getString("jetty.startup.notification"), new Object[]{serverUrl});
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            desktop.browse(new URI(serverUrl));
                            success = true;
                        }
                        catch (Exception e) {
                            LOGGER.warn(TRANSLATION.getString("jetty.browser.error"), (Throwable)e);
                        }
                        break block8;
                    }
                    LOGGER.warn(TRANSLATION.getString("jetty.action.error"), new Object[0]);
                }
                catch (HeadlessException e) {
                    LOGGER.warn(TRANSLATION.getString("jetty.headless.error"), new Object[0]);
                }
            } else {
                LOGGER.warn(TRANSLATION.getString("jetty.noAPI.error"), new Object[0]);
            }
        }
        if (success) {
            LOGGER.info(TRANSLATION.getString("jetty.success.notification"), new Object[0]);
        }
    }
}

