/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.studies.family.rest.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.phenotips.rest.Autolinker;
import org.phenotips.studies.family.Family;
import org.phenotips.studies.family.FamilyTools;
import org.phenotips.studies.family.rest.PatientFamilyResource;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;

@Component
@Named(value="org.phenotips.studies.family.rest.internal.DefaultPatientFamilyResourceImpl")
@Singleton
public class DefaultPatientFamilyResourceImpl
extends XWikiResource
implements PatientFamilyResource {
    @Inject
    private Logger logger;
    @Inject
    private FamilyTools familyTools;
    @Inject
    private Provider<Autolinker> autolinker;

    @Override
    public Response getFamily(String id) {
        this.logger.debug("Retrieving patient [{}] family information via REST", (Object)id);
        Family family = this.familyTools.getFamilyForPatient(id);
        if (family == null) {
            this.logger.debug("No patint with id [{}] or the patient has no family", (Object)id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        JSONObject json = family.toJSON();
        json.put("links", ((Autolinker)this.autolinker.get()).forResource(this.getClass(), this.uriInfo).build());
        return Response.ok((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }
}

