/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.studies.family.rest.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.phenotips.rest.Autolinker;
import org.phenotips.studies.family.Family;
import org.phenotips.studies.family.FamilyRepository;
import org.phenotips.studies.family.FamilyTools;
import org.phenotips.studies.family.rest.FamilyResource;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.users.User;
import org.xwiki.users.UserManager;

@Component
@Named(value="org.phenotips.studies.family.rest.internal.DefaultFamilyResourceImpl")
@Singleton
public class DefaultFamilyResourceImpl
extends XWikiResource
implements FamilyResource {
    private static final String NO_SUCH_FAMILY_ERROR_MESSAGE = "No such family record: [{}]";
    @Inject
    private Logger logger;
    @Inject
    private FamilyRepository repository;
    @Inject
    private AuthorizationManager access;
    @Inject
    private UserManager users;
    @Inject
    private FamilyTools familyTools;
    @Inject
    private Provider<Autolinker> autolinker;

    @Override
    public Response getFamily(String id) {
        this.logger.warn("Retrieving family record [{}] via REST", (Object)id);
        Family family = this.repository.getFamilyById(id);
        if (family == null) {
            this.logger.warn(NO_SUCH_FAMILY_ERROR_MESSAGE, (Object)id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        User currentUser = this.users.getCurrentUser();
        if (!this.access.hasAccess(Right.VIEW, currentUser == null ? null : currentUser.getProfileDocument(), (EntityReference)family.getDocumentReference())) {
            this.logger.error("View access denied to user [{}] on family record [{}]", (Object)currentUser, (Object)id);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        JSONObject json = family.toJSON();
        json.put("links", ((Autolinker)this.autolinker.get()).forResource(this.getClass(), this.uriInfo).build());
        return Response.ok((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response deleteFamily(String id, Boolean deleteMembers) {
        this.logger.warn("Deleting family record [{}] via REST, deleteAllMembers = [{}]", (Object)id, (Object)deleteMembers);
        Family family = this.repository.getFamilyById(id);
        if (family == null) {
            this.logger.warn(NO_SUCH_FAMILY_ERROR_MESSAGE, (Object)id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.familyTools.currentUserCanDeleteFamily(id, deleteMembers.booleanValue())) {
            this.logger.error("Delete access denied to user [{}] for family record [{}] with deleteMemebers=[{}]", new Object[]{this.users.getCurrentUser(), id, deleteMembers});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!this.familyTools.deleteFamily(id, deleteMembers.booleanValue())) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        this.logger.warn("Deleted family record [{}]", (Object)id);
        return Response.noContent().build();
    }
}

