/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.studies.family.rest.internal;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.phenotips.studies.family.Family;
import org.phenotips.studies.family.FamilyTools;
import org.phenotips.studies.family.rest.FamiliesResource;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.XWikiResource;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.users.User;
import org.xwiki.users.UserManager;

@Component
@Named(value="org.phenotips.studies.family.rest.internal.DefaultFamiliesResourceImpl")
@Singleton
public class DefaultFamiliesResourceImpl
extends XWikiResource
implements FamiliesResource {
    private static final String METADATA_FIELD_NAME = "metadata";
    private static final String DATA_FIELD_NAME = "data";
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queries;
    @Inject
    private AuthorizationManager access;
    @Inject
    private UserManager users;
    @Inject
    private FamilyTools familyTools;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<EntityReference> currentResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> stringResolver;

    @Override
    public Response addFamily(String json) {
        this.logger.error("Importing new family from JSON via REST: {}", (Object)json);
        User currentUser = this.users.getCurrentUser();
        if (!this.access.hasAccess(Right.EDIT, currentUser == null ? null : currentUser.getProfileDocument(), this.currentResolver.resolve((Object)Family.DATA_SPACE, EntityType.SPACE, new Object[0]))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (json == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            JSONObject jsonInput = new JSONObject(json);
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            Family family = this.familyTools.createFamily();
            URI targetURI = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(FamiliesResource.class).build(new Object[]{family.getId()});
            Response.ResponseBuilder response = Response.created((URI)targetURI);
            return response.build();
        }
        catch (Exception ex) {
            this.logger.error("Could not process family creation request: {}", (Object)ex.getMessage(), (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Override
    public Response listFamilies(Integer start, Integer number, Boolean fullJSON) {
        this.logger.debug("Listing families via REST, start: {} number: {}, fullJSON: {}", new Object[]{start, number, fullJSON});
        long startTime = System.nanoTime();
        try {
            String safeOrderField = "doc.name";
            String safeOrder = " asc";
            Query query = this.queries.createQuery("select doc.name, family.external_id, doc.creator, doc.creationDate, doc.version, doc.author, doc.date from Document doc, doc.object(PhenoTips.FamilyClass) as family where doc.name <> :t order by " + safeOrderField + safeOrder, "xwql");
            query.bindValue("t", (Object)"FamilyTemplate");
            JSONArray familyList = new JSONArray();
            List records = query.execute();
            User currentUser = this.users.getCurrentUser();
            DocumentReference userProfileDocument = currentUser == null ? null : currentUser.getProfileDocument();
            int total = 0;
            int skipped = 0;
            for (Object[] record : records) {
                String familyID = (String)record[0];
                this.logger.debug("REST: Found family: {}", (Object)familyID);
                if (!this.validateSummaryObject(record)) {
                    this.logger.debug("REST: Skipping family, misformatted data");
                    continue;
                }
                if (!this.hasViewRights(familyID, userProfileDocument)) {
                    this.logger.debug("REST: Skipping family, no view rights for the user");
                    continue;
                }
                ++total;
                if (++skipped <= start || familyList.length() >= number) continue;
                this.addRecordToList(familyList, fullJSON, familyID, record);
            }
            JSONObject metadata = new JSONObject();
            metadata.put("totalVisibleFamilies", total);
            metadata.put("returnedFamilies", familyList.length());
            metadata.put("requestedPageSize", (Object)number);
            JSONObject response = new JSONObject();
            response.put(METADATA_FIELD_NAME, (Object)metadata);
            response.put(DATA_FIELD_NAME, (Object)familyList);
            this.logger.debug("Time to complete request: {} ms", (Object)Math.round((System.nanoTime() - startTime) / 1000000L));
            return Response.ok((Object)response, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception ex) {
            this.logger.error("Failed to list families: {}", (Object)ex.getMessage(), (Object)ex);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void addRecordToList(JSONArray familyList, Boolean fullJSON, String familyID, Object[] summaryData) {
        try {
            JSONObject familyJSON = fullJSON != false ? this.getFullFamilyJSON(familyID, summaryData, this.uriInfo) : this.getFamilySummaryJSON(summaryData, this.uriInfo);
            if (familyJSON != null) {
                familyList.put((Object)familyJSON);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error creating family JSON for family {}: {}", (Object)familyID, (Object)ex);
        }
    }

    private JSONObject getFullFamilyJSON(String familyID, Object[] summaryData, UriInfo uriInfo) {
        Family family = this.familyTools.getFamilyById(familyID);
        if (family != null) {
            JSONObject familyJSON = family.toJSON();
            this.addMetadata(familyJSON, summaryData);
            return familyJSON;
        }
        return null;
    }

    private JSONObject getFamilySummaryJSON(Object[] summaryData, UriInfo uriInfo) {
        JSONObject familySummary = new JSONObject();
        familySummary.put("id", (Object)StringUtils.defaultString((String)((String)summaryData[0])));
        familySummary.put("externalId", (Object)StringUtils.defaultString((String)((String)summaryData[1])));
        this.addMetadata(familySummary, summaryData);
        return familySummary;
    }

    private void addMetadata(JSONObject json, Object[] summaryData) {
        JSONObject metaData = new JSONObject();
        metaData.put("createdBy", (Object)String.valueOf(summaryData[2]));
        metaData.put("lastModifiedBy", (Object)String.valueOf(summaryData[5]));
        metaData.put("version", (Object)String.valueOf(summaryData[4]));
        metaData.put("createdOn", (Object)new DateTime(summaryData[3]));
        metaData.put("lastModifiedOn", (Object)new DateTime(summaryData[6]));
        json.put(METADATA_FIELD_NAME, (Object)metaData);
    }

    private boolean validateSummaryObject(Object[] summaryData) {
        return summaryData != null && summaryData.length == 7 && summaryData[3] instanceof Date && summaryData[6] instanceof Date;
    }

    private boolean hasViewRights(String familyID, DocumentReference userProfileDocument) {
        DocumentReference doc = this.stringResolver.resolve((Object)String.valueOf(familyID), new Object[]{Family.DATA_SPACE});
        return this.access.hasAccess(Right.VIEW, userProfileDocument, (EntityReference)doc);
    }
}

