/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.configuration.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="R45392Phenotips#438")
@Singleton
public class R45392PhenoTips438DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;

    public String getDescription() {
        return "Migrate existing old configuration-related objects from the ClinicalInformationCode space to the new PhenoTips space";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(45392);
    }

    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new MigrateObjectsCallback("DBConfigurationClass"));
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new MigrateObjectsCallback("MenuConfigurationClass"));
    }

    private class MigrateObjectsCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private final String className;

        public MigrateObjectsCallback(String className) {
            this.className = className;
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            XWikiContext context = R45392PhenoTips438DataMigration.this.getXWikiContext();
            XWiki xwiki = context.getWiki();
            DocumentReference oldClassReference = new DocumentReference(context.getDatabase(), "ClinicalInformationCode", this.className);
            DocumentReference newClassReference = new DocumentReference(context.getDatabase(), "PhenoTips", this.className);
            String localOldClassName = (String)R45392PhenoTips438DataMigration.this.serializer.serialize((EntityReference)oldClassReference, new Object[0]);
            Query q = session.createQuery("select distinct o.name from BaseObject o where o.className = '" + localOldClassName + "'");
            List documents = q.list();
            for (String docName : documents) {
                XWikiDocument doc = xwiki.getDocument(R45392PhenoTips438DataMigration.this.resolver.resolve((Object)docName, new Object[0]), context);
                for (BaseObject oldObject : doc.getXObjects(oldClassReference)) {
                    BaseObject newObject = oldObject.duplicate();
                    newObject.setXClassReference((EntityReference)newClassReference);
                    doc.addXObject(newObject);
                }
                String configurableClassProperty = "configurationClass";
                BaseObject configurable = doc.getXObject(new DocumentReference(context.getDatabase(), "XWiki", "ConfigurableClass"), configurableClassProperty, localOldClassName, false);
                if (configurable != null) {
                    configurable.set(configurableClassProperty, R45392PhenoTips438DataMigration.this.serializer.serialize((EntityReference)newClassReference, new Object[0]), context);
                }
                doc.removeXObjects(oldClassReference);
                doc.setContent("");
                doc.setComment("Migrated configuration data in class " + this.className);
                doc.setMinorEdit(true);
                doc.setMetaDataDirty(false);
                doc.setContentDirty(false);
                try {
                    session.clear();
                    ((XWikiHibernateStore)R45392PhenoTips438DataMigration.this.getStore()).saveXWikiDoc(doc, context, false);
                    session.flush();
                }
                catch (DataMigrationException e) {}
            }
            return null;
        }
    }
}

